/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KClusterAttributes {
    @Tunable(description="Estimate k using silhouette", groups={"K-Cluster parameters"}, gravity=1.0)
    public boolean useSilhouette = false;
    @Tunable(description="Maximum number of clusters", groups={"K-Cluster parameters"}, dependsOn="useSilhouette=true", gravity=2.0)
    public int kMax = 0;
    @Tunable(description="Number of clusters", groups={"K-Cluster parameters"}, dependsOn="useSilhouette=false", gravity=3.0)
    public int kNumber = 0;
    @Tunable(description="Initialize cluster centers from most central elements", groups={"K-Cluster parameters"}, gravity=4.0)
    public boolean initializeNearCenter = false;

    public void updateKEstimates(CyNetwork network, boolean selectedOnly) {
        double kinit;
        int selNodes;
        double nodeCount = network.getNodeCount();
        if (selectedOnly && (selNodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true).size()) > 0) {
            nodeCount = selNodes;
        }
        this.kNumber = (kinit = Math.sqrt(nodeCount / 2.0)) > 1.0 ? (int)kinit : 1;
        this.kMax = (int)kinit * 2;
    }

    public void addParams(List<String> params) {
        params.add("useSilhouette=" + this.useSilhouette);
        params.add("kMax=" + this.kMax);
        params.add("kNumber=" + this.kNumber);
        params.add("initializeNearCenter=" + this.initializeNearCenter);
    }
}

