/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matrix
extends BaseMatrix {
    private CyNode[] rowNodes;
    private CyNode[] columnNodes;
    private CyNetwork network;
    protected boolean ignoreMissing;
    protected boolean selectedOnly;

    public Matrix(CyNetwork network, String[] weightAttributes, boolean transpose, boolean ignoreMissing, boolean selectedOnly) {
        this.transpose = transpose;
        this.ignoreMissing = ignoreMissing;
        this.selectedOnly = selectedOnly;
        this.network = network;
        String[] attributeArray = new String[weightAttributes.length];
        if (weightAttributes.length >= 1 && weightAttributes[0].startsWith("node.")) {
            for (int i = 0; i < weightAttributes.length; ++i) {
                attributeArray[i] = weightAttributes[i].substring(5);
            }
            this.buildGeneArrayMatrix(network, attributeArray, transpose, ignoreMissing, selectedOnly);
            this.symmetrical = false;
        } else if (weightAttributes.length == 1 && weightAttributes[0].startsWith("edge.")) {
            this.buildSymmetricalMatrix(network, weightAttributes[0].substring(5), ignoreMissing, selectedOnly);
            this.symmetrical = true;
        } else {
            return;
        }
    }

    public Matrix(Matrix duplicate) {
        this.nRows = duplicate.nRows();
        this.nColumns = duplicate.nColumns();
        this.matrix = new Double[this.nRows][this.nColumns];
        this.colWeights = new double[this.nColumns];
        this.rowWeights = new double[this.nRows];
        this.columnLabels = new String[this.nColumns];
        this.rowLabels = new String[this.nRows];
        this.ignoreMissing = duplicate.ignoreMissing;
        this.selectedOnly = duplicate.selectedOnly;
        this.network = duplicate.network;
        this.rowNodes = null;
        this.columnNodes = null;
        if (duplicate.getRowNode(0) != null) {
            this.rowNodes = new CyNode[this.nRows];
        } else {
            this.columnNodes = new CyNode[this.nColumns];
        }
        this.transpose = duplicate.transpose;
        for (int row = 0; row < this.nRows; ++row) {
            this.rowWeights[row] = duplicate.getRowWeight(row);
            this.rowLabels[row] = duplicate.getRowLabel(row);
            if (this.rowNodes != null) {
                this.rowNodes[row] = duplicate.getRowNode(row);
            }
            for (int col = 0; col < this.nColumns; ++col) {
                if (row == 0) {
                    this.colWeights[col] = duplicate.getColWeight(col);
                    this.columnLabels[col] = duplicate.getColLabel(col);
                    if (this.columnNodes != null) {
                        this.columnNodes[col] = duplicate.getColNode(col);
                    }
                }
                if (duplicate.getValue(row, col) == null) continue;
                this.matrix[row][col] = new Double(duplicate.getValue(row, col));
            }
        }
    }

    public Matrix(CyNetwork network, int rows, int cols) {
        this.nRows = rows;
        this.nColumns = cols;
        this.matrix = new Double[rows][cols];
        this.colWeights = new double[cols];
        this.rowWeights = new double[rows];
        this.columnLabels = new String[cols];
        this.rowLabels = new String[rows];
        this.rowNodes = null;
        this.columnNodes = null;
        this.transpose = false;
        this.ignoreMissing = false;
        this.selectedOnly = false;
        this.network = network;
    }

    public void setRowNodes(CyNode[] newRowNodes) {
        this.rowNodes = newRowNodes;
    }

    public void setColumnNodes(CyNode[] newColumnNodes) {
        this.columnNodes = newColumnNodes;
    }

    public CyNode getRowNode(int row) {
        if (this.rowNodes != null) {
            return this.rowNodes[row];
        }
        return null;
    }

    public CyNode getColNode(int col) {
        if (this.columnNodes != null) {
            return this.columnNodes[col];
        }
        return null;
    }

    private void buildSymmetricalMatrix(CyNetwork network, String weight, boolean ignoreMissing, boolean selectedOnly) {
        CyTable edgeAttributes = network.getDefaultEdgeTable();
        List<CyNode> nodeList = network.getNodeList();
        nodeList = this.sortNodeList(nodeList);
        this.nColumns = this.nRows = nodeList.size();
        this.matrix = new Double[this.nRows][this.nColumns];
        this.rowLabels = new String[this.nRows];
        this.columnLabels = new String[this.nColumns];
        this.rowNodes = new CyNode[this.nRows];
        this.columnNodes = null;
        this.maxAttribute = Double.MIN_VALUE;
        int index = 0;
        Class attributeType = edgeAttributes.getColumn(weight).getType();
        for (CyNode node : nodeList) {
            boolean found = false;
            boolean hasSelectedEdge = false;
            this.rowLabels[index] = this.getNodeName(node, network);
            this.rowNodes[index] = node;
            this.columnLabels[index] = this.getNodeName(node, network);
            List edgeList = network.getAdjacentEdgeList(node, CyEdge.Type.ANY);
            for (CyEdge edge : edgeList) {
                int column;
                if (selectedOnly && !((Boolean)edgeAttributes.getRow((Object)edge.getSUID()).get("SELECTED", Boolean.class)).booleanValue()) continue;
                hasSelectedEdge = true;
                Double val = ModelUtils.getNumericValue(network, (CyIdentifiable)edge, weight);
                if (val == null) continue;
                found = true;
                this.maxAttribute = Math.max(this.maxAttribute, val);
                if (edge.getSource() == node) {
                    column = nodeList.indexOf(edge.getTarget());
                    this.matrix[index][column] = val;
                    continue;
                }
                column = nodeList.indexOf(edge.getSource());
                this.matrix[index][column] = val;
            }
            if (ignoreMissing && !found || selectedOnly && !hasSelectedEdge) continue;
            ++index;
        }
        if (ignoreMissing) {
            this.nRows = index;
            this.nColumns = index;
        }
    }

    public void buildDistanceMatrix(DistanceMatrix distanceMatrix) {
        this.nColumns = this.nRows = distanceMatrix.getNodes().size();
        this.matrix = new Double[this.nRows][this.nColumns];
        this.maxAttribute = Double.MIN_VALUE;
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = i; j < this.nRows; ++j) {
                this.matrix[i][j] = distanceMatrix.getEdgeValueFromMatrix(i, j);
            }
        }
    }

    public double[][] getMatrix2DArray() {
        double[][] matrixArray = new double[this.nRows][this.nColumns];
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = i; j < this.nColumns; ++j) {
                if (this.matrix[i][j] != null) {
                    matrixArray[i][j] = this.matrix[i][j];
                    matrixArray[j][i] = this.matrix[i][j];
                    continue;
                }
                matrixArray[i][j] = 0.0;
                matrixArray[j][i] = 0.0;
            }
        }
        return matrixArray;
    }

    private void buildGeneArrayMatrix(CyNetwork network, String[] weightAttributes, boolean transpose, boolean ignoreMissing, boolean selectedOnly) {
        List<CyNode> nodeList = network.getNodeList();
        if (selectedOnly) {
            nodeList = new ArrayList<CyNode>(CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true));
        }
        nodeList = this.sortNodeList(nodeList);
        HashMap nodeCondMap = new HashMap();
        List<String> condList = Arrays.asList(weightAttributes);
        CyTable nodeAttributes = network.getDefaultNodeTable();
        for (CyNode node : nodeList) {
            HashMap<String, Double> thisCondMap = new HashMap<String, Double>();
            for (int attrIndex = 0; attrIndex < weightAttributes.length; ++attrIndex) {
                String attr = weightAttributes[attrIndex];
                Double value = null;
                if (nodeAttributes.getColumn(attr).getType() == Integer.class) {
                    Integer intVal = (Integer)nodeAttributes.getRow((Object)node.getSUID()).get(attr, Integer.class);
                    if (intVal != null) {
                        value = intVal.doubleValue();
                    }
                } else if (nodeAttributes.getColumn(attr).getType() == Long.class) {
                    Long longVal = (Long)nodeAttributes.getRow((Object)node.getSUID()).get(attr, Long.class);
                    if (longVal != null) {
                        value = longVal.doubleValue();
                    }
                } else if (nodeAttributes.getColumn(attr).getType() == Float.class) {
                    Float floatVal = (Float)nodeAttributes.getRow((Object)node.getSUID()).get(attr, Float.class);
                    if (floatVal != null) {
                        value = floatVal.doubleValue();
                    }
                } else {
                    if (nodeAttributes.getColumn(attr).getType() != Double.class) continue;
                    value = (Double)nodeAttributes.getRow((Object)node.getSUID()).get(attr, Double.class);
                }
                if (ignoreMissing && value == null) continue;
                thisCondMap.put(attr, value);
            }
            if (ignoreMissing && thisCondMap.size() <= 0) continue;
            nodeCondMap.put(node, thisCondMap);
        }
        if (transpose) {
            this.nRows = condList.size();
            this.nColumns = nodeCondMap.size();
            this.matrix = new Double[this.nRows][this.nColumns];
            this.rowLabels = new String[this.nRows];
            this.columnLabels = new String[this.nColumns];
            this.columnNodes = new CyNode[this.nColumns];
            this.setRowLabels(condList);
            int column = 0;
            for (CyNode node : nodeList) {
                if (!nodeCondMap.containsKey(node)) continue;
                Map thisCondMap = (Map)nodeCondMap.get(node);
                this.columnLabels[column] = this.getNodeName(node, network);
                this.columnNodes[column] = node;
                for (int row = 0; row < this.nRows; ++row) {
                    String rowLabel = this.rowLabels[row];
                    if (!thisCondMap.containsKey(rowLabel)) continue;
                    this.matrix[row][column] = (Double)thisCondMap.get(rowLabel);
                }
                ++column;
            }
        } else {
            this.nRows = nodeCondMap.size();
            this.nColumns = condList.size();
            this.rowLabels = new String[this.nRows];
            this.rowNodes = new CyNode[this.nRows];
            this.columnLabels = new String[this.nColumns];
            this.matrix = new Double[this.nRows][this.nColumns];
            this.setColumnLabels(condList);
            int row = 0;
            for (CyNode node : nodeList) {
                if (!nodeCondMap.containsKey(node)) continue;
                this.rowLabels[row] = this.getNodeName(node, network);
                this.rowNodes[row] = node;
                Map thisCondMap = (Map)nodeCondMap.get(node);
                for (int column = 0; column < this.nColumns; ++column) {
                    String columnLabel = this.columnLabels[column];
                    if (!thisCondMap.containsKey(columnLabel)) continue;
                    this.matrix[row][column] = (Double)thisCondMap.get(columnLabel);
                }
                ++row;
            }
        }
    }

    private List<CyNode> sortNodeList(List<CyNode> nodeList) {
        HashMap<String, CyNode> nodeMap = new HashMap<String, CyNode>();
        Object[] nodeNames = new String[nodeList.size()];
        int index = 0;
        for (CyNode node : nodeList) {
            nodeNames[index++] = this.getNodeName(node, this.network);
            nodeMap.put(this.getNodeName(node, this.network), node);
        }
        Arrays.sort(nodeNames);
        ArrayList<CyNode> newList = new ArrayList<CyNode>(nodeList.size());
        for (index = 0; index < nodeNames.length; ++index) {
            newList.add((CyNode)nodeMap.get(nodeNames[index]));
        }
        return newList;
    }

    private String getNodeName(CyNode node, CyNetwork network) {
        if (network.containsNode(node)) {
            return (String)network.getRow((CyIdentifiable)node).get("name", String.class);
        }
        return null;
    }
}

