/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.AutoSOMECluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.AutoSOMEContext;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import java.util.Collections;
import java.util.List;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSOMETaskFactory
extends AbstractClusterTaskFactory {
    ClusterManager clusterManager;
    AutoSOMEContext context = new AutoSOMEContext();
    boolean heatmap = true;

    public AutoSOMETaskFactory(ClusterManager clusterManager, boolean heatmap) {
        this.clusterManager = clusterManager;
        this.heatmap = heatmap;
    }

    @Override
    public String getShortName() {
        if (this.heatmap) {
            return "autosome_heatmap";
        }
        return "autosome_network";
    }

    @Override
    public String getName() {
        if (this.heatmap) {
            return "AutoSOME Attribute Clustering";
        }
        return "AutoSOME Network Clustering";
    }

    @Override
    public ClusterViz getVisualizer() {
        return null;
    }

    public boolean isReady() {
        return true;
    }

    @Override
    public List<ClusterTaskFactory.ClusterType> getTypeList() {
        if (this.heatmap) {
            return Collections.singletonList(ClusterTaskFactory.ClusterType.ATTRIBUTE);
        }
        return Collections.singletonList(ClusterTaskFactory.ClusterType.NETWORK);
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new AutoSOMECluster(this.context, this.clusterManager, this.heatmap)});
    }
}

