/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.clustering;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.cluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.clusterRun;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.getClusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ensemble {
    private clusterRun[] cr;
    private boolean general;
    private int clustNum = 0;
    private boolean equalizeNum = true;
    private boolean hierarchical = true;
    private Settings s;
    private boolean[] merged;
    private int[] reLabel;
    private int ave = 0;
    private double[][] consensusMatrix;
    private boolean[][] added;
    private boolean printConsMatrix = false;
    private TaskMonitor monitor;

    public Ensemble(List<clusterRun> clusterRuns, boolean general, int clustNum, boolean equalizeNum, Settings s, TaskMonitor monitor) {
        this.general = general;
        this.monitor = monitor;
        monitor.setStatusMessage("Computing cluster number");
        if (!s.writeTemp) {
            this.cr = new clusterRun[clusterRuns.size()];
            for (int i = 0; i < this.cr.length; ++i) {
                this.cr[i] = clusterRuns.get(i);
            }
        } else {
            this.cr = new clusterRun[1];
        }
        this.clustNum = clustNum;
        this.equalizeNum = equalizeNum;
        this.s = s;
        this.printConsMatrix = s.printConsMatrix;
    }

    public clusterRun run() {
        this.monitor.setStatusMessage("Performing ensemble averaging");
        if (this.equalizeNum) {
            this.getAverage();
            if (!this.s.writeTemp) {
                this.equalizeClusterNumber(this.ave);
            }
        }
        return this.combineRuns();
    }

    private void getAverage() {
        int min = Integer.MAX_VALUE;
        try {
            int runs = 0;
            File[] f = new File[1];
            if (this.s.writeTemp) {
                f = new File(this.s.outputDirectory + this.s.getFolderDivider() + this.s.getName() + "_temp").listFiles();
                runs = f.length;
            } else {
                runs = this.cr.length;
            }
            for (int i = 0; i < runs; ++i) {
                clusterRun cRun = new clusterRun();
                if (this.s.writeTemp) {
                    FileInputStream fis = new FileInputStream(f[i]);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    cRun = (clusterRun)ois.readObject();
                } else {
                    cRun = this.cr[i];
                }
                if (min > cRun.nodes.length) {
                    min = cRun.nodes.length;
                }
                getClusters gc = new getClusters(cRun, this.s);
                gc.findClusters(this.general);
                cRun.c = gc.getClust();
                if (this.s.writeTemp && i == 0) {
                    this.cr[0] = cRun;
                }
                this.ave += cRun.c.length;
            }
            this.ave /= runs;
            if (this.clustNum > 0) {
                this.ave = this.clustNum;
            }
            if (this.ave > min) {
                this.ave = min;
            }
        }
        catch (Exception err) {
            System.err.println(err);
        }
    }

    private void equalizeClusterNumber(int ave) {
        int runs = this.cr.length;
        for (int i = 0; i < runs; ++i) {
            clusterRun cRun = this.cr[i];
            cRun = this.cr[i];
            cRun = this.DoEqualize(cRun);
        }
    }

    private clusterRun DoEqualize(clusterRun cRun) {
        int index;
        if (this.s.writeTemp) {
            getClusters gc = new getClusters(cRun, this.s);
            gc.findClusters(this.general);
            cRun.c = gc.getClust();
        }
        boolean[] validEdges = new boolean[cRun.edges.length];
        for (int k = 0; k < validEdges.length; ++k) {
            validEdges[k] = true;
        }
        cRun.edgeSort();
        for (index = 0; index < cRun.edges.length && !(cRun.edges[index][2] > cRun.thresh * cRun.edges[cRun.edges.length - 1][2]); ++index) {
        }
        index += cRun.c.length - this.ave;
        while (index < validEdges.length) {
            validEdges[index] = false;
            ++index;
        }
        getClusters gc = new getClusters(cRun, validEdges, this.s);
        gc.findClusters(this.general);
        cRun.c = gc.getClust();
        Arrays.sort(cRun.c);
        return cRun;
    }

    private clusterRun combineRuns() {
        if (this.s.distMatrix) {
            int y;
            int w;
            System.out.println("initialize");
            if (this.s.writeTemp) {
                this.cr[0] = this.DoEqualize(this.cr[0]);
            }
            this.consensusMatrix = new double[this.s.input.length][this.s.input.length];
            this.added = new boolean[this.consensusMatrix.length][this.consensusMatrix.length];
            for (w = 0; w < this.added.length; ++w) {
                for (y = 0; y < this.added.length; ++y) {
                    this.added[w][y] = false;
                }
            }
            for (int k = 0; k < this.cr[0].c.length; ++k) {
                for (int i = 0; i < this.cr[0].c[k].ids.size(); ++i) {
                    for (int j = 0; j < this.cr[0].c[k].ids.size(); ++j) {
                        int b;
                        int a = Integer.valueOf(this.cr[0].c[k].ids.get(i).toString());
                        if (this.added[a][b = Integer.valueOf(this.cr[0].c[k].ids.get(j).toString()).intValue()]) continue;
                        double[] dArray = this.consensusMatrix[a];
                        int n = b;
                        dArray[n] = dArray[n] + 1.0;
                        this.added[a][b] = true;
                    }
                }
            }
            for (w = 0; w < this.added.length; ++w) {
                for (y = 0; y < this.added.length; ++y) {
                    this.added[w][y] = false;
                }
            }
        }
        int progressCount = 0;
        int runCount = 0;
        clusterRun mega = new clusterRun();
        try {
            int runs = 0;
            File[] f = new File[1];
            if (this.s.writeTemp) {
                f = new File(this.s.outputDirectory + this.s.getFolderDivider() + this.s.getName() + "_temp").listFiles();
                runs = f.length;
            } else {
                runs = this.cr.length;
            }
            for (int i = 0; i < runs; ++i) {
                clusterRun cRun = new clusterRun();
                if (this.s.writeTemp) {
                    FileInputStream fis = new FileInputStream(f[i]);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    cRun = (clusterRun)ois.readObject();
                    cRun = this.DoEqualize(cRun);
                } else {
                    cRun = this.cr[i];
                }
                if (i == 0) {
                    mega = cRun;
                    mega.makeMembership(this.s);
                    continue;
                }
                this.merged = new boolean[cRun.c.length];
                for (int y = 0; y < this.merged.length; ++y) {
                    this.merged[y] = false;
                }
                this.reLabel = new int[cRun.c.length];
                mega.sumMembership();
                for (int k = 0; k < cRun.c.length; ++k) {
                    double commonPerc = 0.0;
                    int pos = 0;
                    for (int q = 0; q < mega.c.length; ++q) {
                        double comm;
                        if (this.merged[q] || !((comm = this.getCommonPerc(cRun.c[k], mega, q)) >= commonPerc)) continue;
                        commonPerc = comm;
                        pos = q;
                    }
                    this.reLabel[k] = pos;
                    this.merged[pos] = true;
                }
                mega = this.updateFuzzyClusters(mega, this.reLabel, i, cRun);
                this.monitor.setProgress((double)(i + 1) / (double)this.s.ensemble_runs);
                if (!this.s.batch && Math.floor((double)runCount++ % ((double)runs / 10.0)) == 0.0) {
                    ++progressCount;
                }
                if (!this.s.distMatrix) continue;
                for (int w = 0; w < this.added.length; ++w) {
                    for (int y = 0; y < this.added.length; ++y) {
                        this.added[w][y] = false;
                    }
                }
            }
        }
        catch (IOException err) {
            System.err.println(err);
        }
        catch (ClassNotFoundException err2) {
            System.err.println(err2);
        }
        boolean currVal = false;
        if (progressCount < 10 && !this.s.batch) {
            while (progressCount < 10) {
                ++progressCount;
            }
        }
        mega = this.fuzzyCluster(mega);
        getClusters gc = new getClusters(mega, this.s);
        mega.c = gc.getClust();
        if (this.s.distMatrix) {
            this.printConsensusMatrix(mega);
        }
        return mega;
    }

    private double getCommonPerc(cluster p, clusterRun mega, int q) {
        int i;
        double common = 0.0;
        double countClustQ = mega.memTotal[q];
        for (i = 0; i < p.ids.size(); ++i) {
            double weight = mega.membership[Integer.valueOf(p.ids.get(i).toString())][q];
            if (!(weight > 0.0)) continue;
            common += 1.0 + weight;
        }
        if (this.s.distMatrix) {
            for (i = 0; i < p.ids.size(); ++i) {
                for (int j = 0; j < p.ids.size(); ++j) {
                    int b;
                    int a = p.ids.get(i);
                    if (this.added[a][b = p.ids.get(j).intValue()]) continue;
                    double[] dArray = this.consensusMatrix[a];
                    int n = b;
                    dArray[n] = dArray[n] + 1.0;
                    this.added[a][b] = true;
                }
            }
        }
        return common / ((double)p.ids.size() + countClustQ);
    }

    private clusterRun updateFuzzyClusters(clusterRun mega, int[] reLabel, int j, clusterRun cRun) {
        mega.updateFuzzy((double)j / (double)(j + 1));
        for (int i = 0; i < cRun.c.length; ++i) {
            int index = reLabel[i];
            for (int k = 0; k < cRun.c[i].ids.size(); ++k) {
                int id = cRun.c[i].ids.get(k);
                double[] dArray = mega.membership[id];
                int n = index;
                dArray[n] = dArray[n] + 1.0 / (double)(j + 1);
            }
        }
        return mega;
    }

    private clusterRun fuzzyCluster(clusterRun mega) {
        mega.cleanFuzzy();
        for (int i = 0; i < mega.c.length; ++i) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ArrayList<Double> probs = new ArrayList<Double>();
            for (int j = 0; j < mega.membership.length; ++j) {
                if (!(mega.membership[j][i] > 0.0)) continue;
                if (this.s.confidence && (int)(100.0 * mega.membership[j][i]) <= this.s.conf_Thresh) {
                    this.s.discarded.add(j + "," + mega.labelsSorted[j]);
                    continue;
                }
                ids.add(j);
                probs.add(mega.membership[j][i]);
            }
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<Integer> confidence = new ArrayList<Integer>();
            for (int q = 0; q < ids.size(); ++q) {
                confidence.add((int)(100.0 * (Double)probs.get(q)));
            }
            mega.c[i] = new cluster(new ArrayList<double[]>(), labels, ids);
            mega.c[i].setConf(confidence);
        }
        return mega;
    }

    private void printConsensusMatrix(clusterRun mega) {
        int p;
        int i;
        int j;
        clusterRun resolve = new clusterRun();
        resolve.membership = new double[mega.membership.length][mega.membership[0].length];
        for (int i2 = 0; i2 < resolve.membership.length; ++i2) {
            for (j = 0; j < resolve.membership[i2].length; ++j) {
                resolve.membership[i2][j] = mega.membership[i2][j];
            }
        }
        resolve.cleanFuzzy();
        Object[] sbs = new sortBySize[resolve.membership[0].length];
        for (j = 0; j < resolve.membership[0].length; ++j) {
            int size = 0;
            for (int i3 = 0; i3 < resolve.membership.length; ++i3) {
                if (!(resolve.membership[i3][j] > 0.0)) continue;
                ++size;
            }
            sbs[j] = new sortBySize(size, j);
        }
        Arrays.sort(sbs);
        HashMap<Integer, Integer> sorted = new HashMap<Integer, Integer>();
        for (int k = 0; k < sbs.length; ++k) {
            sorted.put(((sortBySize)sbs[k]).id, k + 1);
        }
        ArrayList<String[]> fcn_v = new ArrayList<String[]>();
        ArrayList<String[]> fcn_e = new ArrayList<String[]>();
        for (i = 0; i < this.consensusMatrix.length; ++i) {
            String labelI = new StringTokenizer(mega.labelsSorted[i], ",").nextToken();
            for (int j2 = i + 1; j2 < this.consensusMatrix.length; ++j2) {
                String labelJ = new StringTokenizer(mega.labelsSorted[j2], ",").nextToken();
                double[] dArray = this.consensusMatrix[i];
                int n = j2;
                dArray[n] = dArray[n] / (double)this.cr.length;
                double[] dArray2 = this.consensusMatrix[i];
                int n2 = j2;
                dArray2[n2] = dArray2[n2] - 0.5;
                if (i == j2) continue;
                String[] edge = new String[]{labelI + "_" + i, labelJ + "_" + j2, String.valueOf(this.consensusMatrix[i][j2])};
                fcn_e.add(edge);
            }
        }
        mega.fcn_edges = new String[fcn_e.size()][3];
        for (p = 0; p < mega.fcn_edges.length; ++p) {
            mega.fcn_edges[p] = (String[])fcn_e.get(p);
        }
        for (i = 0; i < resolve.membership[0].length; ++i) {
            for (int j3 = 0; j3 < resolve.membership.length; ++j3) {
                if (!(resolve.membership[j3][i] > 0.0)) continue;
                String label = new StringTokenizer(mega.labelsSorted[j3], ",").nextToken();
                String[] vertex = new String[]{label + "_" + j3, String.valueOf(i), label};
                fcn_v.add(vertex);
            }
        }
        mega.fcn_nodes = new String[fcn_v.size()][3];
        for (p = 0; p < mega.fcn_nodes.length; ++p) {
            mega.fcn_nodes[p] = (String[])fcn_v.get(p);
        }
    }

    private clusterRun removeOutliers(clusterRun mega) {
        int i;
        clusterRun resolve = new clusterRun();
        resolve.membership = new double[mega.membership.length][mega.membership[0].length];
        for (i = 0; i < resolve.membership.length; ++i) {
            for (int j = 0; j < resolve.membership[i].length; ++j) {
                resolve.membership[i][j] = mega.membership[i][j];
            }
        }
        resolve.cleanFuzzy();
        for (i = 0; i < resolve.membership[0].length; ++i) {
            boolean count = false;
            int lastIndex = 0;
            for (int j = 0; j < resolve.membership.length; ++j) {
                if (!(resolve.membership[j][i] > 0.0) || !(mega.membership[j][i] <= 0.25)) continue;
                lastIndex = j;
                double highest = 0.0;
                int newIndex = 0;
                resolve.membership[lastIndex][i] = 0.0;
                for (int k = 0; k < resolve.membership[0].length; ++k) {
                    if (!(resolve.membership[lastIndex][k] > highest) || k == i) continue;
                    highest = resolve.membership[lastIndex][k];
                    newIndex = k;
                }
                mega.membership[lastIndex][newIndex] = 1.0;
            }
        }
        return mega;
    }

    private void cytoscapeOut(clusterRun mega) {
        try {
            int p;
            clusterRun resolve = new clusterRun();
            resolve.membership = new double[mega.membership.length][mega.membership[0].length];
            for (int i = 0; i < resolve.membership.length; ++i) {
                for (int j = 0; j < resolve.membership[i].length; ++j) {
                    resolve.membership[i][j] = mega.membership[i][j];
                }
            }
            resolve.cleanFuzzy();
            DataOutputStream fuzzyClust = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.s.outputDirectory + "\\AutoSOME_" + this.s.getName() + "_Fuzzy_Clusters_Edges_Cytoscape.txt")));
            DataOutputStream fuzzyClustNodes = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.s.outputDirectory + "\\AutoSOME_" + this.s.getName() + "_Fuzzy_Clusters_Nodes_Cytoscape.txt")));
            int maxSize = 0;
            for (int i = 0; i < mega.membership[0].length; ++i) {
                double sumI = 0.0;
                for (p = 0; p < resolve.membership.length - 1; ++p) {
                    if (!(resolve.membership[p][i] > 0.0)) continue;
                    sumI += 1.0;
                }
                if (sumI > (double)maxSize) {
                    maxSize = (int)sumI;
                }
                if (sumI < 2.0) continue;
                for (int j = i + 1; j < mega.membership[0].length; ++j) {
                    if (i == j) continue;
                    double sumJ = 0.0;
                    for (int p2 = 0; p2 < resolve.membership.length; ++p2) {
                        if (!(resolve.membership[p2][j] > 0.0)) continue;
                        sumJ += 1.0;
                    }
                    if (sumJ < 2.0) continue;
                    double sumFracJ = 0.0;
                    double sumFracI = 0.0;
                    int countJ = 0;
                    int countI = 0;
                    for (int k = 0; k < mega.membership.length; ++k) {
                        if (resolve.membership[k][i] > 0.0 && mega.membership[k][j] > 0.0) {
                            ++countJ;
                            sumFracJ += mega.membership[k][j];
                        }
                        if (!(resolve.membership[k][j] > 0.0) || !(mega.membership[k][i] > 0.0)) continue;
                        ++countI;
                        sumFracI += mega.membership[k][i];
                    }
                    double sumFrac = (sumFracI / sumJ + sumFracJ / sumI) / 2.0;
                    if (Double.isNaN(sumFrac)) {
                        sumFrac = 0.0;
                    }
                    fuzzyClust.writeBytes(i + "\t" + j + "\t" + sumFrac + "\n");
                }
            }
            for (int j = 0; j < mega.membership[0].length; ++j) {
                double sum = 0.0;
                for (p = 0; p < resolve.membership.length; ++p) {
                    if (!(resolve.membership[p][j] > 0.0)) continue;
                    sum += 1.0;
                }
                if (sum == 0.0) continue;
                boolean single = false;
                if (sum == 1.0) {
                    single = true;
                }
                if (single) continue;
                fuzzyClustNodes.writeBytes(j + "\t" + sum / (double)maxSize + "\t" + sum + "\n");
            }
            fuzzyClust.close();
            fuzzyClustNodes.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class sortBySize
    implements Comparable {
        public int size;
        public int id;

        public sortBySize(int size, int id) {
            this.size = size;
            this.id = id;
        }

        public int compareTo(Object o) {
            double dist2 = ((sortBySize)o).size;
            return (double)this.size > dist2 ? -1 : ((double)this.size == dist2 ? 0 : 1);
        }
    }
}

