/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.mapping.sammonmapping;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.Point;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.dataItem;
import java.text.DecimalFormat;
import java.util.Random;
import javax.swing.JProgressBar;

public class sammonMapping {
    private Point[] y;
    private float[][] Y;
    private int dim = 3;
    private float conv = 0.0f;
    float c = 0.0f;
    float MF = 0.3f;
    private JProgressBar jpb;
    private int iters = 100;

    public sammonMapping() {
    }

    public sammonMapping(JProgressBar jpb, int iters, int dim) {
        this.jpb = jpb;
        jpb.setValue(0);
        jpb.setStringPainted(true);
        jpb.setString("");
        this.dim = dim;
        this.iters = iters;
    }

    public float[][] run(dataItem[] input) {
        DecimalFormat Format2 = new DecimalFormat("#.###");
        float[][] L = this.init(input);
        float error = this.getError(L);
        for (int i = 0; i < this.iters; ++i) {
            this.update(L);
            error = this.getError(L);
            this.jpb.setValue((int)(100.0f * ((float)i / (float)this.iters)));
            this.jpb.setString(Format2.format(error));
        }
        float[][] MDS = new float[this.y.length * 4][3];
        int p = 0;
        for (int i = 0; i < MDS.length; i += 4) {
            for (int k = 0; k < 4; ++k) {
                for (int j = 0; j < this.y[p].getPoint().length; ++j) {
                    MDS[i + k][j] = this.y[p].getPoint()[j];
                }
            }
            ++p;
        }
        return MDS;
    }

    private float[][] init(dataItem[] input) {
        float[][] L = this.makeDistMatrix(input);
        this.y = new Point[L.length];
        float max = this.getMax(L);
        Random r = new Random();
        for (int i = 0; i < this.y.length; ++i) {
            float[] coors = new float[this.dim];
            for (int j = 0; j < coors.length; ++j) {
                coors[j] = r.nextInt((int)max);
            }
            this.y[i] = new Point(coors);
        }
        this.c = this.getSum(L);
        return L;
    }

    private float[][] makeDistMatrix(dataItem[] input) {
        float[][] L = new float[input.length][input.length];
        for (int i = 0; i < L.length; ++i) {
            for (int j = i; j < L.length; ++j) {
                if (i == j) continue;
                float f = this.getDist(input[i].getValues(), input[j].getValues());
                L[j][i] = f;
                L[i][j] = f;
            }
        }
        return L;
    }

    private float getDist(float[] a, float[] b) {
        float dist = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            dist = (float)((double)dist + Math.pow(a[i] - b[i], 2.0));
        }
        return (float)Math.sqrt(dist);
    }

    private float getMax(float[][] L) {
        float max = 0.0f;
        for (int i = 0; i < L.length; ++i) {
            for (int j = i; j < L[i].length; ++j) {
                if (!(L[i][j] > max)) continue;
                max = L[i][j];
            }
        }
        return max;
    }

    private float getError(float[][] L) {
        float error = 0.0f;
        this.Y = this.getDist();
        float errorPart = 0.0f;
        for (int i = 0; i < L.length - 1; ++i) {
            for (int j = i + 1; j < L.length; ++j) {
                if (L[i][j] == 0.0f) {
                    L[j][i] = 1.0f;
                    L[i][j] = 1.0f;
                }
                errorPart = (float)((double)errorPart + Math.pow(L[i][j] - this.Y[i][j], 2.0) / (double)L[i][j]);
            }
        }
        error = 1.0f / this.c * errorPart;
        return error;
    }

    private float[][] getDist() {
        float[][] dist = new float[this.y.length][this.y.length];
        for (int i = 0; i < this.y.length - 1; ++i) {
            for (int j = i + 1; j < this.y.length; ++j) {
                float f = this.euclidean(this.y[i], this.y[j]);
                dist[j][i] = f;
                dist[i][j] = f;
            }
        }
        return dist;
    }

    private float euclidean(Point pt1, Point pt2) {
        float dist = 0.0f;
        for (int i = 0; i < pt1.getPoint().length; ++i) {
            dist = (float)((double)dist + Math.pow(pt1.getPoint()[i] - pt2.getPoint()[i], 2.0));
        }
        return (float)Math.sqrt(dist);
    }

    private float getSum(float[][] dist) {
        float sum = 0.0f;
        for (int i = 0; i < dist.length - 1; ++i) {
            for (int j = i + 1; j < dist.length; ++j) {
                sum += dist[i][j];
            }
        }
        return sum;
    }

    private void update(float[][] L) {
        for (int p = 0; p < this.y.length; ++p) {
            for (int q = 0; q < this.y[p].getPoint().length; ++q) {
                float partDer1 = this.getDer1(p, q, L);
                float partDer2 = this.getDer2(p, q, L);
                if (partDer1 == 0.0f || Float.isNaN(partDer1) || Float.isInfinite(partDer1)) {
                    partDer1 = 1.0E-6f;
                }
                if (partDer2 == 0.0f || Float.isNaN(partDer2) || Float.isInfinite(partDer2)) {
                    partDer2 = 1.0E-6f;
                }
                float change = partDer1 / partDer2;
                float[] fArray = this.y[p].getPoint();
                int n = q;
                fArray[n] = fArray[n] - this.MF * change;
                if (!Double.isNaN(this.y[p].getPoint()[q])) continue;
                System.out.println("&&&" + this.y[p].getPoint()[q] + " " + change + " " + partDer1 + " " + partDer2);
            }
        }
    }

    private float getDer1(int p, int q, float[][] L) {
        float der1 = 0.0f;
        float sum = 0.0f;
        for (int j = 0; j < L.length; ++j) {
            if (j == p) continue;
            float x = (L[p][j] - this.Y[p][j]) / (L[p][j] * this.Y[p][j]);
            sum += x * (this.y[p].getPoint()[q] - this.y[j].getPoint()[q]);
        }
        der1 = -2.0f / this.c * sum;
        return der1;
    }

    private float getDer2(int p, int q, float[][] L) {
        float der2 = 0.0f;
        float sum = 0.0f;
        for (int j = 0; j < L.length; ++j) {
            if (j == p) continue;
            float x = (float)(Math.pow(this.y[p].getPoint()[q] - this.y[j].getPoint()[q], 2.0) / (double)this.Y[p][j]) * (1.0f + (L[p][j] - this.Y[p][j]) / this.Y[p][j]);
            float z = L[p][j] - this.Y[p][j] - x;
            x = 1.0f / (L[p][j] * this.Y[p][j]) * z;
            sum += x;
        }
        der2 = -2.0f / this.c * sum;
        return der2;
    }
}

