/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractAttributeClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.ClusterMethod;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.HierarchicalContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.RunHierarchical;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.TreeView;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class HierarchicalCluster
extends AbstractAttributeClusterer {
    public static String SHORTNAME = "hierarchical";
    public static String NAME = "Hierarchical cluster";
    public static String GROUP_ATTRIBUTE = SHORTNAME;
    public static ClusterMethod[] linkageTypes = new ClusterMethod[]{ClusterMethod.AVERAGE_LINKAGE, ClusterMethod.SINGLE_LINKAGE, ClusterMethod.MAXIMUM_LINKAGE, ClusterMethod.CENTROID_LINKAGE};
    ClusterMethod clusterMethod = ClusterMethod.AVERAGE_LINKAGE;
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public HierarchicalContext context = null;

    public HierarchicalCluster(HierarchicalContext context, ClusterManager clusterManager) {
        super(clusterManager);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void run(TaskMonitor monitor) {
        Integer[] rowOrder;
        String[] attributeArray;
        this.monitor = monitor;
        monitor.setTitle("Performing " + this.getName());
        List<String> nodeAttributeList = this.context.attributeList.getNodeAttributeList();
        String edgeAttribute = this.context.attributeList.getEdgeAttribute();
        if (nodeAttributeList == null && edgeAttribute == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must select either one edge column or two or more node columns");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() > 0 && edgeAttribute != null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't have both node and edge columns selected");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() < 2) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least two node columns for cluster weighting");
            return;
        }
        if (this.context.selectedOnly && CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true).size() < 3) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least three nodes to cluster");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() > 1) {
            Collections.sort(nodeAttributeList);
            attributeArray = new String[nodeAttributeList.size()];
            int i = 0;
            for (String attr : nodeAttributeList) {
                attributeArray[i++] = "node." + attr;
            }
        } else {
            attributeArray = new String[]{"edge." + edgeAttribute};
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Initializing");
        System.out.println("Initializing");
        this.resetAttributes(this.network, GROUP_ATTRIBUTE);
        RunHierarchical algorithm = new RunHierarchical(this.network, attributeArray, this.distanceMetric, this.clusterMethod, monitor, this.context);
        if (this.context.clusterAttributes && attributeArray.length > 1) {
            monitor.setStatusMessage("Clustering attributes");
            rowOrder = algorithm.cluster(true);
            this.updateAttributes(this.network, GROUP_ATTRIBUTE, rowOrder, attributeArray, algorithm.getAttributeList(), algorithm.getMatrix());
        }
        monitor.setStatusMessage("Clustering nodes");
        rowOrder = algorithm.cluster(false);
        this.updateAttributes(this.network, GROUP_ATTRIBUTE, rowOrder, attributeArray, algorithm.getAttributeList(), algorithm.getMatrix());
        List<String> params = this.context.getParams(algorithm.getMatrix());
        this.updateParams(this.network, params);
        if (this.context.showUI) {
            this.insertTasksAfterCurrentTask(new Task[]{new TreeView(this.clusterManager)});
        }
        monitor.setStatusMessage("Done");
    }
}

