/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.Hopachable;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.Numeric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.PrimitiveMeanSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.PrimitiveSummarizer;
import java.util.ArrayList;

public class Hopach {
    protected Hopachable partitioner;
    Clusters split;
    int level;
    ArrayList<Clusters> splits;
    int maxLevel = 9;
    double minCostReduction = 0.0;
    boolean forceInitSplit = false;
    PrimitiveSummarizer psummarizer = new PrimitiveMeanSummarizer();

    public Hopach(Hopachable partitioner) {
        this.partitioner = partitioner;
        this.initialize();
    }

    public void setParameters(int maxLevel, double minCostReduction, boolean forceInitSplit, PrimitiveSummarizer psummarizer) {
        this.maxLevel = maxLevel;
        this.minCostReduction = minCostReduction;
        this.forceInitSplit = forceInitSplit;
        this.psummarizer = psummarizer;
        this.initialize();
    }

    public Clusters run() {
        this.runDown();
        return this.split;
    }

    public void printResults() {
        System.out.format("level: %d%n", this.level);
        for (int i = 0; i < this.split.size(); ++i) {
            System.out.format("%d ", this.split.getLabel(i));
        }
        System.out.println();
    }

    public Hopachable getPartitioner() {
        return this.partitioner;
    }

    void initialize() {
        this.splits = new ArrayList(this.maxLevel);
        for (int i = 0; i < this.maxLevel; ++i) {
            this.splits.add(null);
        }
    }

    void runDown() {
        Clusters split = this.initLevel();
        if (this.splitIsFinal(split)) {
            this.split = split;
            this.level = 0;
            return;
        }
        int optLevel = 0;
        Clusters optSplit = split;
        int level = 0;
        do {
            if (!((split = this.collapse(level)).getCost() < optSplit.getCost())) continue;
            optSplit = split;
            optLevel = level;
        } while (++level < this.maxLevel && !this.nextLevel(level));
        this.split = optSplit;
        this.level = optLevel;
    }

    Clusters initLevel() {
        Clusters split = this.partitioner.split(this.forceInitSplit);
        this.sortInitLevel(split);
        this.splits.set(0, split);
        return split;
    }

    Clusters collapse(int level) {
        Clusters split = this.splits.get(level);
        if (split == null) {
            throw new IllegalArgumentException("Specified split level for collapse does not exist.");
        }
        int k = split.getNumberOfClusters();
        if (k <= 2) {
            return split;
        }
        int maxCollapses = k - 2;
        for (int nCollapses = 0; nCollapses < maxCollapses; ++nCollapses) {
            Pair nearest = this.nearestClusters(split);
            Clusters collapsedSplit = this.partitioner.collapse(nearest.x, nearest.y, split);
            double r = split.getCost() - collapsedSplit.getCost();
            if (!(r >= this.minCostReduction)) break;
            split = collapsedSplit;
        }
        return split;
    }

    Pair nearestClusters(Clusters split) {
        double[][] S = this.partitioner.separations(split);
        int k = S.length;
        double minDist = Double.POSITIVE_INFINITY;
        int mi = 0;
        int mj = 1;
        for (int i = 0; i < k; ++i) {
            for (int j = i + 1; j < k; ++j) {
                if (!(S[i][j] < minDist)) continue;
                minDist = S[i][j];
                mi = i;
                mj = j;
            }
        }
        return new Pair(mi, mj);
    }

    boolean nextLevel(int level) {
        Clusters newSplit;
        if (level < 1) {
            throw new IllegalArgumentException("nextlevel can only be invoked for level >= 1");
        }
        Clusters prevSplit = this.splits.get(level - 1);
        int[][] partitions = prevSplit.getPartitions();
        int nClusters = prevSplit.getNumberOfClusters();
        double[][] segregations = this.partitioner.segregations(prevSplit);
        int[] clusterIndex = new int[this.partitioner.size()];
        int j = 0;
        int k = 0;
        double[] costs = new double[nClusters];
        for (int i = 0; i < nClusters; ++i) {
            boolean rightNeighbour = j < nClusters - 1;
            int[] partition = partitions[i];
            if (partition.length == 0) continue;
            int neighbourIndex = rightNeighbour ? i + 1 : i - 1;
            Hopachable sub = this.partitioner.subset(partition);
            Clusters subsplit = sub.split(false);
            int subk = subsplit.getNumberOfClusters();
            if (subk > 1) {
                int[][] subpartitions = subsplit.getPartitions();
                double[] separations = new double[subpartitions.length];
                for (int c = 0; c < subpartitions.length; ++c) {
                    double d = 0.0;
                    for (int jj = 0; jj < subpartitions[c].length; ++jj) {
                        d += segregations[subpartitions[c][jj] + j][neighbourIndex];
                    }
                    separations[c] = d / (double)subpartitions[c].length;
                }
                this.sortSplit(subsplit, separations, rightNeighbour);
            }
            costs[i] = subsplit.getCost();
            for (int jj = 0; jj < sub.size(); ++jj) {
                clusterIndex[partition[jj]] = subsplit.getClusterIndex(jj) + k;
            }
            j += sub.size();
            k += subk;
        }
        this.split = newSplit = new Clusters(clusterIndex, k, this.psummarizer.summarize(costs));
        this.splits.set(level, newSplit);
        if (k == nClusters) {
            return true;
        }
        return this.splitIsFinal(newSplit);
    }

    void sortSplit(Clusters split, double[] segregationsFromNeighbour, boolean rightNeighbour) {
        int[] order = rightNeighbour ? Numeric.order(segregationsFromNeighbour, true) : Numeric.order(segregationsFromNeighbour, false);
        split.order(order);
    }

    void sortInitLevel(Clusters split) {
        if (split.getNumberOfClusters() <= 2) {
            return;
        }
        double[][] S = this.partitioner.separations(split);
        int k = S.length;
        int[] order = new int[k];
        for (int i = 0; i < k; ++i) {
            order[i] = i;
        }
        this.optimizeOrderingCorrelation(S, order);
        split.order(order);
    }

    boolean splitIsFinal(Clusters split) {
        int minSize = 3;
        int[] sizes = split.getSizes();
        boolean isFinal = true;
        for (int clusterSize : sizes) {
            if (clusterSize < 3) continue;
            isFinal = false;
        }
        return isFinal;
    }

    double optimizeOrderingCorrelation(double[][] d, int[] order) {
        int m = d.length;
        double[] v = this.distanceMatrixToVector(d);
        double r = this.orderingCorrelation(v, m);
        for (int step = 1; step <= m - 1; ++step) {
            boolean changed = true;
            while (changed) {
                changed = false;
                for (int j = 0; j < m - step; ++j) {
                    int jj = j + step;
                    int t = order[j];
                    order[j] = order[jj];
                    order[jj] = t;
                    double r2 = this.orderingCorrelation(this.reorderDistanceVector(v, order, m), m);
                    if (r2 <= r) {
                        t = order[j];
                        order[j] = order[jj];
                        order[jj] = t;
                        continue;
                    }
                    changed = true;
                    r = r2;
                }
            }
        }
        return r;
    }

    double orderingCorrelation(double[] x, int n) {
        double[] y = new double[x.length];
        int value = 1;
        int end = n - 1;
        for (int i = 0; i < x.length; ++i) {
            y[i] = value;
            if (++value <= end) continue;
            value = 1;
            --end;
        }
        return Numeric.correlation(x, y);
    }

    double[] distanceMatrixToVector(double[][] d) {
        int m = d.length;
        int n = m * (m - 1) / 2;
        double[] v = new double[n];
        int ii = 1;
        int jj = 0;
        for (int i = 0; i < n; ++i) {
            v[i] = d[ii][jj];
            if (++ii < m) continue;
            ii = ++jj - 1;
        }
        return v;
    }

    int indexLTMatrixToVector(int i, int j, int m) {
        if (j > i) {
            int t = i;
            i = j;
            j = t;
        }
        return j * (m - j) + (j - 1) * j / 2 + (i - j) - 1;
    }

    double[] reorderDistanceVector(double[] v, int[] idx, int m) {
        int n = v.length;
        double[] w = new double[n];
        int ii = 1;
        int jj = 0;
        for (int i = 0; i < n; ++i) {
            w[i] = v[this.indexLTMatrixToVector(idx[ii], idx[jj], m)];
            if (++ii < m) continue;
            ii = ++jj + 1;
        }
        return w;
    }

    private static class Pair {
        public int x;
        public int y;

        public Pair(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

