/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractAttributeClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.HopachPAMContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.RunHopachPAM;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.SplitCost;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.SummaryMethod;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.KnnView;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class HopachPAMClusterer
extends AbstractAttributeClusterer {
    public static final String SHORTNAME = "hopach";
    public static final String NAME = "HOPACH-PAM cluster";
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public HopachPAMContext context = null;

    public HopachPAMClusterer(HopachPAMContext context, ClusterManager clusterManager) {
        super(clusterManager);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public void run(TaskMonitor monitor) {
        Integer[] rowOrder;
        this.monitor = monitor;
        monitor.setTitle("Performing " + this.getName());
        List<String> nodeAttributeList = this.context.attributeList.getNodeAttributeList();
        if (nodeAttributeList == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must select either one edge column or two or more node columns");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() < 2) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least two node columns for cluster weighting");
            return;
        }
        if (this.context.selectedOnly && CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true).size() < 3) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least three nodes to cluster");
            return;
        }
        this.createGroups = this.context.createGroups;
        Collections.sort(nodeAttributeList);
        String[] attributeArray = new String[nodeAttributeList.size()];
        int i = 0;
        for (String attr : nodeAttributeList) {
            attributeArray[i++] = "node." + attr;
        }
        monitor.setStatusMessage("Initializing");
        this.resetAttributes(this.network, SHORTNAME);
        RunHopachPAM algo = new RunHopachPAM(this.network, attributeArray, this.distanceMetric, monitor, this.context);
        algo.setParameters((SplitCost)((Object)this.context.splitCost.getSelectedValue()), (SummaryMethod)((Object)this.context.summaryMethod.getSelectedValue()), this.context.maxLevel, this.context.K, this.context.L, this.context.forceInitSplit, this.context.minCostReduction);
        String resultsString = this.getName() + " results:";
        int nIterations = 0;
        if (this.context.clusterAttributes && attributeArray.length > 1) {
            monitor.setStatusMessage("Clustering attributes");
            rowOrder = algo.cluster(this.clusterManager, 0, nIterations, true, this.getShortName(), this.context.kcontext, false);
            this.updateAttributes(this.network, SHORTNAME, rowOrder, attributeArray, algo.getAttributeList(), algo.getMatrix());
        }
        monitor.setStatusMessage("Clustering nodes");
        rowOrder = algo.cluster(this.clusterManager, 0, nIterations, false, this.getShortName(), this.context.kcontext, this.createGroups);
        this.updateAttributes(this.network, SHORTNAME, rowOrder, attributeArray, algo.getAttributeList(), algo.getMatrix());
        if (this.context.showUI) {
            this.insertTasksAfterCurrentTask(new Task[]{new KnnView(this.clusterManager)});
        }
    }
}

