/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.Hopachable;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.SplitCost;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.Subsegregatable;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam.PAM;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.DistanceCalculator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.MSplitSilhouetteCalculator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.SilhouetteCalculator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.MeanSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.Summarizer;
import org.cytoscape.model.CyNetwork;

public class HopachablePAM
extends PAM
implements Hopachable,
Subsegregatable {
    int maxK = 9;
    int maxL = 9;
    SplitCost splitCost = SplitCost.AVERAGE_SPLIT_SILHOUETTE;
    Summarizer summarizer = new MeanSummarizer();

    public HopachablePAM(CyNetwork network, BaseMatrix data, DistanceMetric metric) {
        super(network, data, metric);
    }

    HopachablePAM(BaseMatrix data, DistanceMetric metric, DistanceMatrix distances, int[] idx) {
        super(data, metric, distances, idx);
    }

    public void setParameters(int maxK, int maxL, SplitCost splitCost, Summarizer summarizer) {
        this.maxK = maxK;
        this.maxL = maxL;
        this.splitCost = splitCost;
        this.summarizer = summarizer;
    }

    public Hopachable subset(int[] index) {
        return new HopachablePAM(this.data, this.metric, this.distances, index);
    }

    public double[][] segregations(Clusters clusters) {
        return DistanceCalculator.segregations(this.distances, clusters);
    }

    public double[][] separations(Clusters clusters) {
        return DistanceCalculator.separations(this.distances, clusters.getClusterLabels());
    }

    public Clusters split(boolean forceSplit) {
        switch (this.splitCost) {
            case AVERAGE_SILHOUETTE: {
                return MSplitSilhouetteCalculator.splitByAverageSilhouette(this, this.maxK, forceSplit, this.summarizer);
            }
        }
        return MSplitSilhouetteCalculator.splitByAverageSplitSilhouette(this, this.maxK, this.maxL, forceSplit, this.summarizer);
    }

    public Clusters collapse(int i, int j, Clusters clusters) {
        Clusters c = new Clusters(clusters);
        c.merge(i, j);
        switch (this.splitCost) {
            case AVERAGE_SILHOUETTE: {
                c.setCost(1.0 - SilhouetteCalculator.silhouettes(this.segregations(c), c).getAverage(this.summarizer));
                break;
            }
            default: {
                c.setCost(MSplitSilhouetteCalculator.averageSplitSilhouette(this, c, this.maxL, this.summarizer));
            }
        }
        return c;
    }

    public int[] order(Clusters clusters) {
        return null;
    }
}

