/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.CuttingEdge;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.AbstractNetworkFilter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.CuttingEdge.CuttingEdgeContext;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuttingEdgeFilter
extends AbstractNetworkFilter {
    public static String SHORTNAME = "cuttingedge";
    public static String NAME = "Cutting Edge Filter";
    public static final String GROUP_ATTRIBUTE = "__CuttingEdgeGroups.SUID";
    @Tunable(description="Network to filter", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public CuttingEdgeContext context = null;

    public CuttingEdgeFilter(CuttingEdgeContext context, ClusterManager clusterManager) {
        super(clusterManager, GROUP_ATTRIBUTE);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
        ((AbstractNetworkFilter)this).network = this.network;
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    @Override
    public String getClusterAttribute() {
        return this.context.getClusterAttribute();
    }

    @Override
    public String getClusterAttributeName() {
        return this.context.getClusterAttributeName();
    }

    @Override
    public boolean restoreEdges() {
        return this.context.vizProperties.restoreEdges;
    }

    @Override
    public boolean showUI() {
        return this.context.vizProperties.showUI;
    }

    @Override
    public NodeCluster doFilter(List<CyNode> nodeList, Map<NodeCluster, List<CyNode>> addedNodeMap) {
        HashSet allEdges = new HashSet();
        for (CyNode node : nodeList) {
            List edgeList = this.network.getAdjacentEdgeList(node, CyEdge.Type.ANY);
            if (edgeList == null && edgeList.size() == 0) continue;
            allEdges.addAll(edgeList);
        }
        int totalEdges = allEdges.size();
        if (totalEdges == 0) {
            return null;
        }
        List<CyEdge> edgeList = ModelUtils.getConnectingEdges(this.network, nodeList);
        if (edgeList == null) {
            return null;
        }
        int innerEdges = edgeList.size();
        double ep = (double)innerEdges / (double)totalEdges;
        System.out.println("innerEdges = " + innerEdges + ", totalEdges = " + totalEdges);
        System.out.println("Ratio = " + ep + ", edgeProportion = " + this.context.edgeProportion);
        if (ep >= this.context.edgeProportion) {
            return new NodeCluster((Collection<CyNode>)nodeList);
        }
        return null;
    }
}

