/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.Density;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.AbstractNetworkFilter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.Density.DensityContext;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DensityFilter
extends AbstractNetworkFilter {
    public static String SHORTNAME = "density";
    public static String NAME = "Density Filter";
    public static final String GROUP_ATTRIBUTE = "__DensityGroups.SUID";
    @Tunable(description="Network to filter", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public DensityContext context = null;

    public DensityFilter(DensityContext context, ClusterManager clusterManager) {
        super(clusterManager, GROUP_ATTRIBUTE);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
        ((AbstractNetworkFilter)this).network = this.network;
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    @Override
    public String getClusterAttribute() {
        return this.context.getClusterAttribute();
    }

    @Override
    public String getClusterAttributeName() {
        return this.context.getClusterAttributeName();
    }

    @Override
    public boolean restoreEdges() {
        return this.context.vizProperties.restoreEdges;
    }

    @Override
    public boolean showUI() {
        return this.context.vizProperties.showUI;
    }

    @Override
    public NodeCluster doFilter(List<CyNode> nodeList, Map<NodeCluster, List<CyNode>> addedNodeMap) {
        int nodeCount;
        List<CyEdge> edgeList = ModelUtils.getConnectingEdges(this.network, nodeList);
        if (edgeList == null) {
            return null;
        }
        int edgeCount = edgeList.size();
        double density = (double)(edgeCount * 2) / (double)((nodeCount = nodeList.size()) * (nodeCount - 1));
        if (density >= this.context.minimumDensity) {
            return new NodeCluster((Collection<CyNode>)nodeList);
        }
        return null;
    }
}

