/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.HairCut;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.AbstractNetworkFilter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.HairCut.HairCutContext;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HairCutFilter
extends AbstractNetworkFilter {
    public static String SHORTNAME = "haircut";
    public static String NAME = "HairCut Filter";
    public static final String GROUP_ATTRIBUTE = "__HairCutGroups.SUID";
    @Tunable(description="Network to filter", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public HairCutContext context = null;

    public HairCutFilter(HairCutContext context, ClusterManager clusterManager) {
        super(clusterManager, GROUP_ATTRIBUTE);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
        ((AbstractNetworkFilter)this).network = this.network;
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    @Override
    public String getClusterAttribute() {
        return this.context.getClusterAttribute();
    }

    @Override
    public String getClusterAttributeName() {
        return this.context.getClusterAttributeName();
    }

    @Override
    public boolean restoreEdges() {
        return this.context.vizProperties.restoreEdges;
    }

    @Override
    public boolean showUI() {
        return this.context.vizProperties.showUI;
    }

    @Override
    public NodeCluster doFilter(List<CyNode> nodeList, Map<NodeCluster, List<CyNode>> addedNodeMap) {
        List<CyEdge> edgeList = ModelUtils.getConnectingEdges(this.network, nodeList);
        HashMap<CyNode, Integer> degreeMap = new HashMap<CyNode, Integer>();
        for (CyEdge edge : edgeList) {
            this.updateMap(degreeMap, edge.getSource());
            this.updateMap(degreeMap, edge.getTarget());
        }
        ArrayList<CyNode> newNodeList = new ArrayList<CyNode>();
        for (CyNode node : degreeMap.keySet()) {
            if ((Integer)degreeMap.get(node) <= this.context.minimumDegree) continue;
            newNodeList.add(node);
        }
        if (newNodeList.size() > 1) {
            return new NodeCluster((Collection<CyNode>)newNodeList);
        }
        return null;
    }

    private void updateMap(Map<CyNode, Integer> degreeMap, CyNode node) {
        if (degreeMap.containsKey(node)) {
            degreeMap.put(node, degreeMap.get(node) + 1);
        } else {
            degreeMap.put(node, 1);
        }
    }
}

