/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;

public class ThresholdHeuristic {
    private List<CyNode> nodes;
    private List<CyEdge> edges;
    private double[] edgeWeights;
    private int totalMin = 100000000;
    private int totalMax = -100000000;
    private double binFactor;

    public ThresholdHeuristic(DistanceMatrix matrix) {
        this.edgeWeights = matrix.getEdgeValues();
        this.nodes = matrix.getNodes();
        this.edges = matrix.getEdges();
        this.setBinFactor();
    }

    private void setBinFactor() {
        double minWeight = 1000000.0;
        double maxWeight = -1000000.0;
        for (int i = 0; i < this.edgeWeights.length; ++i) {
            double weight = this.edgeWeights[i];
            if (weight > maxWeight) {
                maxWeight = weight;
            }
            if (!(weight < minWeight)) continue;
            minWeight = weight;
        }
        double weightRange = maxWeight - minWeight;
        if (weightRange >= 100.0) {
            this.binFactor = 1.0;
        } else {
            if (weightRange == 0.0) {
                weightRange = 1.0E-5;
            }
            this.binFactor = 100.0 / weightRange;
        }
    }

    public double run() {
        int[] numConnectedNodes = this.getNumConnectedNodes();
        int[] seArray = this.getSEarray();
        if (seArray.length == 0) {
            return -1000.0;
        }
        return this.selectThreshold(numConnectedNodes, seArray);
    }

    private int[] getNumConnectedNodes() {
        HashMap<Integer, Integer> maxNodeConnection = new HashMap<Integer, Integer>();
        int[] numConnectedNodes = null;
        for (int i = 0; i < this.edgeWeights.length; ++i) {
            int maxWeight;
            int edgeWeight = (int)(this.edgeWeights[i] * this.binFactor);
            if (this.totalMin > edgeWeight) {
                this.totalMin = edgeWeight;
            }
            if (this.totalMax < edgeWeight) {
                this.totalMax = edgeWeight;
            }
            CyEdge edge = this.edges.get(i);
            Integer sourceIndex = new Integer(this.nodes.indexOf(edge.getSource()));
            Integer targetIndex = new Integer(this.nodes.indexOf(edge.getTarget()));
            if (maxNodeConnection.get(sourceIndex) != null) {
                maxWeight = (Integer)maxNodeConnection.get(sourceIndex);
                if (maxWeight < edgeWeight) {
                    maxNodeConnection.put(sourceIndex, new Integer(edgeWeight));
                }
            } else {
                maxNodeConnection.put(sourceIndex, new Integer(edgeWeight));
            }
            if (maxNodeConnection.get(targetIndex) != null) {
                maxWeight = (Integer)maxNodeConnection.get(targetIndex);
                if (maxWeight >= edgeWeight) continue;
                maxNodeConnection.put(targetIndex, new Integer(edgeWeight));
                continue;
            }
            maxNodeConnection.put(targetIndex, new Integer(edgeWeight));
        }
        numConnectedNodes = this.initDistributionArray();
        Iterator itr = maxNodeConnection.values().iterator();
        while (itr.hasNext()) {
            int index;
            int value = (Integer)itr.next();
            int n = index = this.shiftIndex(value);
            numConnectedNodes[n] = numConnectedNodes[n] + 1;
        }
        return numConnectedNodes;
    }

    private int[] initDistributionArray() {
        int[] distribArray = new int[this.shiftIndex(this.totalMax + 1)];
        for (int i = 0; i < distribArray.length; ++i) {
            distribArray[i] = 0;
        }
        return distribArray;
    }

    private int shiftIndex(int value) {
        return value - this.totalMin;
    }

    private int[] getSEarray() {
        int i;
        int[] distribArray = this.initDistributionArray();
        int[] seArray = this.initDistributionArray();
        for (i = 0; i < this.edgeWeights.length; ++i) {
            int index;
            int edgeWeight = (int)(this.edgeWeights[i] * this.binFactor);
            int n = index = this.shiftIndex(edgeWeight);
            distribArray[n] = distribArray[n] + 1;
        }
        for (i = 0; i < distribArray.length; ++i) {
            for (int j = 0; j < distribArray.length; ++j) {
                int n = i;
                seArray[n] = seArray[n] + distribArray[j];
            }
        }
        return seArray;
    }

    private double selectThreshold(int[] numConnectedNodes, int[] seArray) {
        double oldNSV = (double)numConnectedNodes[0] / (double)seArray[0];
        for (int i = 1; i < seArray.length; ++i) {
            double newNSV = (double)numConnectedNodes[i] / (double)seArray[i];
            double deltaNSV = newNSV - oldNSV;
            if (!(deltaNSV > 0.0)) continue;
            return (double)(i + this.totalMin) / this.binFactor;
        }
        return -1000.0;
    }
}

