/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP.AvailabilityMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP.ResponsibilityMatrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAP {
    private double lambda;
    private double pref;
    private int number_iterations;
    private List<CyNode> nodes;
    private List<CyEdge> edges;
    private boolean canceled = false;
    private TaskMonitor monitor;
    protected int clusterCount = 0;
    private DistanceMatrix distanceMatrix = null;
    private ResponsibilityMatrix r_matrix = null;
    private AvailabilityMatrix a_matrix = null;
    private DoubleMatrix2D s_matrix = null;
    private DoubleMatrix1D pref_vector = null;
    private boolean debug;

    public RunAP(DistanceMatrix dMat, double lambdaParameter, double preferenceParameter, int num_iterations, TaskMonitor monitor, boolean debug) {
        this.distanceMatrix = dMat;
        this.lambda = lambdaParameter;
        this.pref = preferenceParameter;
        this.debug = debug;
        if (this.lambda < 0.0) {
            this.lambda = 0.0;
        } else if (this.lambda > 1.0) {
            this.lambda = 1.0;
        }
        this.number_iterations = num_iterations;
        this.nodes = this.distanceMatrix.getNodes();
        this.edges = this.distanceMatrix.getEdges();
        this.s_matrix = this.distanceMatrix.getDistanceMatrix();
        for (int row = 0; row < this.s_matrix.rows(); ++row) {
            this.s_matrix.set(row, row, this.pref);
        }
        this.r_matrix = new ResponsibilityMatrix(this.s_matrix, this.lambda);
        this.a_matrix = new AvailabilityMatrix(this.s_matrix, this.lambda);
    }

    public void cancel() {
        this.canceled = true;
    }

    public List<NodeCluster> run(CyNetwork network, TaskMonitor monitor) {
        int i;
        monitor.setProgress(0.01);
        if (this.debug) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Input matrix: ");
            monitor.showMessage(TaskMonitor.Level.INFO, this.distanceMatrix.printMatrix(this.s_matrix));
        }
        for (i = 0; i < this.number_iterations; ++i) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Exchanging messages: iteration " + i);
            this.iterate_message_exchange(monitor, i);
            if (this.canceled) {
                monitor.showMessage(TaskMonitor.Level.INFO, "canceled");
                return null;
            }
            monitor.setProgress((double)i / (double)this.number_iterations);
        }
        if (this.debug) {
            for (i = 0; i < this.s_matrix.rows(); ++i) {
                monitor.showMessage(TaskMonitor.Level.INFO, "Node " + this.nodes.get(i) + " has exemplar " + this.get_exemplar(i));
            }
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Assigning nodes to clusters");
        Map<Integer, NodeCluster> clusterMap = this.getClusterMap();
        monitor.showMessage(TaskMonitor.Level.INFO, "Created " + clusterMap.size() + " clusters");
        if (this.clusterCount == 0) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Created 0 clusters!!!!");
            return null;
        }
        int clusterNumber = 1;
        HashMap<NodeCluster, NodeCluster> cMap = new HashMap<NodeCluster, NodeCluster>();
        for (NodeCluster cluster2 : NodeCluster.sortMap(clusterMap)) {
            if (cMap.containsKey(cluster2)) continue;
            if (this.debug) {
                monitor.showMessage(TaskMonitor.Level.INFO, "Cluster " + clusterNumber);
                String s = "";
                for (CyNode node : cluster2) {
                    s = s + node.toString() + "\t";
                }
                monitor.showMessage(TaskMonitor.Level.INFO, s);
            }
            cMap.put(cluster2, cluster2);
            cluster2.setClusterNumber(clusterNumber);
            ++clusterNumber;
        }
        Set clusters = cMap.keySet();
        return new ArrayList<NodeCluster>(clusters);
    }

    public void iterate_message_exchange(TaskMonitor monitor, int iteration) {
        if (this.debug) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Iteration " + iteration);
        }
        this.a_matrix.updateEvidence();
        this.r_matrix.update(this.a_matrix);
        if (this.debug) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Responsibility matrix: ");
            monitor.showMessage(TaskMonitor.Level.INFO, this.distanceMatrix.printMatrix(this.r_matrix.getMatrix()));
        }
        this.r_matrix.updateEvidence();
        this.a_matrix.update(this.r_matrix);
        if (this.debug) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Availability matrix: ");
            monitor.showMessage(TaskMonitor.Level.INFO, this.distanceMatrix.printMatrix(this.a_matrix.getMatrix()));
        }
    }

    private int get_exemplar(int i) {
        double max_value = -1000.0;
        int exemplar = 0;
        for (int k = 0; k < this.s_matrix.rows(); ++k) {
            double sum = this.a_matrix.get(i, k) + this.r_matrix.get(i, k);
            if (!(sum > max_value)) continue;
            max_value = sum;
            exemplar = k;
        }
        if (this.debug) {
            this.monitor.showMessage(TaskMonitor.Level.INFO, "Exemplar for " + i + " is " + exemplar);
        }
        return exemplar;
    }

    private Map<Integer, NodeCluster> getClusterMap() {
        HashMap<Integer, NodeCluster> clusterMap = new HashMap<Integer, NodeCluster>();
        for (int i = 0; i < this.s_matrix.rows(); ++i) {
            NodeCluster iCluster;
            int exemplar = this.get_exemplar(i);
            if (clusterMap.containsKey(exemplar)) {
                if (i == exemplar) continue;
                NodeCluster exemplarCluster = clusterMap.get(exemplar);
                if (clusterMap.containsKey(i)) {
                    NodeCluster iCluster2 = clusterMap.get(i);
                    if (iCluster2 != exemplarCluster) {
                        exemplarCluster.addAll(iCluster2);
                        --this.clusterCount;
                        clusterMap.remove(i);
                    }
                } else {
                    exemplarCluster.add(this.nodes, i);
                }
                this.updateClusters(exemplarCluster, clusterMap);
                continue;
            }
            if (clusterMap.containsKey(i)) {
                if (i == exemplar) continue;
                iCluster = clusterMap.get(i);
                iCluster.add(this.nodes, exemplar);
            } else {
                iCluster = new NodeCluster();
                iCluster.add(this.nodes, i);
                if (exemplar != i) {
                    iCluster.add(this.nodes, exemplar);
                }
                ++this.clusterCount;
            }
            this.updateClusters(iCluster, clusterMap);
        }
        return clusterMap;
    }

    private void updateClusters(NodeCluster cluster2, Map<Integer, NodeCluster> clusterMap) {
        for (CyNode node : cluster2) {
            clusterMap.put(this.nodes.indexOf(node), cluster2);
        }
    }
}

