/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.FuzzyNodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.CyTableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFuzzyNetworkClusterer
extends AbstractNetworkClusterer {
    CyTableManager tableManager = null;
    private CyTableFactory tableFactory = null;

    public AbstractFuzzyNetworkClusterer(ClusterManager clusterManager) {
        super(clusterManager);
        this.tableManager = clusterManager.getTableManager();
        this.tableFactory = clusterManager.getTableFactory();
    }

    protected void createFuzzyTable(List<FuzzyNodeCluster> clusters) {
        CyTable networkTable = this.network.getTable(CyNetwork.class, "LOCAL_ATTRS");
        CyTable FuzzyClusterTable = null;
        if (!CyTableUtil.getColumnNames((CyTable)networkTable).contains(this.clusterAttributeName + "_Table.SUID")) {
            this.network.getDefaultNetworkTable().createColumn(this.clusterAttributeName + "_Table.SUID", Long.class, false);
            FuzzyClusterTable = this.tableFactory.createTable(this.clusterAttributeName + "_Table", "Fuzzy_Node.SUID", Long.class, true, true);
        } else {
            long FuzzyClusterTableSUID = (Long)this.network.getRow((CyIdentifiable)this.network).get(this.clusterAttributeName + "_Table.SUID", Long.class);
            FuzzyClusterTable = this.tableManager.getTable(FuzzyClusterTableSUID);
        }
        for (FuzzyNodeCluster cluster2 : clusters) {
            if (FuzzyClusterTable.getColumn("Cluster_" + cluster2.getClusterNumber()) != null) continue;
            FuzzyClusterTable.createColumn("Cluster_" + cluster2.getClusterNumber(), Double.class, false);
        }
        for (CyNode node : this.network.getNodeList()) {
            CyRow TableRow = FuzzyClusterTable.getRow((Object)node.getSUID());
            for (FuzzyNodeCluster cluster3 : clusters) {
                TableRow.set("Cluster_" + cluster3.getClusterNumber(), cluster3.getMembership(node));
            }
        }
        this.network.getRow((CyIdentifiable)this.network).set(this.clusterAttributeName + "_Table.SUID", (Object)FuzzyClusterTable.getSUID());
        this.tableManager.addTable(FuzzyClusterTable);
    }
}

