/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.Fuzzifier;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.FuzzyNodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractFuzzyNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.Fuzzifier.FuzzifierContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.Fuzzifier.RunFuzzifier;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fuzzifier
extends AbstractFuzzyNetworkClusterer {
    RunFuzzifier runFuzzifier = null;
    public static String SHORTNAME = "fuzzifier";
    public static String NAME = "Cluster Fuzzifier";
    public static final String NONEATTRIBUTE = "--None--";
    public static final String GROUP_ATTRIBUTE = "__FuzzyGroups.SUID";
    protected Matrix dataMatrix;
    private boolean selectedOnly = false;
    private boolean ignoreMissing = true;
    CyTableFactory tableFactory = null;
    CyTableManager tableManager = null;
    private List<NodeCluster> Clusters = null;
    private int cNumber;
    private String[] attributeArray = new String[1];
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public FuzzifierContext context = null;

    public Fuzzifier(FuzzifierContext context, ClusterManager manager) {
        super(manager);
        this.context = context;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
            this.tableFactory = this.clusterManager.getTableFactory();
            this.tableManager = this.clusterManager.getTableManager();
        }
        this.Clusters = this.getClusters();
        this.cNumber = this.Clusters.size();
        context.setNetwork(this.network);
        ((AbstractFuzzyNetworkClusterer)this).network = this.network;
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public void run(TaskMonitor monitor) {
        monitor.setTitle("Performing Fuzzifier clustering");
        this.monitor = monitor;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        ((AbstractFuzzyNetworkClusterer)this).network = this.network;
        Long networkID = this.network.getSUID();
        CyTable nodeAttributes = this.network.getDefaultNodeTable();
        DistanceMatrix distanceMatrix = this.context.edgeAttributeHandler.getMatrix();
        if (distanceMatrix == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't get distance matrix: no attribute value?");
            return;
        }
        this.clusterAttributeName = this.context.getClusterAttribute();
        this.runFuzzifier = new RunFuzzifier(this.Clusters, distanceMatrix, this.cNumber, (Double)this.context.membershipThreshold.getValue(), this.context.maxThreads, monitor);
        this.runFuzzifier.setDebug(this.debug);
        if (this.canceled) {
            return;
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Clustering...");
        List<FuzzyNodeCluster> FuzzyClusters = this.runFuzzifier.run(this.network, monitor);
        if (FuzzyClusters == null) {
            return;
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Removing groups");
        this.removeGroups(this.network, GROUP_ATTRIBUTE);
        monitor.showMessage(TaskMonitor.Level.INFO, "Creating groups");
        this.params = new ArrayList();
        this.context.edgeAttributeHandler.setParams(this.params);
        List<List<CyNode>> nodeClusters = this.createFuzzyGroups(this.network, FuzzyClusters, GROUP_ATTRIBUTE);
        this.results = new AbstractClusterResults(this.network, nodeClusters);
        monitor.showMessage(TaskMonitor.Level.INFO, "Done.  Fuzzifier results:\n" + this.results);
        if (this.context.vizProperties.showUI) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.context.vizProperties.restoreEdges)});
        } else {
            monitor.showMessage(TaskMonitor.Level.INFO, "Done.  Fizzifier results:\n" + this.results);
        }
        System.out.println("Creating fuzzy table");
        this.createFuzzyTable(FuzzyClusters);
        System.out.println("Done");
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.runFuzzifier.cancel();
    }

    public List<NodeCluster> getClusters() {
        ArrayList<NodeCluster> nodeClusters = new ArrayList<NodeCluster>();
        HashMap clusterMap = new HashMap();
        List nodeList = this.network.getNodeList();
        this.clusterAttributeName = (String)this.network.getRow((CyIdentifiable)this.network).get("__clusterAttribute", String.class);
        ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, "__fuzzifierSeed", this.clusterAttributeName, String.class, null);
        for (CyNode node : nodeList) {
            if (!ModelUtils.hasAttribute(this.network, (CyIdentifiable)node, this.clusterAttributeName)) continue;
            Integer cluster2 = (Integer)this.network.getRow((CyIdentifiable)node).get(this.clusterAttributeName, Integer.class);
            if (!clusterMap.containsKey(cluster2)) {
                clusterMap.put(cluster2, new ArrayList());
            }
            ((List)clusterMap.get(cluster2)).add(node);
        }
        Iterator<Object> i$ = clusterMap.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            nodeClusters.add(new NodeCluster((Collection)clusterMap.get(key)));
        }
        return nodeClusters;
    }

    @Override
    public void setUIHelper(TunableUIHelper helper) {
        this.context.setUIHelper(helper);
    }
}

