/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.Fuzzifier;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeAttributeHandler;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.NetworkVizProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithmContext;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.util.BoundedDouble;

public class FuzzifierContext
implements ClusterAlgorithmContext {
    CyNetwork network;
    @ContainsTunables
    public EdgeAttributeHandler edgeAttributeHandler;
    @Tunable(description="Threshold for Fuzzy Membership in a Cluster", groups={"Fuzzifier Advanced Settings"}, params="displayState=collapsed, slider=true", gravity=20.0)
    public BoundedDouble membershipThreshold = new BoundedDouble(Double.valueOf(0.0), Double.valueOf(0.2), Double.valueOf(1.0), false, false);
    @Tunable(description="Maximum number of threads", groups={"Fuzzifier Advanced Settings"}, gravity=21.0)
    public int maxThreads = 0;
    @ContainsTunables
    public AdvancedProperties advancedAttributes;
    @ContainsTunables
    public NetworkVizProperties vizProperties = new NetworkVizProperties();

    public FuzzifierContext() {
        this.advancedAttributes = new AdvancedProperties("__fuzzifierCluster", false);
    }

    public FuzzifierContext(FuzzifierContext origin) {
        this.advancedAttributes = origin.advancedAttributes != null ? new AdvancedProperties(origin.advancedAttributes) : new AdvancedProperties("__fuzzifierCluster", false);
        if (origin.edgeAttributeHandler != null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(origin.edgeAttributeHandler);
        }
        this.membershipThreshold = origin.membershipThreshold;
        this.maxThreads = origin.maxThreads;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.edgeAttributeHandler.setUIHelper(helper);
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.edgeAttributeHandler == null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(network);
        } else {
            this.edgeAttributeHandler.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public String getClusterAttribute() {
        return this.advancedAttributes.clusterAttribute;
    }
}

