/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.Fuzzifier;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.FuzzyNodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunFuzzifier {
    HashMap<String, List<CyNode>> groupMap = null;
    private List<NodeCluster> Clusters = null;
    private int number_clusters;
    private List<CyNode> nodeList = null;
    private boolean canceled = false;
    private TaskMonitor monitor;
    public static final String GROUP_ATTRIBUTE = "__FuzzifierGroups";
    protected int clusterCount = 0;
    private boolean createMetaNodes = false;
    private DistanceMatrix distanceMatrix = null;
    double[][] clusterMemberships = null;
    double membershipThreshold = 0.0;
    private boolean debug = false;
    private int nThreads = Runtime.getRuntime().availableProcessors() - 1;

    public RunFuzzifier(List<NodeCluster> Clusters2, DistanceMatrix distanceMatrix, int cClusters, double membershipThreshold, int maxThreads, TaskMonitor monitor) {
        this.Clusters = Clusters2;
        this.distanceMatrix = distanceMatrix;
        this.number_clusters = cClusters;
        this.monitor = monitor;
        this.membershipThreshold = membershipThreshold;
        this.nThreads = maxThreads > 0 ? maxThreads : Runtime.getRuntime().availableProcessors() - 1;
        monitor.showMessage(TaskMonitor.Level.INFO, "Membership Threshold = " + membershipThreshold);
        monitor.showMessage(TaskMonitor.Level.INFO, "Threads = " + this.nThreads);
        monitor.showMessage(TaskMonitor.Level.INFO, "Number of Clusters = " + this.number_clusters);
    }

    public void cancel() {
        this.canceled = true;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List<FuzzyNodeCluster> run(CyNetwork network, TaskMonitor monitor) {
        Long networkID = network.getSUID();
        this.nodeList = network.getNodeList();
        long startTime = System.currentTimeMillis();
        int nelements = this.distanceMatrix.getNodes().size();
        double[][] ClusterMemberships = new double[nelements][this.number_clusters];
        for (int i = 0; i < nelements; ++i) {
            for (int j = 0; j < this.number_clusters; ++j) {
                ClusterMemberships[i][j] = 0.0;
            }
        }
        Matrix cData = new Matrix(network, this.number_clusters, nelements);
        this.getFuzzyCenters(cData);
        for (CyNode node : this.nodeList) {
            int i;
            int nodeIndex = this.nodeList.indexOf(node);
            double sumDistances = 0.0;
            for (i = 0; i < this.Clusters.size(); ++i) {
                sumDistances += cData.getValue(i, nodeIndex).doubleValue();
            }
            for (i = 0; i < this.Clusters.size(); ++i) {
                ClusterMemberships[nodeIndex][i] = cData.getValue(i, nodeIndex) / sumDistances;
            }
        }
        HashMap<CyNode, double[]> membershipMap = this.createMembershipMap(ClusterMemberships);
        ArrayList<FuzzyNodeCluster> fuzzyClusters = new ArrayList<FuzzyNodeCluster>();
        for (int i = 0; i < this.number_clusters; ++i) {
            ArrayList<CyNode> fuzzyNodeList = new ArrayList<CyNode>();
            HashMap<CyNode, Double> clusterMembershipMap = new HashMap<CyNode, Double>();
            for (CyNode node : this.nodeList) {
                if (!(membershipMap.get(node)[i] > this.membershipThreshold)) continue;
                fuzzyNodeList.add(node);
                clusterMembershipMap.put(node, membershipMap.get(node)[i]);
            }
            fuzzyClusters.add(new FuzzyNodeCluster(fuzzyNodeList, clusterMembershipMap));
        }
        return fuzzyClusters;
    }

    public void getFuzzyCenters(Matrix cData) {
        int nelements = this.distanceMatrix.getNodes().size();
        for (NodeCluster cluster2 : this.Clusters) {
            int c = this.Clusters.indexOf(cluster2);
            double numerator = 0.0;
            Double distance = 0.0;
            int i = 0;
            for (int e = 0; e < nelements; ++e) {
                numerator = 0.0;
                for (CyNode node : cluster2) {
                    i = this.nodeList.indexOf(node);
                    distance = this.distanceMatrix.getEdgeValueFromMatrix(i, e);
                    numerator += distance.doubleValue();
                }
                cData.setValue(c, e, numerator / (double)cluster2.size());
            }
        }
    }

    public HashMap<CyNode, double[]> createMembershipMap(double[][] membershipArray) {
        HashMap<CyNode, double[]> membershipHM = new HashMap<CyNode, double[]>();
        List<CyNode> nodeList = this.distanceMatrix.getNodes();
        for (int i = 0; i < this.distanceMatrix.getNodes().size(); ++i) {
            membershipHM.put(nodeList.get(i), membershipArray[i]);
        }
        return membershipHM;
    }
}

