/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay.FastGreedyAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay.GLayContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay.GSimpleGraphData;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class GLayCluster
extends AbstractNetworkClusterer {
    public static String SHORTNAME = "glay";
    public static String NAME = "Community cluster (GLay)";
    public static final String GROUP_ATTRIBUTE = SHORTNAME;
    FastGreedyAlgorithm fa = null;
    boolean createNewNetwork = false;
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public GLayContext context = null;

    public GLayCluster(GLayContext context, ClusterManager manager) {
        super(manager);
        this.context = context;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void run(TaskMonitor monitor) {
        this.monitor = monitor;
        monitor.setTitle("Performing community clustering (GLay)");
        this.createGroups = this.context.advancedAttributes.createGroups;
        this.clusterAttributeName = this.context.getClusterAttribute();
        GSimpleGraphData simpleGraph = new GSimpleGraphData(this.network, this.context.selectedOnly, this.context.undirectedEdges);
        this.fa = new FastGreedyAlgorithm();
        this.fa.execute(simpleGraph, monitor);
        NumberFormat nf = NumberFormat.getInstance();
        String modularityString = nf.format(this.fa.getModularity());
        ArrayList<NodeCluster> clusterList = new ArrayList<NodeCluster>();
        for (int cluster2 = 0; cluster2 < this.fa.getClusterNumber(); ++cluster2) {
            clusterList.add(new NodeCluster());
        }
        int[] membership = this.fa.getMembership();
        for (int index = 0; index < simpleGraph.graphIndices.length; ++index) {
            int cluster3 = membership[index];
            ((NodeCluster)clusterList.get(cluster3)).add(simpleGraph.graphIndices[index]);
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Found " + clusterList.size() + " clusters");
        this.removeGroups(this.network, GROUP_ATTRIBUTE);
        monitor.showMessage(TaskMonitor.Level.INFO, "Creating groups");
        List<List<CyNode>> nodeClusters = this.createGroups(this.network, clusterList, GROUP_ATTRIBUTE);
        this.results = new AbstractClusterResults(this.network, nodeClusters);
        monitor.showMessage(TaskMonitor.Level.INFO, "Done.  Community Clustering results:\n" + this.results);
        if (this.context.vizProperties.showUI) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.context.vizProperties.restoreEdges)});
        }
    }

    public void cancel() {
        if (this.fa != null) {
            this.fa.cancel();
        }
    }
}

