/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCODE.MCODEAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunMCODE {
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private CyNetwork network = null;
    private MCODEAlgorithm alg = null;
    private boolean completedSuccessfully = false;
    private int analyze;
    private String resultSet;

    public RunMCODE(int analyze, String resultSet, CyNetwork network, TaskMonitor monitor) {
        this.analyze = analyze;
        this.resultSet = resultSet;
        this.network = network;
        this.alg = new MCODEAlgorithm(ModelUtils.getNetworkName(network), monitor);
    }

    public List<NodeCluster> run(TaskMonitor monitor) {
        this.alg.setTaskMonitor(monitor, ModelUtils.getNetworkName(this.network));
        if (this.analyze == 1) {
            monitor.setProgress(0.0);
            monitor.setStatusMessage("Scoring Network (Step 1 of 3)");
            this.alg.scoreGraph(this.network, this.resultSet);
            if (this.interrupted) {
                return null;
            }
            monitor.showMessage(TaskMonitor.Level.INFO, "Network was scored in " + this.alg.getLastScoreTime() + " ms.");
        }
        monitor.setProgress(0.0);
        monitor.setStatusMessage("Finding Clusters (Step 2 of 3)");
        List<NodeCluster> clusters = this.alg.findClusters(this.network, this.resultSet);
        if (this.interrupted) {
            return null;
        }
        monitor.setProgress(0.0);
        monitor.setStatusMessage("Drawing Results (Step 3 of 3)");
        return clusters;
    }

    public void cancel() {
        this.interrupted = true;
        this.alg.setCancelled(true);
    }

    public String getTitle() {
        return new String("MCODE Network Cluster Detection");
    }

    public MCODEAlgorithm getAlg() {
        return this.alg;
    }
}

