/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.SCPS;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleStatistic;
import java.util.Date;
import java.util.Random;

public class KCluster {
    static int seed1 = 0;
    static int seed2 = 0;
    static boolean debug = false;

    public static int kmeans(int nClusters, int nIterations, DoubleMatrix2D matrix, int[] clusterID) {
        int i;
        int nelements = matrix.rows();
        int ifound = 1;
        int[] tclusterid = new int[nelements];
        int[] saved = new int[nelements];
        int[] mapping = new int[nClusters];
        int[] counts = new int[nClusters];
        double error = Double.MAX_VALUE;
        DoubleMatrix2D cData = DoubleFactory2D.sparse.make(nClusters, nClusters);
        if (nIterations <= 1) {
            for (i = 0; i < clusterID.length; ++i) {
                tclusterid[i] = clusterID[i];
            }
            nIterations = 1;
        } else {
            for (i = 0; i < nelements; ++i) {
                clusterID[i] = 0;
            }
        }
        int iteration = 0;
        boolean firstIteration = true;
        do {
            int i2;
            int i3;
            double total = Double.MAX_VALUE;
            int counter = 0;
            int period = 10;
            if (nIterations != 0) {
                KCluster.randomAssign(nClusters, nelements, tclusterid);
            }
            for (i3 = 0; i3 < nClusters; ++i3) {
                counts[i3] = 0;
            }
            for (i3 = 0; i3 < nelements; ++i3) {
                int n = tclusterid[i3];
                counts[n] = counts[n] + 1;
            }
            do {
                double previous = total;
                total = 0.0;
                if (counter % period == 0) {
                    for (i2 = 0; i2 < nelements; ++i2) {
                        saved[i2] = tclusterid[i2];
                    }
                    if (period < 0x3FFFFFFF) {
                        period *= 2;
                    }
                }
                ++counter;
                if (firstIteration) {
                    KCluster.selectCentroidsOrthogonally(nClusters, matrix, cData);
                    firstIteration = false;
                } else {
                    KCluster.getClusterMeans(nClusters, matrix, cData, tclusterid);
                }
                for (i2 = 0; i2 < nelements; ++i2) {
                    int k = tclusterid[i2];
                    if (counts[k] == 1) continue;
                    double distance = KCluster.getDistance(i2, k, matrix, cData);
                    for (int j = 0; j < nClusters; ++j) {
                        double tdistance;
                        if (j == k || !((tdistance = KCluster.getDistance(i2, j, matrix, cData)) < distance)) continue;
                        distance = tdistance;
                        int n = tclusterid[i2];
                        counts[n] = counts[n] - 1;
                        tclusterid[i2] = j;
                        int n2 = j;
                        counts[n2] = counts[n2] + 1;
                    }
                    total += distance;
                }
                if (total >= previous) break;
                for (i2 = 0; i2 < nelements && saved[i2] == tclusterid[i2]; ++i2) {
                }
            } while (i2 != nelements);
            if (nIterations <= 1) {
                error = total;
                break;
            }
            for (i3 = 0; i3 < nClusters; ++i3) {
                mapping[i3] = -1;
            }
            int element = 0;
            for (element = 0; element < nelements; ++element) {
                int j = tclusterid[element];
                int k = clusterID[element];
                if (mapping[k] == -1) {
                    mapping[k] = j;
                    continue;
                }
                if (mapping[k] == j) continue;
                if (!(total < error)) break;
                ifound = 1;
                error = total;
                for (int i4 = 0; i4 < nelements; ++i4) {
                    clusterID[i4] = tclusterid[i4];
                }
                break;
            }
            if (element != nelements) continue;
            ++ifound;
        } while (++iteration < nIterations);
        return ifound;
    }

    private static void selectCentroidsRandom(int nClusters, DoubleMatrix2D data, DoubleMatrix2D cdata) {
        System.out.println("Assigning centroids randomly");
        int centroid_count = 0;
        int[] centroid_assigned = new int[data.rows()];
        for (int i = 0; i < nClusters; ++i) {
            centroid_assigned[i] = 0;
        }
        Random generator = new Random();
        int centroid_id = generator.nextInt(data.rows());
        for (int i = 0; i < nClusters; ++i) {
            System.out.println("Centroid selection iteration " + i + " Centroid id " + centroid_id);
            centroid_assigned[centroid_id] = 1;
            DoubleMatrix1D centroid = data.viewRow(centroid_id);
            int j = 0;
            while ((long)j < centroid.size()) {
                cdata.set(centroid_count, j, centroid.get(j));
                ++j;
            }
            if (++centroid_count == nClusters) break;
            while (centroid_assigned[centroid_id] == 1) {
                centroid_id = generator.nextInt(data.rows());
            }
        }
    }

    private static void selectCentroidsOrthogonally(int nClusters, DoubleMatrix2D data, DoubleMatrix2D cdata) {
        System.out.println("Assigning centroids orthogonolly");
        int centroid_count = 0;
        int[] centroid_assigned = new int[data.rows()];
        for (int i = 0; i < nClusters; ++i) {
            centroid_assigned[i] = 0;
        }
        double[] cosines = new double[data.rows()];
        for (int i = 0; i < data.rows(); ++i) {
            cosines[i] = 0.0;
        }
        Random generator = new Random();
        int centroid_id = generator.nextInt(data.rows());
        for (int i = 0; i < nClusters; ++i) {
            System.out.println("Centroid selection iteration " + i + " Centroid id " + centroid_id);
            centroid_assigned[centroid_id] = 1;
            DoubleMatrix1D centroid = data.viewRow(centroid_id);
            int j = 0;
            while ((long)j < centroid.size()) {
                cdata.set(centroid_count, j, centroid.get(j));
                ++j;
            }
            if (++centroid_count == nClusters) break;
            double min_cosine = 10000.0;
            int new_centroid_id = -1;
            for (int j2 = 0; j2 < data.rows(); ++j2) {
                if (centroid_assigned[j2] == 1) continue;
                int n = j2;
                cosines[n] = cosines[n] + centroid.zDotProduct(data.viewRow(j2));
                if (!(min_cosine > cosines[j2])) continue;
                min_cosine = cosines[j2];
                new_centroid_id = j2;
            }
            centroid_id = new_centroid_id;
        }
    }

    private static void getClusterMeans(int nClusters, DoubleMatrix2D data, DoubleMatrix2D cdata, int[] clusterid) {
        int j;
        int i;
        double[][] cmask = new double[nClusters][cdata.rows()];
        for (i = 0; i < nClusters; ++i) {
            for (j = 0; j < cdata.rows(); ++j) {
                cdata.set(j, i, 0.0);
                cmask[i][j] = 0.0;
            }
        }
        for (int k = 0; k < data.rows(); ++k) {
            int i2 = clusterid[k];
            for (int j2 = 0; j2 < data.columns(); ++j2) {
                if (data.get(k, j2) == 0.0) continue;
                double cValue = 0.0;
                double dataValue = data.get(k, j2);
                if (cdata.get(i2, j2) != 0.0) {
                    cValue = cdata.get(i2, j2);
                }
                cdata.set(i2, j2, cValue + dataValue);
                cmask[i2][j2] = cmask[i2][j2] + 1.0;
            }
        }
        for (i = 0; i < nClusters; ++i) {
            for (j = 0; j < cdata.rows(); ++j) {
                if (!(cmask[i][j] > 0.0)) continue;
                double cData = cdata.get(i, j) / cmask[i][j];
                cdata.set(i, j, cData);
            }
        }
    }

    private static double getDistance(int row1_id, int row2_id, DoubleMatrix2D matrix, DoubleMatrix2D cdata) {
        DoubleMatrix1D row1 = matrix.viewRow(row1_id);
        DoubleMatrix1D row2 = cdata.viewRow(row2_id);
        return DoubleStatistic.EUCLID.apply(row1, row2);
    }

    private static void randomAssign(int nClusters, int nElements, int[] clusterID) {
        int n = nElements - nClusters;
        int k = 0;
        int i = 0;
        for (i = 0; i < nClusters - 1; ++i) {
            double p = 1.0 / (double)(nClusters - 1);
            int j = KCluster.binomial(n, p);
            n -= j;
            j += k + 1;
            while (k < j) {
                clusterID[k] = i;
                ++k;
            }
        }
        while (k < nElements) {
            clusterID[k] = i;
            ++k;
        }
        for (i = 0; i < nElements; ++i) {
            int j = (int)((double)i + (double)(nElements - i) * KCluster.uniform());
            k = clusterID[j];
            clusterID[j] = clusterID[i];
            clusterID[i] = k;
        }
    }

    private static void debugAssign(int nClusters, int nElements, int[] clusterID) {
        for (int element = 0; element < nElements; ++element) {
            clusterID[element] = element % nClusters;
        }
    }

    private static int binomial(int n, double p) {
        int y;
        double q = 1.0 - p;
        if ((double)n * p < 30.0) {
            double s = p / q;
            double a = (double)(n + 1) * s;
            double r = Math.exp((double)n * Math.log(q));
            int x = 0;
            double u = KCluster.uniform();
            while (true) {
                if (u < r) {
                    return x;
                }
                u -= r;
                r *= a / (double)(++x) - s;
            }
        }
        double fm = (double)n * p + p;
        int m = (int)fm;
        double p1 = Math.floor(2.195 * Math.sqrt((double)n * p * q) - 4.6 * q) + 0.5;
        double xm = (double)m + 0.5;
        double xl = xm - p1;
        double xr = xm + p1;
        double c = 0.134 + 20.5 / (15.3 + (double)m);
        double a = (fm - xl) / (fm - xl * p);
        double b = (xr - fm) / (xr * q);
        double lambdal = a * (1.0 + 0.5 * a);
        double lambdar = b * (1.0 + 0.5 * b);
        double p2 = p1 * (1.0 + 2.0 * c);
        double p3 = p2 + c / lambdal;
        double p4 = p3 + c / lambdar;
        while (true) {
            double u = KCluster.uniform();
            double v = KCluster.uniform();
            if ((u *= p4) <= p1) {
                return (int)(xm - p1 * v + u);
            }
            if (u > p2) {
                if (u > p3) {
                    y = (int)(xr - Math.log(v) / lambdar);
                    if (y > n) continue;
                    v = v * (u - p3) * lambdar;
                } else {
                    y = (int)(xl + Math.log(v) / lambdal);
                    if (y < 0) continue;
                    v = v * (u - p2) * lambdal;
                }
            } else {
                double x = xl + (u - p1) / c;
                if ((v = v * c + 1.0 - Math.abs((double)m - x + 0.5) / p1) > 1.0) continue;
                y = (int)x;
            }
            int k = Math.abs(y - m);
            if (k > 20 && (double)k < 0.5 * (double)n * p * q - 1.0) {
                double rho = (double)k / ((double)n * p * q) * (((double)k * ((double)k / 3.0 + 0.625) + 0.1666666666666) / ((double)n * p * q) + 0.5);
                double t = (double)(-k * k) / ((double)(2 * n) * p * q);
                double A = Math.log(v);
                if (A < t - rho) {
                    return y;
                }
                if (A > t + rho) continue;
                double x1 = y + 1;
                double f1 = m + 1;
                double z = n + 1 - m;
                double w = n - y + 1;
                double x2 = x1 * x1;
                double f2 = f1 * f1;
                double z2 = z * z;
                double w2 = w * w;
                if (A > xm * Math.log(f1 / x1) + ((double)(n - m) + 0.5) * Math.log(z / w) + (double)(y - m) * Math.log(w * p / (x1 * q)) + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / f2) / f2) / f2) / f2) / f1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / z2) / z2) / z2) / z2) / z / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / x2) / x2) / x2) / x2) / x1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / w2) / w2) / w2) / w2) / w / 166320.0) continue;
                return y;
            }
            double s = p / q;
            double aa = s * (double)(n + 1);
            double f = 1.0;
            int i = m;
            while (i < y) {
                f *= aa / (double)(++i) - s;
            }
            i = y;
            while (i < m) {
                f /= aa / (double)(++i) - s;
            }
            if (!(v > f)) break;
        }
        return y;
    }

    private static double uniform() {
        int z;
        int m1 = 2147483563;
        int m2 = 0x7FFFFF07;
        double scale = 1.0 / (double)m1;
        if (seed1 == 0 || seed2 == 0) {
            Date date = new Date();
            int initseed = (int)date.getTime();
            Random r = new Random(initseed);
            seed1 = r.nextInt();
            seed2 = r.nextInt();
        }
        do {
            int k;
            if ((seed1 = 40014 * (seed1 - (k = seed1 / 53668) * 53668) - k * 12211) < 0) {
                seed1 += m1;
            }
            if ((seed2 = 40692 * (seed2 - (k = seed2 / 52774) * 52774) - k * 3791) < 0) {
                seed2 += m2;
            }
            if ((z = seed1 - seed2) >= 1) continue;
            z += m1 - 1;
        } while (z == m1);
        return (double)z * scale;
    }
}

