/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.SCPS;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.SCPS.RunSCPS;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.SCPS.SCPSContext;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCPSCluster
extends AbstractNetworkClusterer {
    public static String SHORTNAME = "scps";
    public static String NAME = "SCPS Cluster";
    public static final String GROUP_ATTRIBUTE = SHORTNAME;
    RunSCPS runSCPS = null;
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public SCPSContext context = null;

    public SCPSCluster(SCPSContext context, ClusterManager manager) {
        super(manager);
        this.context = context;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void run(TaskMonitor monitor) {
        DistanceMatrix matrix;
        monitor.setTitle("Performing SCPS cluster");
        this.monitor = monitor;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        if ((matrix = this.context.edgeAttributeHandler.getMatrix()) == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't get distance matrix: no attribute value?");
            return;
        }
        this.clusterAttributeName = this.context.getClusterAttribute();
        this.createGroups = this.context.advancedAttributes.createGroups;
        if (this.canceled) {
            return;
        }
        this.runSCPS = new RunSCPS(matrix, this.context.epsilon, this.context.clusters, this.context.iterations, monitor);
        monitor.showMessage(TaskMonitor.Level.INFO, "Clustering...");
        List<NodeCluster> clusterList = this.runSCPS.run(this.network, monitor);
        if (clusterList == null) {
            return;
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Removing groups");
        this.removeGroups(this.network, GROUP_ATTRIBUTE);
        monitor.showMessage(TaskMonitor.Level.INFO, "Creating groups");
        this.params = new ArrayList();
        this.context.edgeAttributeHandler.setParams(this.params);
        List<List<CyNode>> nodeClusters = this.createGroups(this.network, clusterList, GROUP_ATTRIBUTE);
        this.results = new AbstractClusterResults(this.network, nodeClusters);
        monitor.showMessage(TaskMonitor.Level.INFO, "Done.  SCPS results:\n" + this.results);
        if (this.context.vizProperties.showUI) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.context.vizProperties.restoreEdges)});
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.runSCPS.cancel();
    }

    public void setParams(List<String> params) {
        params.add("epsilon=" + this.context.epsilon);
        params.add("iterations=" + this.context.iterations);
        params.add("clusters=" + this.context.clusters);
    }

    @Override
    public void setUIHelper(TunableUIHelper helper) {
        this.context.setUIHelper(helper);
    }
}

