/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeAttributeHandler;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.NetworkVizProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithmContext;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

public class TransClusterContext
implements ClusterAlgorithmContext {
    CyNetwork network;
    @ContainsTunables
    public EdgeAttributeHandler edgeAttributeHandler;
    @Tunable(description="Max. Subcluster Size", groups={"Advanced Tuning Parameters", "Find Exact Solution"}, gravity=11.0)
    public int maxSubclusterSize = 20;
    @Tunable(description="Max. Time (secs)", groups={"Advanced Tuning Parameters", "Find Exact Solution"}, gravity=12.0)
    public int maxTime = 1;
    @Tunable(description="Merge very similar nodes to one?", groups={"Advanced Tuning Parameters", "Merge Nodes"}, gravity=13.0)
    public boolean mergeSimilar = false;
    @Tunable(description="Threshold for merge", groups={"Advanced Tuning Parameters", "Merge Nodes"}, gravity=14.0)
    public int mergeThreshold = 100;
    @Tunable(description="Number of Processors:", groups={"Advanced Tuning Parameters", "Parallelization"}, gravity=15.0)
    public int processors = -1;
    @ContainsTunables
    public AdvancedProperties advancedAttributes;
    @ContainsTunables
    public NetworkVizProperties vizProperties = new NetworkVizProperties();

    public TransClusterContext() {
        this.advancedAttributes = new AdvancedProperties("__transclustCluster", false);
    }

    public TransClusterContext(TransClusterContext origin) {
        this.advancedAttributes = origin.advancedAttributes != null ? new AdvancedProperties(origin.advancedAttributes) : new AdvancedProperties("__transclustCluster", false);
        if (origin.edgeAttributeHandler != null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(origin.edgeAttributeHandler);
        }
        this.maxSubclusterSize = origin.maxSubclusterSize;
        this.maxTime = origin.maxTime;
        this.mergeSimilar = origin.mergeSimilar;
        this.mergeThreshold = origin.mergeThreshold;
        this.processors = origin.processors;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.edgeAttributeHandler == null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(network);
        } else {
            this.edgeAttributeHandler.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public String getClusterAttribute() {
        return this.advancedAttributes.clusterAttribute;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.edgeAttributeHandler.setUIHelper(helper);
    }
}

