/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.BlastFile;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.CostMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.Edges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.gui.Console;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.Config;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InOut {
    public static String TAB = "\t";
    public static String NL = "\n";
    public static String delimiter = "#";
    public static float min = Float.MAX_VALUE;

    public static int[] readFastaFile(String fastaFile, HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(fastaFile));
        String protein = "";
        Vector<Integer> v = new Vector<Integer>();
        int i = -1;
        String sequence = "";
        while ((line = br.readLine()) != null) {
            if (line.startsWith(">")) {
                if (i != -1) {
                    v.add(sequence.length());
                }
                String[] tokens = line.split(" ");
                protein = tokens[0].substring(1);
                proteins2integers.put(++i, protein);
                integers2proteins.put(protein, i);
                sequence = "";
                continue;
            }
            sequence = sequence + line;
        }
        v.add(sequence.length());
        int[] proteinlengths = new int[v.size()];
        for (int j = 0; j < v.size(); ++j) {
            proteinlengths[j] = (Integer)v.get(j);
        }
        br.close();
        System.gc();
        return proteinlengths;
    }

    public static BlastFile readBlastFileWithArray(String blastFile, HashMap<String, Integer> integers2proteins, int[] proteinlengths) throws IOException {
        File f = new File(blastFile);
        BufferedReader br = new BufferedReader(new FileReader(blastFile));
        if (Config.gui) {
            Console.restartBar(0, 100);
            Console.setBarText("start counting lines of BLAST file");
        }
        int lineCount = InOut.countLines(f);
        if (Config.gui) {
            Console.println("" + lineCount);
            Console.println();
        }
        BlastFile bf = new BlastFile(lineCount);
        br.close();
        br = new BufferedReader(new FileReader(blastFile));
        if (Config.gui) {
            Console.println("\t start reading BLAST file ...");
            Console.restartBar(0, 100);
            Console.setBarText("reading blast file");
        }
        int i = 0;
        double percent = 0.0;
        double percentOld = 0.0;
        double normalizeFactorFromBlastCutoff = Math.log10(Config.blastCutoff);
        try {
            while (true) {
                String line = br.readLine();
                if (i % 10000 == 0 && i > 0 && (percent = Math.rint((double)i / (double)lineCount * 10000.0) / 100.0) > percentOld + 1.0) {
                    percentOld = percent;
                    if (Config.gui) {
                        Console.setBarValue((int)Math.rint(percent));
                        Console.setBarTextPlusRestTime("reading BLAST file  " + percent + " %");
                    }
                }
                String[] columns = line.split(TAB);
                String source = columns[0];
                int sourceInt = integers2proteins.get(source);
                String target = columns[1];
                int targetInt = integers2proteins.get(target);
                int startQuery = Integer.parseInt(columns[6]);
                int endQuery = Integer.parseInt(columns[7]);
                int startSubject = Integer.parseInt(columns[8]);
                int endSubject = Integer.parseInt(columns[9]);
                double evalue = Double.parseDouble(columns[10]);
                double score = Double.parseDouble(columns[11]) / Double.parseDouble(columns[3]);
                if (evalue < Double.MIN_VALUE) {
                    evalue = Double.MIN_VALUE;
                }
                if (evalue > Config.blastCutoff) {
                    score = 0.0;
                    evalue = 0.0;
                } else {
                    evalue = -Math.log10(evalue);
                }
                if (Config.blastCutoff > 1.0) {
                    evalue += normalizeFactorFromBlastCutoff;
                }
                bf.setAll(i, startQuery, endQuery, startSubject, endSubject, sourceInt, targetInt, evalue, score);
                ++i;
            }
        }
        catch (Exception e) {
            br.close();
            if (Config.gui) {
                Console.println();
            }
            return bf;
        }
    }

    public static Edges readSimilarityFile(String file, HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins) throws IOException {
        int i;
        BufferedReader br = new BufferedReader(new FileReader(file));
        int lineCount = 0;
        int proteinNumber = 0;
        if (!Config.createSimilarityFile) {
            if (Config.gui) {
                Console.println("\t start counting lines of similarity file ...");
                Console.restartBar(0, 100);
                Console.setBarText("start counting lines of similarity file");
            }
            if (Config.fastaFile != null && TaskConfig.mode != 2 && TaskConfig.mode != 3) {
                File f = new File(Config.similarityFile);
                lineCount = InOut.countLines(f);
                InOut.readFastaFile(Config.fastaFile, proteins2integers, integers2proteins);
            } else {
                try {
                    while (true) {
                        String line = br.readLine();
                        String[] tokens = line.split(TAB);
                        if (++lineCount % 10000 == 0 && Config.gui) {
                            Console.setBarText("start counting lines of similarity file  " + lineCount);
                        }
                        if (!integers2proteins.containsKey(tokens[0])) {
                            integers2proteins.put(tokens[0], proteinNumber);
                            proteins2integers.put(proteinNumber, tokens[0]);
                            ++proteinNumber;
                        }
                        if (integers2proteins.containsKey(tokens[1])) continue;
                        integers2proteins.put(tokens[1], proteinNumber);
                        proteins2integers.put(proteinNumber, tokens[1]);
                        ++proteinNumber;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (Config.gui) {
                Console.println();
            }
        } else {
            lineCount = Config.linesInSimilarityFile;
        }
        Edges es = new Edges(lineCount, proteins2integers.size());
        for (i = 0; i < proteinNumber; ++i) {
            es.setStartPosition(i, -1);
        }
        br.close();
        br = new BufferedReader(new FileReader(file));
        i = 0;
        int currentProtein = -1;
        double percent = 0.0;
        if (Config.gui) {
            Console.println("\t start reading similarity file ...");
            Console.restartBar(0, 100);
            Console.setBarText("start reading similarity file");
        }
        double percentOld = 0.0;
        String line = "";
        String[] tokens = new String[3];
        int s = -1;
        int t = 0;
        while ((line = br.readLine()) != null) {
            if (line.equals("")) continue;
            if (i % 100000 == 0 && i > 0 && (percent = Math.rint((double)i / (double)lineCount * 10000.0) / 100.0) > percentOld + 1.0) {
                percentOld = percent;
                if (Config.gui) {
                    Console.setBarValue((int)Math.rint(percent));
                    Console.setBarTextPlusRestTime("reading similarity file  " + percent + " %");
                } else {
                    System.out.print(percent + " %\t");
                }
            }
            int indexOfFirstTAB = line.indexOf(9);
            int indexOfSecondTAB = line.indexOf(9, indexOfFirstTAB + 1);
            tokens[0] = line.substring(0, indexOfFirstTAB);
            tokens[1] = line.substring(indexOfFirstTAB + 1, indexOfSecondTAB);
            tokens[2] = line.substring(indexOfSecondTAB + 1, line.length());
            s = integers2proteins.get(tokens[0]);
            t = integers2proteins.get(tokens[1]);
            es.sources[i] = s;
            es.targets[i] = t;
            es.values[i] = Float.parseFloat(tokens[2]);
            if (es.values[i] < min) {
                min = es.values[i];
            }
            if (s != currentProtein) {
                currentProtein = s;
                es.setStartPosition(s, i);
            }
            ++i;
        }
        if (Config.gui) {
            Console.println();
            Console.println("\t start sorting");
            Console.restartBar(0, 100);
            Console.setBarText("start sorting");
        }
        int[] positions2 = (int[])es.getStartPosition().clone();
        Arrays.sort(positions2);
        if (Config.gui) {
            Console.println();
            Console.println("\t start finding endpositions");
            Console.restartBar(0, 100);
            Console.setBarText("finding endpositions");
        }
        percentOld = 0.0;
        for (int j = 0; j < positions2.length; ++j) {
            int dum;
            int k;
            if (j % 100000 == 0 && j > 0 && (percent = Math.rint((double)j / (double)positions2.length * 10000.0) / 100.0) > percentOld + 1.0) {
                percentOld = percent;
                if (Config.gui) {
                    Console.setBarValue((int)Math.rint(percent));
                    Console.setBarTextPlusRestTime("finding endpositions  " + percent + " %");
                } else {
                    System.out.print(percent + " %\t");
                }
            }
            if ((k = Arrays.binarySearch(positions2, dum = es.getStartPosition(j))) + 1 < positions2.length) {
                if (dum == -1) {
                    es.setEndPosition(j, -1);
                    continue;
                }
                es.setEndPosition(j, positions2[k + 1]);
                continue;
            }
            es.setEndPosition(j, es.size());
        }
        if (Config.gui) {
            Console.println();
            Console.println("\t start normalizing");
            Console.restartBarTimer();
            Console.setBarValue(0);
            Console.setBarText("normalizing");
        }
        boolean[] already = new boolean[es.size()];
        int countPairs = 0;
        int nonPairs = 0;
        percentOld = 0.0;
        for (int j = 0; j < es.size(); ++j) {
            if (j % 100000 == 0 && j > 0 && (percent = Math.rint((double)j / (double)es.size() * 10000.0) / 100.0) > percentOld + 1.0) {
                percentOld = percent;
                if (Config.gui) {
                    Console.setBarValue((int)Math.rint(percent));
                    Console.setBarTextPlusRestTime("normalizing  " + percent + " %");
                }
            }
            if (already[j]) continue;
            int source = es.sources[j];
            int target = es.targets[j];
            float value = es.values[j];
            int startPosition = es.startPositions[target];
            int endPosition = es.endPositions[target];
            boolean hasPartner = false;
            for (int k = startPosition; k < endPosition; ++k) {
                int target2 = es.targets[k];
                if (target2 != source) continue;
                already[k] = true;
                hasPartner = true;
                float value2 = es.getValue(k);
                float minimalValue = Math.min(value, value2);
                es.setValue(j, minimalValue);
                es.setValue(k, minimalValue);
                ++countPairs;
                break;
            }
            if (hasPartner) continue;
            es.setValue(j, min);
            ++nonPairs;
        }
        if (Config.gui) {
            Console.println();
        }
        return es;
    }

    public static void writeCostMatrices(Edges es, Vector<Vector<Integer>> clusters, HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins) throws IOException {
        Vector<Vector<Integer>> complete = new Vector<Vector<Integer>>();
        int countCostMatrices = 1;
        double percentOld = 0.0;
        double numberOfProteins = proteins2integers.size();
        double alreadySolvedNumberOfProteins = 0.0;
        for (int i = 0; i < clusters.size(); ++i) {
            Vector<Integer> cluster2 = clusters.get(i);
            int numberEdges = cluster2.size() * (cluster2.size() - 1) / 2;
            int numberProteins = cluster2.size();
            alreadySolvedNumberOfProteins += (double)numberProteins;
            int countRealEdges = 0;
            if (Config.reducedMatrix) {
                CostMatrix cm = new CostMatrix(numberProteins);
                HashMap<String, Integer> CmIntegers2proteins = new HashMap<String, Integer>(numberProteins);
                HashMap<Integer, String> CmProteins2integers = new HashMap<Integer, String>(numberProteins);
                for (int j = 0; j < cluster2.size(); ++j) {
                    int source = cluster2.get(j);
                    String protein = proteins2integers.get(source);
                    CmProteins2integers.put(j, protein);
                    CmIntegers2proteins.put(protein, j);
                    for (int k = j + 1; k < cluster2.size(); ++k) {
                        int target = cluster2.get(k);
                        float value = InOut.getEdgeValue(source, target, es);
                        cm.setEdgevalues(j, k, value);
                        cm.setEdgevalues(k, j, value);
                        if (!(value > Config.threshold)) continue;
                        ++countRealEdges;
                    }
                }
                cm.setIntegers2proteins(CmIntegers2proteins);
                cm.setProteins2integers(CmProteins2integers);
                if (countRealEdges == numberEdges) {
                    complete.add(cluster2);
                } else {
                    String costMatrixFile = "";
                    costMatrixFile = TaskConfig.mode == 3 ? "costMatrix_size_" + cluster2.size() + "_nr_" + countCostMatrices + "_" + new Random().nextDouble() + ".rcm" : "costMatrix_size_" + cluster2.size() + "_nr_" + countCostMatrices + ".rcm";
                    CostMatrix mergedCM = cm.mergeNodes();
                    mergedCM.writeCostMatrix(Config.costMatrixDirectory + "/" + costMatrixFile);
                    ++countCostMatrices;
                }
                double percent = Math.rint(alreadySolvedNumberOfProteins / numberOfProteins * 10000.0) / 100.0;
                if (percent > percentOld + 0.5 || percent == 100.0) {
                    percentOld = percent;
                    if (Config.gui) {
                        Console.setBarValue((int)Math.rint(percent));
                        Console.setBarTextPlusRestTime("Writing costmatrices  " + percent + "%");
                    }
                }
                for (int j = 0; j < cluster2.size(); ++j) {
                    String id = proteins2integers.get(cluster2.get(j));
                    integers2proteins.remove(id);
                }
                continue;
            }
            int countPosition = 0;
            Edges edges = new Edges(numberEdges, numberProteins);
            for (int j = 0; j < cluster2.size(); ++j) {
                int source = cluster2.get(j);
                edges.setStartPosition(j, countPosition);
                for (int k = j + 1; k < cluster2.size(); ++k) {
                    int target = cluster2.get(k);
                    float value = InOut.getEdgeValue(source, target, es);
                    if (value > Config.threshold) {
                        ++countRealEdges;
                    }
                    edges.setSource(countPosition, j);
                    edges.setTarget(countPosition, k);
                    edges.setValue(countPosition, value);
                    ++countPosition;
                }
                edges.setEndPosition(j, countPosition - 1);
            }
            if (countRealEdges == numberEdges) {
                complete.add(cluster2);
            } else {
                InOut.writeCostMatrix(edges, cluster2, countCostMatrices, proteins2integers, integers2proteins);
                ++countCostMatrices;
            }
            double percent = Math.rint(alreadySolvedNumberOfProteins / numberOfProteins * 10000.0) / 100.0;
            if (percent > percentOld + 0.5 || percent == 100.0) {
                percentOld = percent;
                if (Config.gui) {
                    Console.setBarValue((int)Math.rint(percent));
                    Console.setBarTextPlusRestTime("Writing costmatrices  " + percent + "%");
                }
            }
            for (int j = 0; j < cluster2.size(); ++j) {
                String id = proteins2integers.get(cluster2.get(j));
                integers2proteins.remove(id);
            }
        }
        for (String element : integers2proteins.keySet()) {
            int id = integers2proteins.get(element);
            Vector<Integer> cluster3 = new Vector<Integer>();
            cluster3.add(id);
            complete.add(cluster3);
        }
        InOut.writeCompleteTable(complete, proteins2integers);
    }

    public static float getEdgeValue(int source, int target, Edges es) {
        int startPosition = es.getStartPosition(source);
        int endPosition = es.getEndPosition(source);
        for (int i = startPosition; i < endPosition; ++i) {
            int target2 = es.getTarget(i);
            if (target != target2) continue;
            return es.getValue(i);
        }
        return min;
    }

    private static void writeCostMatrix(Edges es, Vector<Integer> cluster2, int countCostMatrices, HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins) throws IOException {
        String costMatrixFile = TaskConfig.mode == 3 ? (Config.reducedMatrix ? "costMatrix_size_" + cluster2.size() + "_nr_" + countCostMatrices + "_" + new Random().nextDouble() + ".rcm" : "costMatrix_size_" + cluster2.size() + "_nr_" + countCostMatrices + "_" + new Random().nextDouble() + ".cm") : (Config.reducedMatrix ? "costMatrix_size_" + cluster2.size() + "_nr_" + countCostMatrices + ".rcm" : "costMatrix_size_" + cluster2.size() + "_nr_" + countCostMatrices + ".cm");
        BufferedWriter bw = new BufferedWriter(new FileWriter(Config.costMatrixDirectory + "/" + costMatrixFile));
        bw.write(Integer.toString(cluster2.size()));
        bw.newLine();
        for (int i = 0; i < cluster2.size(); ++i) {
            String id = proteins2integers.get(cluster2.get(i));
            bw.write(id);
            bw.newLine();
        }
        int k = 0;
        for (int i = 0; i < cluster2.size(); ++i) {
            for (int j = i + 1; j < cluster2.size(); ++j) {
                float value = es.getValue(k);
                value = value < Config.threshold ? -Math.abs(value - Config.threshold) : Math.abs(value - Config.threshold);
                bw.write(Float.toString(value));
                if (j < cluster2.size() - 1) {
                    bw.write("\t");
                }
                ++k;
            }
            if (i >= cluster2.size() - 1) continue;
            bw.newLine();
        }
        bw.close();
    }

    private static void writeCompleteTable(Vector<Vector<Integer>> complete, HashMap<Integer, String> proteins2integers) throws IOException {
        String fileName = "transitive_connected_components_format_1.tcc";
        BufferedWriter bw = new BufferedWriter(new FileWriter(Config.costMatrixDirectory + "/" + fileName));
        bw.write("Number of connected components: " + Integer.toString(complete.size()));
        bw.newLine();
        for (int i = 0; i < complete.size(); ++i) {
            Vector<Integer> cluster2 = complete.get(i);
            bw.write(Integer.toString(cluster2.size()) + TAB);
            for (int j = 0; j < cluster2.size(); ++j) {
                String id = proteins2integers.get(cluster2.get(j));
                if (j < cluster2.size() - 1) {
                    bw.write(id + TAB);
                    continue;
                }
                bw.write(id);
            }
            bw.newLine();
        }
        bw.close();
    }

    public static int countLines(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        if (Config.gui) {
            Console.setBarValue(0);
            Console.setBarText("counting lines");
        }
        int lineCount = 0;
        char[] buffer = new char[4096];
        int charsRead = br.read(buffer);
        while (charsRead >= 0) {
            for (int charIndex = 0; charIndex < charsRead; ++charIndex) {
                if (buffer[charIndex] != '\n' || ++lineCount % 100000 != 0 || !Config.gui) continue;
                Console.setBarText("counting lines  " + lineCount);
            }
            charsRead = br.read(buffer);
        }
        br.close();
        return lineCount;
    }
}

