/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.Edges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.gui.Console;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.Config;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.InOut;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splitter {
    private float threshold;

    public void run(HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins) throws IOException {
        this.threshold = Config.threshold;
        if (Config.gui) {
            Console.println("Start reading similarity file ... ");
        }
        Edges es = InOut.readSimilarityFile(Config.similarityFile, proteins2integers, integers2proteins);
        if (Config.gui) {
            Console.println();
        }
        if (Config.gui) {
            Console.println("Start splitting ...");
            Console.setBarValue(0);
            Console.setBarText("splitting into connected components");
        }
        Vector<Vector<Integer>> clusters = Splitter.splitIntoConnectedComponents(es, proteins2integers, this.threshold, false);
        if (Config.gui) {
            Console.println();
        }
        if (Config.gui) {
            Console.println("Writing costmatrices ...");
            Console.setBarValue(0);
            Console.restartBarTimer();
            Console.setBarText("writing costmatrices");
        }
        InOut.writeCostMatrices(es, clusters, proteins2integers, integers2proteins);
        if (Config.gui) {
            Console.println();
        }
    }

    public static Vector<Vector<Integer>> splitIntoConnectedComponents(Edges es, HashMap<Integer, String> proteins2integers, float threshold, boolean mergenNodes) {
        Vector<Vector<Integer>> v = new Vector<Vector<Integer>>();
        int[] distribution = new int[es.size2() + 1];
        boolean[] already = new boolean[es.size2()];
        for (int i = 0; i < already.length; ++i) {
            if (already[i]) continue;
            Vector<Integer> cluster2 = new Vector<Integer>();
            cluster2.add(i);
            already[i] = true;
            Splitter.findCluster(es, cluster2, proteins2integers, i, already, threshold, mergenNodes);
            v.add(cluster2);
            int n = cluster2.size();
            distribution[n] = distribution[n] + 1;
        }
        return v;
    }

    private static void findCluster(Edges es, Vector<Integer> cluster2, HashMap<Integer, String> proteins2integers, Integer element, boolean[] already, float threshold, boolean mergeNodes) {
        int startPosition = 0;
        int endPosition = 0;
        if (mergeNodes) {
            startPosition = es.getStartPosition(Integer.parseInt(proteins2integers.get(element)));
            endPosition = es.getEndPosition(Integer.parseInt(proteins2integers.get(element)));
        } else {
            startPosition = es.getStartPosition(element);
            endPosition = es.getEndPosition(element);
        }
        for (int i = startPosition; i < endPosition; ++i) {
            double value;
            int target = es.getTarget(i);
            if (already[target] || !((value = (double)es.getValue(i)) > (double)threshold)) continue;
            cluster2.add(target);
            already[target] = true;
            Splitter.findCluster(es, cluster2, proteins2integers, target, already, threshold, mergeNodes);
        }
    }
}

