/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;

public class CC1DArray
implements ICCEdges {
    private float[] edgeCostArray;
    private int[] pos;
    private float maxFromNormalisation;
    private float minFromNormalisation;
    private double l;
    private double r;
    private double minFromNormalisationWithThreshold;
    private double maxFromNormalisationWithThreshold;
    private int size;
    private int dum;

    public CC1DArray(int size) {
        this.size = size;
        this.initCCEdges(size);
    }

    public CC1DArray clone() {
        CC1DArray clone = new CC1DArray(this.edgeCostArray.length);
        clone.l = this.l;
        clone.r = this.r;
        clone.minFromNormalisation = this.minFromNormalisation;
        clone.maxFromNormalisation = this.maxFromNormalisation;
        clone.minFromNormalisationWithThreshold = this.minFromNormalisationWithThreshold;
        clone.maxFromNormalisationWithThreshold = this.maxFromNormalisationWithThreshold;
        clone.edgeCostArray = (float[])this.edgeCostArray.clone();
        return clone;
    }

    public void initCCEdges(int size) {
        this.edgeCostArray = new float[size * (size - 1) / 2];
        this.pos = new int[size];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            this.pos[i] = count;
            for (int j = i + 1; j < size; ++j) {
                ++count;
            }
        }
    }

    public void setEdgeCost(int node_i, int node_j, float cost) {
        if (node_i > node_j) {
            this.edgeCostArray[this.pos[node_j] + (node_i - node_j) - 1] = cost;
        } else {
            this.edgeCostArray[this.pos[node_i] + (node_j - node_i) - 1] = cost;
        }
    }

    public float getEdgeCost(int node_i, int node_j) {
        this.dum = node_j - node_i;
        if (this.dum > 0) {
            return this.edgeCostArray[this.pos[node_i] + this.dum - 1];
        }
        return this.edgeCostArray[this.pos[node_j] - this.dum - 1];
    }

    public void normalise() {
        int j;
        int i;
        if (this.edgeCostArray.length < 2) {
            return;
        }
        float min = this.edgeCostArray[0];
        float max = this.edgeCostArray[0];
        for (i = 0; i < this.size; ++i) {
            for (j = i + 1; j < this.size; ++j) {
                if (Math.abs(this.edgeCostArray[this.pos[i] + (j - i) - 1]) > max) {
                    max = Math.abs(this.edgeCostArray[this.pos[i] + (j - i) - 1]);
                }
                if (!(this.edgeCostArray[this.pos[i] + (j - i) - 1] < min)) continue;
                min = this.edgeCostArray[this.pos[i] + (j - i) - 1];
            }
        }
        this.maxFromNormalisation = max;
        this.minFromNormalisation = min;
        if (max == 0.0f) {
            return;
        }
        for (i = 0; i < this.size; ++i) {
            for (j = i + 1; j < this.size; ++j) {
                this.edgeCostArray[this.pos[i] + (j - i) - 1] = this.edgeCostArray[this.pos[i] + (j - i) - 1] > 0.0f ? this.edgeCostArray[this.pos[i] + (j - i) - 1] / max : this.edgeCostArray[this.pos[i] + (j - i) - 1] / max;
            }
        }
    }

    public void normaliseWithThreshold(double alpha) {
        int j;
        int i;
        if (this.edgeCostArray.length < 2) {
            return;
        }
        float min = this.edgeCostArray[1];
        float max = this.edgeCostArray[1];
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                if (i == j) continue;
                if (this.edgeCostArray[this.pos[i] + (j - i) - 1] > max) {
                    max = this.edgeCostArray[this.pos[i] + (j - i) - 1];
                }
                if (!(this.edgeCostArray[this.pos[i] + (j - i) - 1] < min)) continue;
                min = this.edgeCostArray[this.pos[i] + (j - i) - 1];
            }
        }
        this.maxFromNormalisationWithThreshold = max;
        this.minFromNormalisationWithThreshold = min;
        if (Math.abs(min) < Math.abs(max)) {
            this.l = -alpha * (double)Math.abs(min) / (double)max;
            this.r = 1.0;
        } else {
            this.l = -1.0;
            this.r = alpha * (double)max / (double)Math.abs(min);
        }
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                this.edgeCostArray[this.pos[i] + (j - i) - 1] = this.edgeCostArray[this.pos[i] + (j - i) - 1] > 0.0f ? (float)this.r * this.edgeCostArray[this.pos[i] + (j - i) - 1] / max : (float)this.l * this.edgeCostArray[this.pos[i] + (j - i) - 1] / min;
            }
        }
    }

    public void denormalise() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = i + 1; j < this.size; ++j) {
                this.edgeCostArray[this.pos[i] + (j - i) - 1] = this.edgeCostArray[this.pos[i] + (j - i) - 1] > 0.0f ? this.edgeCostArray[this.pos[i] + (j - i) - 1] * this.maxFromNormalisation : this.edgeCostArray[this.pos[i] + (j - i) - 1] * this.maxFromNormalisation;
            }
        }
    }

    public void denormaliseWithThreshold() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.edgeCostArray[this.pos[i] + (j - i) - 1] = this.edgeCostArray[this.pos[i] + (j - i) - 1] > 0.0f ? (float)((double)this.edgeCostArray[this.pos[i] + (j - i) - 1] / this.r * this.maxFromNormalisationWithThreshold) : (float)((double)this.edgeCostArray[this.pos[i] + (j - i) - 1] / this.l * this.minFromNormalisationWithThreshold);
            }
        }
    }
}

