/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;
import java.util.HashMap;
import java.util.Set;

public class CCHash
implements ICCEdges {
    private HashMap<Integer, Float> edgeCostHash;
    private int size;

    public CCHash(int size) {
        this.initCCEdges(size);
        this.size = size;
    }

    public CCHash clone() {
        return null;
    }

    public void initCCEdges(int size) {
        double minInitialCapacity = (double)size / 0.75;
        System.out.println("=== size:" + size + " ===");
        int initialCapacity = Math.round((float)minInitialCapacity) + 10;
        System.out.println("=== initial capacity:" + initialCapacity + " ===");
        this.edgeCostHash = new HashMap(initialCapacity);
    }

    public void setEdgeCost(int node_i, int node_j, float cost) {
        this.edgeCostHash.put(node_i * this.size + node_j, Float.valueOf(cost));
        this.edgeCostHash.put(node_j * this.size + node_i, Float.valueOf(cost));
    }

    public float getEdgeCost(int node_i, int node_j) {
        return this.edgeCostHash.get(node_i * this.size + node_j).floatValue();
    }

    public void normalise() {
        float min;
        if (this.edgeCostHash.size() < 1) {
            return;
        }
        float max = min = this.getEdgeCost(0, 1);
        Set<Integer> keySet = this.edgeCostHash.keySet();
        for (Integer element : keySet) {
            float x = this.edgeCostHash.get(element).floatValue();
            if (x > max) {
                max = x;
            }
            if (!(x < min)) continue;
            min = x;
        }
        float range = max - min;
        for (Integer element : keySet) {
            float x = this.edgeCostHash.get(element).floatValue();
            x = (x - min) / range;
            this.edgeCostHash.put(element, Float.valueOf(x));
        }
    }

    public void normaliseWithThreshold(double alpha) {
        double r;
        double l;
        float min;
        if (this.edgeCostHash.size() < 1) {
            return;
        }
        float max = min = this.getEdgeCost(0, 1);
        Set<Integer> keySet = this.edgeCostHash.keySet();
        for (Integer element : keySet) {
            float x = this.edgeCostHash.get(element).floatValue();
            if (x > max) {
                max = x;
            }
            if (!(x < min)) continue;
            min = x;
        }
        if (Math.abs(min) < Math.abs(max)) {
            l = -alpha * (double)Math.abs(min) / (double)max;
            r = 1.0;
        } else {
            l = -1.0;
            r = alpha * (double)max / (double)Math.abs(min);
        }
        for (Integer element : keySet) {
            float x = this.edgeCostHash.get(element).floatValue();
            x = x > 0.0f ? (float)r * x / max : (float)l * x / min;
            this.edgeCostHash.put(element, Float.valueOf(x));
        }
    }

    public void denormalise() {
    }

    public void denormaliseWithThreshold() {
    }
}

