/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;

public class CCSymmetricArray
implements ICCEdges {
    private Object[] symmetricEdgeArray;
    private double maxFromNormalisation;
    private double minFromNormalisation;
    private double minFromNormalisatioWithThreshold;

    public CCSymmetricArray(int size) {
        this.initCCEdges(size);
    }

    public CCSymmetricArray clone() {
        return null;
    }

    public void initCCEdges(int size) {
        this.symmetricEdgeArray = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.symmetricEdgeArray[i] = new float[i + 1];
        }
    }

    public void setEdgeCost(int node_i, int node_j, float cost) {
        if (node_i > node_j) {
            float[] edges4i = (float[])this.symmetricEdgeArray[node_i];
            edges4i[node_j] = cost;
        } else if (node_i < node_j) {
            float[] edges4j = (float[])this.symmetricEdgeArray[node_j];
            edges4j[node_i] = cost;
        }
    }

    public float getEdgeCost(int node_i, int node_j) {
        float cost = node_i >= node_j ? ((float[])this.symmetricEdgeArray[node_i])[node_j] : ((float[])this.symmetricEdgeArray[node_j])[node_i];
        return cost;
    }

    public void normalise() {
        float min;
        if (this.symmetricEdgeArray.length < 2) {
            return;
        }
        float max = min = ((float[])this.symmetricEdgeArray[0])[0];
        for (int i = 0; i < this.symmetricEdgeArray.length; ++i) {
            float[] arr = (float[])this.symmetricEdgeArray[i];
            for (int j = 0; j < arr.length; ++j) {
                if (arr[j] > max) {
                    max = arr[j];
                }
                if (!(arr[j] < min)) continue;
                min = arr[j];
            }
        }
        this.minFromNormalisation = min;
        this.maxFromNormalisation = max;
        float range = max - min;
        for (int i = 0; i < this.symmetricEdgeArray.length; ++i) {
            float[] arr = (float[])this.symmetricEdgeArray[i];
            for (int j = 0; j < arr.length; ++j) {
                arr[j] = (arr[j] - min) / range;
            }
        }
    }

    public void normaliseWithThreshold(double alpha) {
        double r;
        double l;
        float min;
        if (this.symmetricEdgeArray.length < 2) {
            return;
        }
        float max = min = ((float[])this.symmetricEdgeArray[0])[0];
        for (int i = 0; i < this.symmetricEdgeArray.length; ++i) {
            float[] arr = (float[])this.symmetricEdgeArray[i];
            for (int j = 0; j < arr.length; ++j) {
                if (arr[j] > max) {
                    max = arr[j];
                }
                if (!(arr[j] < min)) continue;
                min = arr[j];
            }
        }
        if (Math.abs(min) < Math.abs(max)) {
            l = -alpha * (double)Math.abs(min) / (double)max;
            r = 1.0;
        } else {
            l = -1.0;
            r = alpha * (double)max / (double)Math.abs(min);
        }
        for (int i = 0; i < this.symmetricEdgeArray.length; ++i) {
            float[] arr = (float[])this.symmetricEdgeArray[i];
            for (int j = 0; j < arr.length; ++j) {
                arr[j] = arr[j] > 0.0f ? (float)r * arr[j] / max : (float)l * arr[j] / min;
            }
        }
    }

    public void denormalise() {
        double range = this.maxFromNormalisation - this.minFromNormalisatioWithThreshold;
        for (int i = 0; i < this.symmetricEdgeArray.length; ++i) {
            float[] arr = (float[])this.symmetricEdgeArray[i];
            for (int j = 0; j < arr.length; ++j) {
                arr[j] = (float)((double)arr[j] * range - this.minFromNormalisation);
            }
        }
    }

    public void denormaliseWithThreshold() {
    }
}

