/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.fixedparameterclustering.FixedParameterTreeNode;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.greedy.GreedyClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.IPostProcessing;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedComponent {
    private ConnectedComponent reducedConnectedComponent = null;
    private ICCEdges ccEdges = null;
    private double[][] ccPositions = null;
    private String[] objectIDs = null;
    private int node_no = -1;
    private int[] clusters = null;
    private double clusteringScore = -1.0;
    private int numberOfClusters = -1;
    private int[] clusterDistribution = null;
    private String ccPath = "";
    private double reductionCost = 0.0;

    public Object clone() throws CloneNotSupportedException {
        ConnectedComponent clone = new ConnectedComponent(this.ccEdges.clone(), (String[])this.objectIDs.clone(), this.ccPath);
        clone.ccPositions = (double[][])this.ccPositions.clone();
        return clone;
    }

    public ConnectedComponent getReducedConnectedComponent() {
        return this.reducedConnectedComponent;
    }

    public void setReducedConnectedComponent(ConnectedComponent reducedConnectedComponent) {
        this.reducedConnectedComponent = reducedConnectedComponent;
    }

    public ConnectedComponent(ICCEdges ccEdges, String[] object_ids, String ccPath) {
        this.ccEdges = ccEdges;
        this.objectIDs = object_ids;
        this.node_no = object_ids.length;
        this.clusters = new int[this.node_no];
        this.ccPath = ccPath;
        if (this.node_no < 200) {
            this.buildReducedCC();
        }
    }

    private boolean buildReducedCC() {
        ConnectedComponent ccCopy = this.copy();
        new GreedyClusterer(ccCopy);
        IPostProcessing pp = PostProcessingFactory.EnumPostProcessingClass.PP_REARRANGE_AND_MERGE_BEST.createPostProcessor();
        pp.initPostProcessing(ccCopy);
        pp.run();
        ConnectedComponent ccCopy2 = this.copy();
        ccCopy2.setClusteringScore(Double.MAX_VALUE);
        if (ccCopy.getClusteringScore() < ccCopy2.getClusteringScore()) {
            boolean isChanged = this.reduceCC(ccCopy, (float)(Math.rint(ccCopy.getClusteringScore() * 1000.0) + 1.0) / 1000.0f);
            if (isChanged) {
                this.reducedConnectedComponent = ccCopy;
                if (ccCopy.buildReducedCC()) {
                    this.reducedConnectedComponent = ccCopy.reducedConnectedComponent;
                }
            }
            return isChanged;
        }
        boolean isChanged = this.reduceCC(ccCopy2, (float)(Math.rint(ccCopy2.getClusteringScore() * 1000.0) + 1.0) / 1000.0f);
        if (isChanged) {
            this.reducedConnectedComponent = ccCopy2;
            if (ccCopy2.buildReducedCC()) {
                this.reducedConnectedComponent = ccCopy2.reducedConnectedComponent;
            }
        }
        return isChanged;
    }

    public ConnectedComponent(ICCEdges ccEdges, String[] object_ids, String ccPath, boolean reduced) {
        this.ccEdges = ccEdges;
        this.objectIDs = object_ids;
        this.node_no = object_ids.length;
        this.clusters = new int[this.node_no];
        this.ccPath = ccPath;
    }

    public boolean isPositionEqual(double[] pos_a, double[] pos_b) {
        for (int i = 0; i < pos_a.length; ++i) {
            if (pos_a[i] == pos_b[i]) continue;
            return false;
        }
        return true;
    }

    public ICCEdges getCCEdges() {
        return this.ccEdges;
    }

    public void setCCEdges(ICCEdges ccEdges) {
        this.ccEdges = ccEdges;
    }

    public double[][] getCCPositions() {
        return this.ccPositions;
    }

    public double[] getCCPostions(int i) {
        return this.ccPositions[i];
    }

    public void setCCPositions(double[][] ccPositions) {
        this.ccPositions = ccPositions;
    }

    public String[] getObjectIDs() {
        return this.objectIDs;
    }

    public void setObjectIDs(String[] objectIDs) {
        this.objectIDs = objectIDs;
    }

    public int getNodeNumber() {
        return this.node_no;
    }

    public void setNodeNumber(int node_no) {
        this.node_no = node_no;
    }

    public void initialiseClusterInfo(int noOfClusters) {
        this.clusterDistribution = new int[noOfClusters];
        this.numberOfClusters = noOfClusters;
    }

    public void setClusterInfo(int[] clusterDistribution) {
        this.clusterDistribution = clusterDistribution;
    }

    public int[] getClusterInfo() {
        return this.clusterDistribution;
    }

    public void calculateClusterDistribution() {
        for (int i = 0; i < this.clusters.length; ++i) {
            int n = this.clusters[i];
            this.clusterDistribution[n] = this.clusterDistribution[n] + 1;
        }
    }

    public void setClusters(int[] clusters) {
        this.clusters = clusters;
    }

    public int[] getClusters() {
        return this.clusters;
    }

    public int getClusterMagnitude(int cluster_no) {
        try {
            return this.clusterDistribution[cluster_no];
        }
        catch (NullPointerException ex) {
            System.err.println("ERROR: Either the clusterDistribution variable in theConnectedComponent object hasn't been initialised, or it doesn'tcontain the cluster number " + cluster_no + ". == " + ex.getMessage());
            return -1;
        }
    }

    public void setClusterMagnitude(int cluster_no, int magnitude) {
        try {
            this.clusterDistribution[cluster_no] = magnitude;
        }
        catch (NullPointerException ex) {
            System.err.println("ERROR: Either the clusterDistribution variable in theConnectedComponent object hasn't been initialised, or it doesn'tcontain this cluster number " + cluster_no + ". == " + ex.getMessage());
        }
    }

    public int getClusterNoForObject(int object_no) {
        return this.clusters[object_no];
    }

    public void setClusterNoForObject(int object_no, int cluster_no) {
        this.clusters[object_no] = cluster_no;
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public double getClusteringScore() {
        return this.clusteringScore;
    }

    public void setClusteringScore(double score) {
        this.clusteringScore = score;
    }

    public double calculateClusteringScore(int[] clusters) {
        double score = 0.0;
        for (int i = 0; i < clusters.length; ++i) {
            for (int j = i + 1; j < clusters.length; ++j) {
                double edgeCost = this.ccEdges.getEdgeCost(i, j);
                if (clusters[i] != clusters[j]) {
                    if (!(edgeCost > 0.0)) continue;
                    score += edgeCost;
                    continue;
                }
                if (!(edgeCost < 0.0)) continue;
                score -= edgeCost;
            }
        }
        return score;
    }

    public void printClusters() {
        System.out.println("Clusters:");
        for (int i = 0; i < this.clusters.length; ++i) {
            System.out.println("Item " + i + " is in Cluster " + this.clusters[i]);
        }
    }

    public String getCcPath() {
        return this.ccPath;
    }

    public ConnectedComponent copy() {
        ConnectedComponent newCC = new ConnectedComponent(this.ccEdges, (String[])this.objectIDs.clone(), this.ccPath, true);
        newCC.reductionCost = this.reductionCost;
        return newCC;
    }

    public ConnectedComponent copy(boolean withReduction) {
        ConnectedComponent newCC = new ConnectedComponent(this.ccEdges, this.objectIDs, this.ccPath, true);
        newCC.reductionCost = this.reductionCost;
        try {
            newCC.setReducedConnectedComponent(this.getReducedConnectedComponent().copy());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newCC;
    }

    public double[][] copyCCPositions() {
        int dim = TaskConfig.dimension;
        double[][] copiedPos = new double[this.node_no][dim];
        for (int i = 0; i < this.node_no; ++i) {
            for (int j = 0; j < dim; ++j) {
                copiedPos[i][j] = this.ccPositions[i][j];
            }
        }
        return copiedPos;
    }

    public String getObjectID(int num) {
        return this.objectIDs[num];
    }

    public ConnectedComponent createConnectedComponentForCluster(int clusterNo, ArrayList<Integer> intsInCluster) {
        int size = intsInCluster.size();
        String[] subIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            subIDs[i] = intsInCluster.get(i).toString();
        }
        try {
            ICCEdges subEdges = LayoutFactory.getCCEdgesEnumByClass(TaskConfig.ccEdgesClass).createCCEdges(size);
            for (int i = 0; i < subIDs.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    subEdges.setEdgeCost(i, j, this.ccEdges.getEdgeCost(Integer.parseInt(subIDs[i]), Integer.parseInt(subIDs[j])));
                }
            }
            ConnectedComponent subCC = new ConnectedComponent(subEdges, subIDs, this.ccPath);
            return subCC;
        }
        catch (InvalidTypeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public double getReductionCost() {
        return this.reductionCost;
    }

    public void setReductionCost(double reductionCost) {
        this.reductionCost = reductionCost;
    }

    private boolean reduceCC(ConnectedComponent cc, float clusteringScore2) {
        FixedParameterTreeNode fptn = ConnectedComponent.initFirstTreeNode(cc, clusteringScore2);
        if (fptn.size == cc.getNodeNumber()) {
            return false;
        }
        ICCEdges ccedges = TaskConfig.ccEdgesEnum.createCCEdges(fptn.size);
        for (int i = 0; i < fptn.size; ++i) {
            for (int j = i + 1; j < fptn.size; ++j) {
                ccedges.setEdgeCost(i, j, fptn.edgeCosts[i][j]);
            }
        }
        String[] objectIds = new String[fptn.size];
        for (int i = 0; i < objectIds.length; ++i) {
            String id = "";
            for (int j = 0; j < fptn.clusters[i].length; ++j) {
                if (!fptn.clusters[i][j]) continue;
                id = id + cc.getObjectID(j) + ";";
            }
            objectIds[i] = id;
        }
        cc.setNodeNumber(fptn.size);
        cc.setCCEdges(ccedges);
        cc.setObjectIDs(objectIds);
        cc.setClusters(new int[fptn.size]);
        cc.setReductionCost(fptn.costs);
        return true;
    }

    public void rebuildCC() {
        this.initialiseClusterInfo(this.reducedConnectedComponent.getNumberOfClusters());
        int[] clusters = new int[this.getNodeNumber()];
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        for (int i = 0; i < this.getNodeNumber(); ++i) {
            h.put(this.getObjectID(i), i);
        }
        for (int j = 0; j < this.reducedConnectedComponent.getNodeNumber(); ++j) {
            String id = this.reducedConnectedComponent.getObjectID(j);
            String[] split = id.split(";");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].trim().equals("")) continue;
                clusters[((Integer)h.get((Object)split[i])).intValue()] = this.reducedConnectedComponent.getClusters()[j];
            }
        }
        this.setClusteringScore(this.calculateClusteringScore(clusters));
        this.setClusters(clusters);
        this.calculateClusterDistribution();
    }

    public static float calculateCostsForMerging(FixedParameterTreeNode fptn, int node_i, int node_j) {
        float costsForMerging = 0.0f;
        for (int i = 0; i < fptn.size; ++i) {
            if (i == node_i || i == node_j || fptn.edgeCosts[i][node_i] > 0.0f && fptn.edgeCosts[i][node_j] > 0.0f || fptn.edgeCosts[i][node_i] <= 0.0f && fptn.edgeCosts[i][node_j] <= 0.0f) continue;
            costsForMerging += Math.min(Math.abs(fptn.edgeCosts[i][node_i]), Math.abs(fptn.edgeCosts[i][node_j]));
        }
        if (fptn.edgeCosts[node_i][node_j] < 0.0f) {
            costsForMerging -= fptn.edgeCosts[node_i][node_j];
        }
        return costsForMerging;
    }

    public static float calculateCostsForSetForbidden(FixedParameterTreeNode fptn, int node_i, int node_j) {
        float costs = 0.0f;
        for (int i = 0; i < fptn.size; ++i) {
            if (!(fptn.edgeCosts[node_i][i] > 0.0f) || !(fptn.edgeCosts[node_j][i] > 0.0f)) continue;
            costs += Math.min(fptn.edgeCosts[node_i][i], fptn.edgeCosts[node_j][i]);
        }
        if (fptn.edgeCosts[node_i][node_j] > 0.0f) {
            costs += fptn.edgeCosts[node_i][node_j];
        }
        return costs;
    }

    public static FixedParameterTreeNode initFirstTreeNode(ConnectedComponent cc, double maxK) {
        FixedParameterTreeNode fptn = new FixedParameterTreeNode(cc.getNodeNumber(), 0.0f, cc.getNodeNumber());
        for (int i = 0; i < fptn.size; ++i) {
            fptn.clusters[i][i] = true;
            for (int j = i + 1; j < fptn.size; ++j) {
                float f = cc.getCCEdges().getEdgeCost(i, j);
                fptn.edgeCosts[j][i] = f;
                fptn.edgeCosts[i][j] = f;
            }
        }
        fptn = ConnectedComponent.reductionicf(fptn, maxK, cc);
        return fptn;
    }

    public static FixedParameterTreeNode mergeNodes(FixedParameterTreeNode fptn, int node_i, int node_j, float costsForMerging, ConnectedComponent cc) {
        int i;
        FixedParameterTreeNode fptnNew = new FixedParameterTreeNode(fptn.size - 1, fptn.costs, cc.getNodeNumber());
        fptnNew.costs = fptn.costs + costsForMerging;
        int[] mappingOld2New = new int[fptn.size];
        int j = 0;
        for (i = 0; i < fptn.size; ++i) {
            if (i == node_i || i == node_j) continue;
            mappingOld2New[i] = j;
            fptnNew.clusters[j] = fptn.clusters[i];
            ++j;
        }
        for (i = 0; i < mappingOld2New.length; ++i) {
            if (i == node_i || i == node_j) continue;
            for (j = i + 1; j < mappingOld2New.length; ++j) {
                if (j == node_i || j == node_j) continue;
                float f = fptn.edgeCosts[i][j];
                fptnNew.edgeCosts[mappingOld2New[j]][mappingOld2New[i]] = f;
                fptnNew.edgeCosts[mappingOld2New[i]][mappingOld2New[j]] = f;
            }
        }
        for (i = 0; i < cc.getNodeNumber(); ++i) {
            fptnNew.clusters[fptnNew.size - 1][i] = fptn.clusters[node_i][i] || fptn.clusters[node_j][i];
        }
        for (i = 0; i < fptn.size; ++i) {
            if (i == node_i || i == node_j) continue;
            float f = fptn.edgeCosts[i][node_i] + fptn.edgeCosts[i][node_j];
            fptnNew.edgeCosts[fptnNew.size - 1][mappingOld2New[i]] = f;
            fptnNew.edgeCosts[mappingOld2New[i]][fptnNew.size - 1] = f;
        }
        return fptnNew;
    }

    public static FixedParameterTreeNode reductionicf(FixedParameterTreeNode fptnNew, double maxK, ConnectedComponent cc) {
        for (int i = 0; i < fptnNew.size; ++i) {
            for (int j = i + 1; j < fptnNew.size; ++j) {
                float sumIcf = ConnectedComponent.calculateCostsForSetForbidden(fptnNew, i, j);
                if (!((double)(sumIcf + fptnNew.costs) > maxK)) continue;
                float costsForMerging = ConnectedComponent.calculateCostsForMerging(fptnNew, i, j);
                FixedParameterTreeNode fptnNew2 = ConnectedComponent.mergeNodes(fptnNew, i, j, costsForMerging, cc);
                fptnNew2 = ConnectedComponent.reductionicf(fptnNew2, maxK, cc);
                return fptnNew2;
            }
        }
        return fptnNew;
    }
}

