/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class CostMatrixReader {
    private int node_no = 0;
    private String[] ids = null;
    private Object[] values = null;
    private String cmPath = "";
    private double reductionCost = 0.0;

    public CostMatrixReader(File file) {
        try {
            int i;
            String line;
            this.cmPath = file.toString();
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            if (this.cmPath.endsWith(".rcm")) {
                line = br.readLine();
                this.reductionCost = Double.parseDouble(line.trim());
            }
            line = br.readLine();
            this.node_no = Integer.parseInt(line);
            this.ids = new String[this.node_no];
            for (i = 0; i < this.node_no; ++i) {
                this.ids[i] = line = br.readLine();
            }
            this.values = new Object[this.node_no - 1];
            for (i = 0; i < this.node_no - 1; ++i) {
                line = br.readLine();
                String[] stringValues = line.split("\t");
                float[] values2 = new float[stringValues.length];
                for (int j = 0; j < values2.length; ++j) {
                    values2[j] = Float.parseFloat(stringValues[j]);
                }
                this.values[i] = values2;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public ConnectedComponent getConnectedComponent() {
        ICCEdges ccEdges = TaskConfig.ccEdgesEnum.createCCEdges(this.node_no);
        for (int i = 0; i < this.values.length; ++i) {
            float[] vals = (float[])this.values[i];
            for (int j = 0; j < vals.length; ++j) {
                ccEdges.setEdgeCost(i, j + i + 1, vals[j]);
            }
        }
        ConnectedComponent comp = new ConnectedComponent(ccEdges, this.ids, this.cmPath);
        comp.setReductionCost(this.reductionCost);
        return comp;
    }
}

