/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.CalculateClustersTask;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.GeometricClusteringConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.IGeometricClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleLinkageClusterer
implements IGeometricClusterer {
    private double minDistance;
    private double maxDistance;
    private double stepsize;
    private double stepsizeFactor;
    private int noOfClusters;
    private double bestDistance;
    private ConnectedComponent cc;
    private float[][] distances;
    private float[] sortedDistances;
    private ExecutorService es;

    @Override
    public void initGeometricClusterer(ConnectedComponent cc) {
        this.es = TaskConfig.useThreads ? Executors.newFixedThreadPool(TaskConfig.maxNoThreads) : Executors.newFixedThreadPool(1);
        this.cc = cc;
        this.minDistance = GeometricClusteringConfig.minDistance;
        this.maxDistance = GeometricClusteringConfig.maxDistance;
        this.stepsize = GeometricClusteringConfig.stepsize;
        this.stepsizeFactor = GeometricClusteringConfig.stepsizeFactor;
        this.distances = new float[this.cc.getNodeNumber()][this.cc.getNodeNumber()];
        this.sortedDistances = new float[(this.cc.getNodeNumber() - 1) * this.cc.getNodeNumber() / 2 + 1];
        int k = 0;
        this.sortedDistances[k] = -1.0f;
        ++k;
        for (int i = 0; i < this.distances.length; ++i) {
            for (int j = i + 1; j < this.distances.length; ++j) {
                float f = this.calculateEuclidianDistance(this.cc.getCCPostions(i), this.cc.getCCPostions(j));
                this.distances[j][i] = f;
                this.distances[i][j] = f;
                this.sortedDistances[k] = this.distances[i][j];
                ++k;
            }
        }
        Arrays.sort(this.sortedDistances);
    }

    public void run3() {
        ArrayList cluster2;
        long time = System.currentTimeMillis();
        double bestScore = Double.MAX_VALUE;
        int[] bestClustersArray = new int[this.cc.getNodeNumber()];
        int[] clustersArray = new int[this.cc.getNodeNumber()];
        int bestClusterNr = -1;
        float[][] distOld = this.distances;
        ArrayList<ArrayList> clusters = new ArrayList<ArrayList>();
        for (int i = 0; i < distOld.length; ++i) {
            cluster2 = new ArrayList();
            cluster2.add(i);
            clusters.add(cluster2);
        }
        for (int j = 0; j < clusters.size(); ++j) {
            cluster2 = (ArrayList)clusters.get(j);
            for (Integer integer : cluster2) {
                clustersArray[integer.intValue()] = j;
            }
        }
        double score = this.cc.calculateClusteringScore(clustersArray);
        if (score < bestScore) {
            bestScore = score;
            bestClustersArray = (int[])clustersArray.clone();
            bestClusterNr = this.cc.getNodeNumber();
        }
        for (int i = this.cc.getNodeNumber() - 1; i > 0; --i) {
            int j;
            float[][] dist2 = new float[i][i];
            float min = Float.MAX_VALUE;
            int minj = -1;
            int mink = -1;
            for (j = 0; j < distOld.length; ++j) {
                for (int k = j + 1; k < distOld.length; ++k) {
                    if (!(distOld[j][k] < min)) continue;
                    min = distOld[j][k];
                    minj = j;
                    mink = k;
                }
            }
            ((ArrayList)clusters.get(minj)).addAll((Collection)clusters.get(mink));
            clusters.remove(mink);
            for (j = 0; j < clusters.size(); ++j) {
                ArrayList cluster3 = (ArrayList)clusters.get(j);
                for (Integer integer : cluster3) {
                    clustersArray[integer.intValue()] = j;
                }
            }
            score = this.cc.calculateClusteringScore(clustersArray);
            if (score < bestScore) {
                bestScore = score;
                bestClustersArray = (int[])clustersArray.clone();
                bestClusterNr = i;
            }
            int[] mappingOld2New = new int[distOld.length];
            int m = 0;
            for (int l = 0; l < distOld.length; ++l) {
                if (l == mink) continue;
                mappingOld2New[l] = m++;
            }
            for (int j2 = 0; j2 < mappingOld2New.length; ++j2) {
                if (j2 == mink) continue;
                for (int k = j2 + 1; k < mappingOld2New.length; ++k) {
                    if (k == mink) continue;
                    if (j2 == minj) {
                        float f = Math.min(distOld[minj][k], distOld[mink][k]);
                        dist2[mappingOld2New[k]][mappingOld2New[j2]] = f;
                        dist2[mappingOld2New[j2]][mappingOld2New[k]] = f;
                        continue;
                    }
                    float f = distOld[j2][k];
                    dist2[mappingOld2New[k]][mappingOld2New[j2]] = f;
                    dist2[mappingOld2New[j2]][mappingOld2New[k]] = f;
                }
            }
            distOld = (float[][])dist2.clone();
        }
        this.cc.initialiseClusterInfo(bestClusterNr);
        this.cc.setClusteringScore(bestScore);
        this.cc.setClusters(bestClustersArray);
        this.cc.calculateClusterDistribution();
        System.out.println("time for single linkage " + (System.currentTimeMillis() - time));
    }

    @Override
    public void run() {
        try {
            this.runForSortedArray(0, this.sortedDistances.length);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        int[] clusters = new int[this.cc.getNodeNumber()];
        boolean[] already = new boolean[this.cc.getNodeNumber()];
        int clusterNr = this.calculateClusters(this.bestDistance, clusters, already);
        this.cc.initialiseClusterInfo(clusterNr);
        this.cc.setClusteringScore(this.cc.calculateClusteringScore(clusters));
        this.cc.setClusters(clusters);
        this.cc.calculateClusterDistribution();
    }

    public void runForSortedArray(int a, int b) throws InterruptedException, ExecutionException {
        ArrayList<CalculateClustersTask> test = new ArrayList<CalculateClustersTask>();
        if (b - a < 20) {
            this.es = TaskConfig.useThreads ? Executors.newFixedThreadPool(TaskConfig.maxNoThreads) : Executors.newFixedThreadPool(1);
            double bestScore = Double.MAX_VALUE;
            double bestScoreParallel = Double.MAX_VALUE;
            double bestDistanceParallel = -1.0;
            for (int i = a; i < b; ++i) {
                float distance = this.sortedDistances[i];
                CalculateClustersTask cct = new CalculateClustersTask(distance, this.distances, this.cc);
                test.add(cct);
                this.es.execute(cct);
            }
            this.es.shutdown();
            try {
                this.es.awaitTermination(5L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (CalculateClustersTask calculateClustersTask : test) {
                if (!(calculateClustersTask.score < bestScore)) continue;
                bestScore = calculateClustersTask.score;
                this.bestDistance = calculateClustersTask.distance;
            }
        } else {
            int step = (int)Math.floor((double)(b - a) / 20.0);
            int bestStep = -1;
            double bestScore = Double.MAX_VALUE;
            int[] clusters = new int[this.cc.getNodeNumber()];
            int i = 0;
            int j = a;
            while (i < 20) {
                float distance = this.sortedDistances[j];
                CalculateClustersTask cct = new CalculateClustersTask(distance, this.distances, this.cc);
                test.add(cct);
                this.es.execute(cct);
                ++i;
                j += step;
            }
            this.es.shutdown();
            try {
                this.es.awaitTermination(5L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (CalculateClustersTask calculateClustersTask : test) {
                if (!(calculateClustersTask.score < bestScore)) continue;
                bestScore = calculateClustersTask.score;
                bestStep = Arrays.binarySearch(this.sortedDistances, (float)calculateClustersTask.distance);
            }
            this.es = TaskConfig.useThreads ? Executors.newFixedThreadPool(TaskConfig.maxNoThreads) : Executors.newFixedThreadPool(1);
            if (bestStep == 0) {
                this.runForSortedArray(0, 2 * step);
            } else if (bestStep == 19 * step) {
                this.runForSortedArray(18 * step, b - a);
            } else {
                this.runForSortedArray(Math.max(0, bestStep - step), bestStep + step);
            }
        }
    }

    public void run4() {
        long time = System.currentTimeMillis();
        this.bestDistance = 0.0;
        int[] clusters = new int[this.cc.getNodeNumber()];
        for (int i = 0; i < clusters.length; ++i) {
            clusters[i] = i;
        }
        double bestScore = this.cc.calculateClusteringScore(clusters);
        double count = 0.0;
        for (int i = 0; i < this.sortedDistances.length; ++i) {
            boolean[] already = new boolean[this.cc.getNodeNumber()];
            double distance = this.sortedDistances[i];
            this.calculateClusters(distance, clusters, already);
            double score = this.cc.calculateClusteringScore(clusters);
            if (!(score < bestScore)) continue;
            bestScore = score;
            this.bestDistance = distance;
        }
        boolean[] already = new boolean[this.cc.getNodeNumber()];
        double distance = this.bestDistance;
        this.noOfClusters = this.calculateClusters(distance, clusters, already);
        this.cc.initialiseClusterInfo(this.noOfClusters);
        this.cc.setClusteringScore(bestScore);
        this.cc.setClusters(clusters);
        this.cc.calculateClusterDistribution();
        System.out.println("time for single linkage " + (System.currentTimeMillis() - time));
    }

    private int calculateClusters(double distance, int[] clusters, boolean[] already) {
        int clusterNr = 0;
        for (int i = 0; i < clusters.length; ++i) {
            if (already[i]) continue;
            clusters[i] = clusterNr;
            already[i] = true;
            this.assignRecursivly(clusterNr, already, distance, i, clusters);
            ++clusterNr;
        }
        return clusterNr;
    }

    private void assignRecursivly(int clusterNr, boolean[] already, double distance, int seed, int[] clusters) {
        for (int i = 0; i < already.length; ++i) {
            if (already[i] || !((double)this.distances[i][seed] <= distance)) continue;
            clusters[i] = clusterNr;
            already[i] = true;
            this.assignRecursivly(clusterNr, already, distance, i, clusters);
        }
    }

    public void run2() {
        try {
            int i;
            long time = System.currentTimeMillis();
            double bestScore = Double.MAX_VALUE;
            this.bestDistance = 0.0;
            int[] clusters = new int[this.cc.getNodeNumber()];
            double currentDistance = this.minDistance;
            Vector[] putativeNeighbors = new Vector[clusters.length];
            Vector[] putativeNeighbors_orig = new Vector[clusters.length];
            for (i = 0; i < putativeNeighbors.length; ++i) {
                putativeNeighbors[i] = new Vector();
                putativeNeighbors_orig[i] = new Vector();
            }
            for (i = 0; i < clusters.length; ++i) {
                for (int j = i + 1; j < clusters.length; ++j) {
                    double distance = this.distances[i][j];
                    if (!(distance < this.maxDistance * this.maxDistance)) continue;
                    putativeNeighbors[i].add(j);
                    putativeNeighbors[j].add(i);
                    putativeNeighbors_orig[i].add(j);
                    putativeNeighbors_orig[j].add(i);
                }
            }
            Vector<Double> distances = new Vector<Double>();
            while (currentDistance < this.maxDistance) {
                distances.add(currentDistance);
                currentDistance += this.stepsize;
                this.stepsize += this.stepsizeFactor * this.stepsize;
            }
            distances.add((Double)Double.MAX_VALUE);
            for (int i2 = distances.size() - 1; i2 >= 0; --i2) {
                currentDistance = (Double)distances.get(i2);
                double currentScore = 0.0;
                this.calculateClusters(currentDistance * currentDistance, clusters, putativeNeighbors);
                currentScore = this.cc.calculateClusteringScore(clusters);
                if (!(currentScore <= bestScore)) continue;
                bestScore = currentScore;
                this.bestDistance = currentDistance;
            }
            this.noOfClusters = this.calculateClusters(this.bestDistance * this.bestDistance, clusters, putativeNeighbors_orig);
            this.cc.initialiseClusterInfo(this.noOfClusters);
            this.cc.setClusteringScore(bestScore);
            this.cc.setClusters(clusters);
            this.cc.calculateClusterDistribution();
            time = System.currentTimeMillis() - time;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private int calculateClusters(double distance, int[] clusters, Vector<Integer>[] putativeNeighbors) throws Exception {
        int clusterNumber = 0;
        boolean[] remaining2 = new boolean[clusters.length];
        for (int i = 0; i < remaining2.length; ++i) {
            if (remaining2[i]) continue;
            this.recursiveClusterCalculate(i, remaining2, clusterNumber, clusters, distance, putativeNeighbors);
            ++clusterNumber;
        }
        return clusterNumber;
    }

    private void recursiveClusterCalculate(int seed, boolean[] remaining2, int currentClusterNumber, int[] clusters, double distance, Vector<Integer>[] putativeNeighbors) {
        if (remaining2[seed]) {
            return;
        }
        clusters[seed] = currentClusterNumber;
        remaining2[seed] = true;
        Vector<Integer> v = putativeNeighbors[seed];
        for (int i = 0; i < v.size(); ++i) {
            int node = v.get(i);
            if (remaining2[node]) continue;
            if ((double)this.distances[seed][node] < distance) {
                this.recursiveClusterCalculate(node, remaining2, currentClusterNumber, clusters, distance, putativeNeighbors);
                continue;
            }
            v.remove(i);
            putativeNeighbors[i].removeElement(seed);
            --i;
        }
    }

    private float calculateEuclidianDistance(double[] node1, double[] node2) {
        float euclidianDistance = 0.0f;
        for (int i = 0; i < node1.length; ++i) {
            euclidianDistance = (float)((double)euclidianDistance + (node1[i] - node2[i]) * (node1[i] - node2[i]));
        }
        euclidianDistance = (float)Math.sqrt(euclidianDistance);
        return euclidianDistance;
    }

    public double getBestDistance() {
        return this.bestDistance;
    }

    public void setBestDistance(double bestDistance) {
        this.bestDistance = bestDistance;
    }
}

