/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDLayoutConfig;
import java.util.Random;

public class FORCEnDParameters
implements IParameters {
    private double attractionFactor = 0.0;
    private double repulsionFactor = 0.0;
    private int iterations = 0;
    private float temperature = 0.0f;
    private double score = 0.0;

    public void combineConfigurationsMean(IParameters[] configurations) {
        this.initialiseToZero();
        for (int i = 0; i < configurations.length; ++i) {
            this.attractionFactor += ((FORCEnDParameters)configurations[i]).getAttractionFactor();
            this.iterations += ((FORCEnDParameters)configurations[i]).getIterations();
            this.repulsionFactor += ((FORCEnDParameters)configurations[i]).getRepulsionFactor();
            this.temperature += ((FORCEnDParameters)configurations[i]).getTemperature();
        }
        this.attractionFactor /= (double)configurations.length;
        this.iterations /= configurations.length;
        this.repulsionFactor /= (double)configurations.length;
        this.temperature /= (float)configurations.length;
    }

    public void combineConfigurationsRandomly(IParameters[] configurations) {
        this.initialiseToZero();
        Random generator = new Random();
        int pos = generator.nextInt(configurations.length);
        this.attractionFactor = ((FORCEnDParameters)configurations[pos]).getAttractionFactor();
        pos = generator.nextInt(configurations.length);
        pos = generator.nextInt(configurations.length);
        this.iterations = ((FORCEnDParameters)configurations[pos]).getIterations();
        pos = generator.nextInt(configurations.length);
        this.repulsionFactor = ((FORCEnDParameters)configurations[pos]).getRepulsionFactor();
        pos = generator.nextInt(configurations.length);
        this.temperature = ((FORCEnDParameters)configurations[pos]).getTemperature();
    }

    public void combineParametersRandomlyAndGetNewRandom(IParameters[] configurations) {
        int pos;
        Random generator = new Random();
        int randomOrOld = generator.nextInt(2);
        if (randomOrOld == 0) {
            pos = generator.nextInt(configurations.length);
            this.attractionFactor = ((FORCEnDParameters)configurations[pos]).getAttractionFactor();
        } else {
            this.attractionFactor = generator.nextInt(100);
        }
        randomOrOld = generator.nextInt(2);
        if (randomOrOld == 0) {
            pos = generator.nextInt(configurations.length);
            this.iterations = ((FORCEnDParameters)configurations[pos]).getIterations();
        } else {
            this.iterations = 10 + generator.nextInt(90);
        }
        randomOrOld = generator.nextInt(2);
        if (randomOrOld == 0) {
            pos = generator.nextInt(configurations.length);
            this.repulsionFactor = ((FORCEnDParameters)configurations[pos]).getRepulsionFactor();
        } else {
            this.repulsionFactor = generator.nextInt(100);
        }
        randomOrOld = generator.nextInt(2);
        if (randomOrOld == 0) {
            pos = generator.nextInt(configurations.length);
            this.temperature = ((FORCEnDParameters)configurations[pos]).getTemperature();
        } else {
            this.temperature = 50 + generator.nextInt(100);
        }
    }

    public void createRandomConfiguration() {
        Random generator = new Random();
        this.attractionFactor = 10.0 * generator.nextDouble();
        this.repulsionFactor = 10.0 * generator.nextDouble();
        this.iterations = 10 + generator.nextInt(90);
        this.temperature = 50 + generator.nextInt(2500);
    }

    public void initialiseToZero() {
        this.attractionFactor = 0.0;
        this.repulsionFactor = 0.0;
        this.iterations = 0;
        this.temperature = 0.0f;
    }

    public void readParametersFromConfig() {
        this.attractionFactor = FORCEnDLayoutConfig.attractionFactor;
        this.repulsionFactor = FORCEnDLayoutConfig.repulsionFactor;
        this.iterations = FORCEnDLayoutConfig.iterations;
        this.temperature = FORCEnDLayoutConfig.temperature;
    }

    public void saveParametersToConfig() {
        FORCEnDLayoutConfig.attractionFactor = this.attractionFactor;
        FORCEnDLayoutConfig.repulsionFactor = this.repulsionFactor;
        FORCEnDLayoutConfig.iterations = this.iterations;
        FORCEnDLayoutConfig.temperature = this.temperature;
    }

    public void printParamters() {
        System.out.println("attraction = " + this.attractionFactor);
        System.out.println("repulsion = " + this.repulsionFactor);
        System.out.println("temperature = " + this.temperature);
        System.out.println("iterations = " + this.iterations);
        System.out.println("score = " + this.score);
        System.out.println();
    }

    public double getAttractionFactor() {
        return this.attractionFactor;
    }

    public void setAttractionFactor(double attractionFactor) {
        this.attractionFactor = attractionFactor;
    }

    public double getRepulsionFactor() {
        return this.repulsionFactor;
    }

    public void setRepulsionFactor(double repulsionFactor) {
        this.repulsionFactor = repulsionFactor;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String toString() {
        StringBuffer paramString = new StringBuffer();
        paramString.append("FORCEnD paramter Configuration:");
        paramString.append("\n score - ");
        paramString.append(this.score);
        paramString.append("\n iterations - ");
        paramString.append(this.iterations);
        paramString.append("\n attractionFactor - ");
        paramString.append(this.attractionFactor);
        paramString.append("\n repulsionFactor - ");
        paramString.append(this.repulsionFactor);
        paramString.append("\n temperature - ");
        paramString.append(this.temperature);
        return paramString.toString();
    }
}

