/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayoutInitialiser;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;

public class LayoutInitHSphere
implements ILayoutInitialiser {
    private int dim = 0;
    private int node_no = 0;
    private double[][] node_pos;
    private ConnectedComponent cc;

    public LayoutInitHSphere() {
    }

    public LayoutInitHSphere(ConnectedComponent cc) {
        this.initLayoutInitialiser(cc);
    }

    public void initLayoutInitialiser(ConnectedComponent cc) {
        this.node_no = cc.getNodeNumber();
        this.cc = cc;
        this.dim = TaskConfig.dimension;
        this.node_pos = new double[this.node_no][this.dim];
    }

    public void run() {
        for (int n = 0; n < this.node_no; ++n) {
            double r = 0.0;
            for (int d = 0; d < this.dim; ++d) {
                this.node_pos[n][d] = LayoutInitHSphere.uniform(-5.0, 5.0);
                r += this.node_pos[n][d] * this.node_pos[n][d];
            }
            r = Math.sqrt(r);
            for (int d2 = 0; d2 < this.dim; ++d2) {
                this.node_pos[n][d2] = this.node_pos[n][d2] / r;
            }
        }
        this.cc.setCCPositions(this.node_pos);
    }

    public static double uniform(double a, double b) {
        return a + Math.random() * (b - a);
    }
}

