/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.ClusterObjectComparator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.IPostProcessing;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PP_RearrangeAndMergeBest;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingUtility;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusterPostProcessingTask;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PP_DivideAndRecluster
implements IPostProcessing {
    private ConnectedComponent cc = null;
    private double bestScore = 0.0;
    private IParameters[] params = null;
    private LayoutFactory.EnumLayouterClass[] layouterEnumTypes = null;

    @Override
    public void initPostProcessing(ConnectedComponent cc) {
        this.cc = cc;
        this.bestScore = cc.getClusteringScore();
    }

    public void setLayoutingInfo(IParameters[] params, LayoutFactory.EnumLayouterClass[] layouterEnumTypes) {
        this.params = params;
        this.layouterEnumTypes = layouterEnumTypes;
    }

    @Override
    public void run() {
        int i;
        ArrayList<ArrayList<Integer>> clusterObject = PostProcessingUtility.createClusterObject(this.cc, false);
        HashSet<String> alreadyCompared = new HashSet<String>();
        ClusterObjectComparator comparator = new ClusterObjectComparator();
        PostProcessingUtility.mergeCluster(clusterObject, alreadyCompared, this.cc, comparator, true);
        this.bestScore = PostProcessingUtility.updateClusterInfoInCC(clusterObject, this.cc);
        ArrayList<ConnectedComponent> cCsOfSubgraphs = new ArrayList<ConnectedComponent>();
        for (i = 0; i < clusterObject.size(); ++i) {
            ArrayList<Integer> cluster2 = clusterObject.get(i);
            int clusterSize = cluster2.size();
            if (clusterSize <= 3) continue;
            clusterObject.remove(i);
            ConnectedComponent ccForCluster = this.cc.createConnectedComponentForCluster(--i, cluster2);
            cCsOfSubgraphs.add(ccForCluster);
            ClusterPostProcessingTask clusterTask = new ClusterPostProcessingTask(ccForCluster, this.params, this.layouterEnumTypes);
            clusterTask.run();
        }
        for (i = 0; i < cCsOfSubgraphs.size(); ++i) {
            ConnectedComponent subCC = (ConnectedComponent)cCsOfSubgraphs.get(i);
            this.addClustersToTotalClusters(subCC, clusterObject);
        }
        this.bestScore = PostProcessingUtility.updateClusterInfoInCC(clusterObject, this.cc);
        PP_RearrangeAndMergeBest postProcess1 = new PP_RearrangeAndMergeBest();
        postProcess1.initPostProcessing(this.cc);
        postProcess1.run();
    }

    private void addClustersToTotalClusters(ConnectedComponent subCC, ArrayList<ArrayList<Integer>> clusterObject) {
        int i;
        int noOfClusters = subCC.getNumberOfClusters();
        int[] subClusters = subCC.getClusters();
        ArrayList newClusters = new ArrayList(noOfClusters);
        int[] clusterDistribution = subCC.getClusterInfo();
        for (i = 0; i < clusterDistribution.length; ++i) {
            newClusters.add(new ArrayList(clusterDistribution[i]));
        }
        for (i = 0; i < subClusters.length; ++i) {
            int originalNo = Integer.parseInt(subCC.getObjectID(i));
            ((ArrayList)newClusters.get(subClusters[i])).add(originalNo);
        }
        for (i = 0; i < noOfClusters; ++i) {
            clusterObject.add((ArrayList<Integer>)newClusters.get(i));
        }
    }

    protected double getBestScore() {
        return this.bestScore;
    }
}

