/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.ClusterObjectComparator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.IPostProcessing;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PP_RearrangeAndMergeBest;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingUtility;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusterPostProcessingTask;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PP_DivideAndReclusterRecursively
implements IPostProcessing {
    private ConnectedComponent cc = null;
    private IParameters[] params = null;
    private LayoutFactory.EnumLayouterClass[] layouterEnumTypes = null;

    @Override
    public void initPostProcessing(ConnectedComponent cc) {
        this.cc = cc;
    }

    public void setLayoutingInfo(IParameters[] params, LayoutFactory.EnumLayouterClass[] layouterEnumTypes) {
        this.params = params;
        this.layouterEnumTypes = layouterEnumTypes;
    }

    @Override
    public void run() {
        IPostProcessing pp = PostProcessingFactory.EnumPostProcessingClass.PP_REARRANGE_AND_MERGE_BEST.createPostProcessor();
        pp.initPostProcessing(this.cc);
        pp.run();
        ArrayList<ArrayList<Integer>> clusterObject = PostProcessingUtility.createClusterObject(this.cc, false);
        HashSet<String> alreadyCompared = new HashSet<String>();
        ClusterObjectComparator comparator = new ClusterObjectComparator();
        PostProcessingUtility.mergeCluster(clusterObject, alreadyCompared, this.cc, comparator, true);
        PostProcessingUtility.updateClusterInfoInCC(clusterObject, this.cc);
        ArrayList<ArrayList<Integer>> finalClusterObject = new ArrayList<ArrayList<Integer>>();
        this.recursiveReclustering(finalClusterObject, clusterObject);
        PostProcessingUtility.updateClusterInfoInCC(finalClusterObject, this.cc);
        PP_RearrangeAndMergeBest postProcess1 = new PP_RearrangeAndMergeBest();
        postProcess1.initPostProcessing(this.cc);
        postProcess1.run();
    }

    private void recursiveReclustering(ArrayList<ArrayList<Integer>> finalClusterObject, ArrayList<ArrayList<Integer>> tmpClusterObject) {
        for (int i = 0; i < tmpClusterObject.size(); ++i) {
            ArrayList<Integer> cluster2 = tmpClusterObject.get(i);
            int clusterSize = cluster2.size();
            if (clusterSize <= 3) {
                finalClusterObject.add(cluster2);
                continue;
            }
            ConnectedComponent ccForCluster = this.cc.createConnectedComponentForCluster(i, cluster2);
            ClusterPostProcessingTask clusterTask = new ClusterPostProcessingTask(ccForCluster, this.params, this.layouterEnumTypes);
            clusterTask.run();
            if (ccForCluster.getNumberOfClusters() == 1) {
                finalClusterObject.add(cluster2);
                continue;
            }
            ArrayList<ArrayList<Integer>> nextClusterObject = PostProcessingUtility.createClusterObject(ccForCluster, true);
            this.recursiveReclustering(finalClusterObject, nextClusterObject);
        }
    }
}

