/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.iterativeclustering.IteratorThread;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusteringManager;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.GeneralParameterTraining;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidInputFileException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskUtility;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.InfoFile;
import java.util.Date;
import java.util.concurrent.Semaphore;
import org.cytoscape.work.TaskMonitor;

public class ClusteringManagerTask
implements Runnable {
    private Semaphore semaphore;
    private ClusteringManager clusterManager;

    public void run() {
        try {
            TaskConfig.monitor.setStatusMessage("-----------------------------------");
            TaskConfig.monitor.setStatusMessage("Running ... TransClust v1.0");
            Date date = new Date(System.currentTimeMillis());
            TaskConfig.monitor.setStatusMessage(date.toString());
            TaskConfig.monitor.setStatusMessage("-----------------------------------");
            if (TaskConfig.mode == 0) {
                long time = System.currentTimeMillis();
                this.clusterManager = new ClusteringManager(TaskConfig.cmPath);
                try {
                    this.clusterManager.initParametersAndCCs();
                    this.clusterManager.runClustering();
                    time = System.currentTimeMillis() - time;
                    TaskConfig.monitor.setStatusMessage("Time taken for complete clustering process: " + TaskUtility.convertTime(time));
                }
                catch (InvalidInputFileException e) {
                    TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                    System.exit(-1);
                }
                catch (InvalidTypeException e) {
                    TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                    System.exit(-1);
                }
            } else if (TaskConfig.mode == 1) {
                try {
                    long time = System.currentTimeMillis();
                    ClusteringManager clustermanage = new ClusteringManager(TaskConfig.cmPath);
                    GeneralParameterTraining generalParameterTraining = new GeneralParameterTraining(clustermanage);
                    IParameters[] layoutParams = generalParameterTraining.runGeneralTraining();
                    TaskConfig.saveConfigurationsToConfigFile(TaskConfig.outConfigPath);
                    TaskConfig.monitor.setStatusMessage(TaskConfig.NL + "###### Best Parameter Configurations Found ######");
                    for (int i = 0; i < layoutParams.length; ++i) {
                        TaskConfig.monitor.setStatusMessage(layoutParams[i].toString());
                        InfoFile.appendLnProjectResults(layoutParams[i].toString());
                    }
                    time = System.currentTimeMillis() - time;
                    TaskConfig.monitor.setStatusMessage("Time taken for complete general training: " + TaskUtility.convertTime(time));
                }
                catch (InvalidInputFileException e) {
                    TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                }
                catch (InvalidTypeException e) {
                    TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                }
            } else if (TaskConfig.mode == 2 || TaskConfig.mode == 3) {
                IteratorThread t = new IteratorThread();
                t.start();
            } else {
                TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, "ERROR: This mode does not exist: " + TaskConfig.mode);
            }
            if (TaskConfig.info) {
                InfoFile info = new InfoFile();
                info.instantiateFile(TaskConfig.infoPath);
                info.createAndCloseInfoFile();
                InfoFile.clearData();
            }
        }
        catch (Exception e) {
            TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, "ERROR occured in run with the following message: " + e.getMessage());
        }
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    public void stopAllThreads() {
        if (this.clusterManager != null) {
            this.clusterManager.stopAllRunningThreads();
        }
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
        if (semaphore != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

