/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.Summary;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class Numeric {
    private static final Random rand = new Random();

    public static Double mean(Double[] a) {
        Double t = new Double(0.0);
        int n = 0;
        for (Double v : a) {
            if (v == null) continue;
            t = t + v;
            ++n;
        }
        return t / new Double(n);
    }

    public static double mean(double[] a) {
        double t = 0.0;
        int n = 0;
        for (double v : a) {
            t += v;
            ++n;
        }
        return t / (double)n;
    }

    public static Double median(Double[] a) {
        int n = a.length;
        if (n % 2 == 0) {
            Double x = Numeric.select(a, n / 2 - 1);
            Double y = Numeric.select(a, n / 2);
            return (x + y) / 2.0;
        }
        return Numeric.select(a, n / 2);
    }

    public static double median(double[] a) {
        int n = a.length;
        if (n % 2 == 0) {
            double x = Numeric.select(a, n / 2 - 1);
            double y = Numeric.select(a, n / 2);
            return (x + y) / 2.0;
        }
        return Numeric.select(a, n / 2);
    }

    public static Double select(Double[] a, int i) {
        return Numeric.select(a, i, 0, a.length);
    }

    public static double select(double[] a, int i) {
        return Numeric.select(a, i, 0, a.length);
    }

    private static Double select(Double[] a, int i, int b, int e) {
        int n = e - b;
        if (n == 1) {
            return a[b];
        }
        int j = Numeric.partition(a, rand.nextInt(n), b, e);
        if (j == i) {
            return a[b + j];
        }
        if (j > i) {
            return Numeric.select(a, i, b, b + j);
        }
        return Numeric.select(a, i - ++j, b + j, e);
    }

    private static double select(double[] a, int i, int b, int e) {
        int n = e - b;
        if (n == 1) {
            return a[b];
        }
        int j = Numeric.partition(a, rand.nextInt(n), b, e);
        if (j == i) {
            return a[b + j];
        }
        if (j > i) {
            return Numeric.select(a, i, b, b + j);
        }
        return Numeric.select(a, i - ++j, b + j, e);
    }

    private static int partition(Double[] a, int k, int b, int e) {
        Double t = a[b];
        a[b] = a[k += b];
        a[k] = t;
        Double p = a[b];
        int i = b + 1;
        for (int j = b + 1; j < e; ++j) {
            if (!(a[j] < p)) continue;
            t = a[i];
            a[i] = a[j];
            a[j] = t;
            ++i;
        }
        k = i - 1;
        t = a[b];
        a[b] = a[k];
        a[k] = t;
        return k - b;
    }

    private static int partition(double[] a, int k, int b, int e) {
        double t = a[b];
        a[b] = a[k += b];
        a[k] = t;
        double p = a[b];
        int i = b + 1;
        for (int j = b + 1; j < e; ++j) {
            if (!(a[j] < p)) continue;
            t = a[i];
            a[i] = a[j];
            a[j] = t;
            ++i;
        }
        k = i - 1;
        t = a[b];
        a[b] = a[k];
        a[k] = t;
        return k - b;
    }

    public static double correlation(double[] x, double[] y) {
        int n = x.length;
        if (n != y.length) {
            throw new IllegalArgumentException("x and y must have the same length");
        }
        Summary xs = new Summary();
        Summary ys = new Summary();
        double dotp = 0.0;
        for (int i = 0; i < n; ++i) {
            xs.add(x[i]);
            ys.add(y[i]);
            dotp += x[i] * y[i];
        }
        double nd = n;
        return (dotp - nd * xs.mean() * ys.mean()) / (nd * xs.sd() * ys.sd());
    }

    public static int[] range(int start, int end, int step) {
        int n = (end - start) / step;
        int[] a = new int[n];
        int i = 0;
        for (int x = start; x < end; x += step) {
            a[i++] = x;
        }
        return a;
    }

    public static int[] order(double[] x, boolean descending) {
        int n = x.length;
        KeyValuePair[] pairs = new KeyValuePair[n];
        for (int i = 0; i < n; ++i) {
            pairs[i] = new KeyValuePair(x[i], i);
        }
        if (descending) {
            Arrays.sort(pairs, new KeyValuePairDescendingComparator());
        } else {
            Arrays.sort(pairs, new KeyValuePairAscendingComparator());
        }
        int[] ord = new int[n];
        for (int i = 0; i < n; ++i) {
            ord[i] = pairs[i].value;
        }
        return ord;
    }

    public static int[] order(double[] x) {
        return Numeric.order(x, false);
    }

    public static void printArray(Double[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i].toString() + " ");
        }
        System.out.println();
    }

    public static void printArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print(String.valueOf(a[i]) + " ");
        }
        System.out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyValuePairDescendingComparator
    implements Comparator<KeyValuePair> {
        private KeyValuePairDescendingComparator() {
        }

        @Override
        public int compare(KeyValuePair a, KeyValuePair b) {
            return a.key < b.key ? 1 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyValuePairAscendingComparator
    implements Comparator<KeyValuePair> {
        private KeyValuePairAscendingComparator() {
        }

        @Override
        public int compare(KeyValuePair a, KeyValuePair b) {
            return a.key < b.key ? -1 : 1;
        }
    }

    private static class KeyValuePair {
        public double key;
        public int value;

        public KeyValuePair(double key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

