/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DragBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class DragGridPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ComponentListener,
FocusListener,
ContainerListener {
    boolean resize = false;
    boolean adjustable = true;
    int bwidth = 6;
    int bheight = 6;
    int minwidth = 20;
    int minheight = 20;
    int focuswidth = 0;
    int focusheight = 0;
    Component[][] components;
    int[] xpos;
    int[] ypos;
    float[] xsizes;
    float[] ysizes;
    int coldrag;
    int rowdrag;
    int curscol;
    int cursrow;
    Cursor originalCursor;
    int currentCursor = -1;
    static final int leftRightCursor = 1;
    static final int upDownCursor = 2;
    static final int crossHairCursor = 3;
    static final int handCursor = 4;
    static final boolean trace = false;
    DragBar dragBar = new DragBar();

    public DragGridPanel(int x, int y) {
        super(null);
        int i;
        this.setBackground(Color.white);
        this.components = new Component[x][y];
        this.xpos = new int[x + 1];
        this.ypos = new int[y + 1];
        this.xsizes = new float[x];
        this.ysizes = new float[y];
        for (i = 0; i < x; ++i) {
            this.xsizes[i] = 1.0f / (float)x;
        }
        for (i = 0; i < y; ++i) {
            this.ysizes[i] = 1.0f / (float)y;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
    }

    public boolean isAdjustable() {
        return this.adjustable;
    }

    public void setAdjustable(boolean on) {
        this.adjustable = on;
    }

    public int getBorderWidth() {
        return this.bwidth;
    }

    public void setBorderWidth(int width) {
        this.bwidth = width;
    }

    public int getBorderHeight() {
        return this.bheight;
    }

    public void setBorderHeight(int height) {
        this.bheight = height;
    }

    public int getMinimumWidth() {
        return this.minwidth;
    }

    public void setMinimumWidth(int width) {
        this.minwidth = width;
    }

    public int getMinimumHeight() {
        return this.minheight;
    }

    public void setMinimumHeight(int height) {
        this.minheight = height;
    }

    public int getFocusWidth() {
        return this.focuswidth;
    }

    public void setFocusWidth(int width) {
        this.focuswidth = width;
    }

    public int getFocusHeight() {
        return this.focusheight;
    }

    public void setFocusHeight(int height) {
        this.focusheight = height;
    }

    public void setWidths(float[] widths) {
        int i;
        float max = 0.0f;
        System.arraycopy(widths, 0, this.xsizes, 0, this.xsizes.length);
        for (i = 0; i < this.xsizes.length; ++i) {
            max += this.xsizes[i];
        }
        if (max == 0.0f) {
            for (i = 0; i < this.xsizes.length; ++i) {
                this.xsizes[i] = 1.0f / (float)this.xsizes.length;
            }
        } else if (max != 1.0f) {
            i = 0;
            while (i < this.xsizes.length) {
                int n = i++;
                this.xsizes[n] = this.xsizes[n] / max;
            }
        }
        this.doLayout();
        this.repaint();
    }

    public float[] getWidths() {
        float[] rwidths = new float[this.xsizes.length];
        System.arraycopy(this.xsizes, 0, rwidths, 0, this.xsizes.length);
        return rwidths;
    }

    public void setHeights(float[] heights) {
        int i;
        float max = 0.0f;
        System.arraycopy(heights, 0, this.ysizes, 0, this.ysizes.length);
        for (i = 0; i < this.ysizes.length; ++i) {
            max += this.ysizes[i];
        }
        if (max == 0.0f) {
            for (i = 0; i < this.ysizes.length; ++i) {
                this.ysizes[i] = 1.0f / (float)this.ysizes.length;
            }
        } else if (max != 1.0f) {
            i = 0;
            while (i < this.ysizes.length) {
                int n = i++;
                this.ysizes[n] = this.ysizes[n] / max;
            }
        }
        this.doLayout();
        this.repaint();
    }

    public float[] getHeights() {
        float[] rheights = new float[this.ysizes.length];
        System.arraycopy(this.ysizes, 0, rheights, 0, this.ysizes.length);
        return rheights;
    }

    public void addComponent(Component component, Rectangle rectangle) {
        if (component != null) {
            this.addComponent(component, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void addComponent(Component comp, int x, int y, int width, int height) {
        int j;
        int i;
        for (i = x; i < x + width; ++i) {
            for (j = y; j < y + height; ++j) {
                if (this.components[i][j] == null) continue;
                throw new IllegalArgumentException("Cells already occupied");
            }
        }
        for (i = x; i < x + width; ++i) {
            for (j = y; j < y + height; ++j) {
                this.components[i][j] = comp;
            }
        }
        this.add(comp);
        this.addFocusListenerRecursively(comp);
        this.repaint();
    }

    public void removeComponent(Component comp) {
        for (int y = 0; y < this.ysizes.length; ++y) {
            for (int x = 0; x < this.ysizes.length; ++x) {
                if (this.components[x][y] != comp) continue;
                this.components[x][y] = null;
            }
        }
        this.removeFocusListenerRecursively(comp);
        this.remove(comp);
        this.repaint();
    }

    public Dimension getPreferredSize() {
        int maxw = 0;
        for (int y = 0; y < this.ysizes.length; ++y) {
            int roww = this.components[0][y].getPreferredSize().width;
            for (int x = 1; x < this.xsizes.length; ++x) {
                if (this.components[x][y] == this.components[x - 1][y] || this.components[x][y] == null) continue;
                roww += this.components[x][y].getPreferredSize().width;
            }
            if (roww <= maxw) continue;
            maxw = roww;
        }
        int maxh = 0;
        for (int x = 0; x < this.xsizes.length; ++x) {
            int colh = this.components[x][0].getPreferredSize().height;
            for (int y = 1; y < this.ysizes.length; ++y) {
                if (this.components[x][y] == this.components[x][y - 1] || this.components[x][y] == null) continue;
                colh += this.components[x][y].getPreferredSize().height;
            }
            if (colh <= maxh) continue;
            maxh = colh;
        }
        return new Dimension(maxw, maxh);
    }

    private void addFocusListenerRecursively(Component c) {
        c.addFocusListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addFocusListenerRecursively(children[i]);
            }
        }
    }

    private void removeFocusListenerRecursively(Component c) {
        c.removeFocusListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeFocusListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addFocusListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeFocusListenerRecursively(e.getChild());
    }

    public void doLayout() {
        Dimension s = this.getSize();
        this.xpos[0] = 0;
        for (int x = 0; x < this.xsizes.length; ++x) {
            this.xpos[x + 1] = this.xpos[x] + (int)((float)s.width * this.xsizes[x]);
        }
        this.xpos[this.xsizes.length] = s.width;
        this.ypos[0] = 0;
        for (int y = 0; y < this.ysizes.length; ++y) {
            this.ypos[y + 1] = this.ypos[y] + (int)((float)s.height * this.ysizes[y]);
        }
        this.ypos[this.ysizes.length] = s.height;
        this.resizeComponents();
    }

    public void paintComponent(Graphics g) {
        Component c;
        int x;
        int y;
        Dimension newsize = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, newsize.width, newsize.height);
        g.setColor(Color.black);
        for (y = 1; y < this.ysizes.length; ++y) {
            for (x = 0; x < this.xsizes.length; ++x) {
                c = this.components[x][y];
                if (this.components[x][y - 1] == c) continue;
                g.fillRect(this.xpos[x], this.ypos[y] - this.bheight, this.xpos[x + 1] - this.xpos[x], this.bheight);
            }
        }
        for (x = 1; x < this.xsizes.length; ++x) {
            for (y = 0; y < this.ysizes.length; ++y) {
                c = this.components[x][y];
                if (this.components[x - 1][y] == c) continue;
                g.fillRect(this.xpos[x] - this.bwidth, this.ypos[y], this.bwidth, this.ypos[y + 1] - this.ypos[y]);
            }
        }
    }

    public void focusGained(FocusEvent e) {
        for (int x = 0; x < this.xsizes.length; ++x) {
            for (int y = 0; y < this.ysizes.length; ++y) {
                Container cont;
                Component c = this.components[x][y];
                if (c == e.getComponent()) {
                    this.drawFocus(this.getGraphics(), x, y);
                    return;
                }
                if (!(c instanceof Container) || !(cont = (Container)c).isAncestorOf(e.getComponent())) continue;
                this.drawFocus(this.getGraphics(), x, y);
                return;
            }
        }
    }

    public void focusLost(FocusEvent e) {
        for (int x = 0; x < this.xsizes.length; ++x) {
            for (int y = 0; y < this.ysizes.length; ++y) {
                Container cont;
                Component c = this.components[x][y];
                if (c == e.getComponent()) {
                    this.drawFocus(this.getGraphics(), x, y);
                    return;
                }
                if (!(c instanceof Container) || !(cont = (Container)c).isAncestorOf(e.getComponent())) continue;
                Graphics g = this.getGraphics();
                if (g != null) {
                    Color o = g.getColor();
                    g.setColor(cont.getBackground());
                    this.drawFocus(g, x, y);
                    g.setColor(o);
                }
                return;
            }
        }
    }

    private void drawFocus(Graphics g, int x, int y) {
        if (g == null) {
            return;
        }
        Component c = this.components[x][y];
        if (c == null) {
            return;
        }
        if (x > 0 && this.components[x - 1][y] == c) {
            return;
        }
        if (y > 0 && this.components[x][y - 1] == c) {
            return;
        }
        Dimension size = c.getSize();
        int w = size.width;
        int h = size.height;
        g.fillRect(this.xpos[x], this.ypos[y], this.focuswidth, h + 2 * this.focusheight);
        g.fillRect(this.xpos[x] + w + this.focuswidth, this.ypos[y], this.focuswidth, h + 2 * this.focusheight);
        g.fillRect(this.xpos[x] + this.focuswidth, this.ypos[y], w, this.focusheight);
        g.fillRect(this.xpos[x] + this.focuswidth, this.ypos[y] + h + this.focuswidth, w, this.focusheight);
    }

    public String toString() {
        Point p = this.getLocation();
        return "DragGridPanel(" + p.x + "," + p.y + ")[" + this.xsizes.length + "][" + this.ysizes.length + "] " + super.toString();
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.dragging()) {
            this.onDragBorder(e.getX(), e.getY());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.adjustable && this.onDragBorder(e.getX(), e.getY())) {
            this.coldrag = this.curscol;
            this.rowdrag = this.cursrow;
            this.setCursor(4);
            this.dragBar = new DragBar();
            this.dragBar.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.dragBar.setMouse(e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragging()) {
            this.rowdrag = 0;
            this.coldrag = 0;
            this.onDragBorder(e.getX(), e.getY());
            this.remove(this.dragBar);
        }
        if (this.resize) {
            this.resizeComponents();
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.currentCursor != 0 && !this.dragging()) {
            this.setCursor(0);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragging()) {
            int x = e.getX();
            int y = e.getY();
            this.resize = false;
            if (this.coldrag > 0) {
                this.resize = true;
                if (x < this.xpos[this.coldrag - 1] + this.minwidth) {
                    x = this.xpos[this.coldrag - 1] + this.minwidth;
                } else if (x > this.xpos[this.coldrag + 1] - this.minwidth) {
                    x = this.xpos[this.coldrag + 1] - this.minwidth;
                }
                if (this.xpos[this.coldrag] != x) {
                    this.xpos[this.coldrag] = x;
                    this.xsizes[this.coldrag - 1] = (float)(this.xpos[this.coldrag] - this.xpos[this.coldrag - 1]) / (float)this.getSize().width;
                    this.xsizes[this.coldrag] = (float)(this.xpos[this.coldrag + 1] - this.xpos[this.coldrag]) / (float)this.getSize().width;
                }
            }
            if (this.rowdrag > 0) {
                this.resize = true;
                if (y < this.ypos[this.rowdrag - 1] + this.minheight) {
                    y = this.ypos[this.rowdrag - 1] + this.minheight;
                } else if (y > this.ypos[this.rowdrag + 1] - this.minheight) {
                    y = this.ypos[this.rowdrag + 1] - this.minheight;
                }
                if (this.ypos[this.rowdrag] != y) {
                    this.ypos[this.rowdrag] = y;
                    this.ysizes[this.rowdrag - 1] = (float)(this.ypos[this.rowdrag] - this.ypos[this.rowdrag - 1]) / (float)this.getSize().height;
                    this.ysizes[this.rowdrag] = (float)(this.ypos[this.rowdrag + 1] - this.ypos[this.rowdrag]) / (float)this.getSize().height;
                }
            }
        }
        this.dragBar.setMouse(e.getX(), e.getY());
        this.repaint();
    }

    public void componentResized(ComponentEvent e) {
        this.doLayout();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    void resizeComponents() {
        for (int y = 0; y < this.ysizes.length; ++y) {
            for (int x = 0; x < this.xsizes.length; ++x) {
                int my;
                int mx;
                Component c = this.components[x][y];
                if (c == null || x > 0 && this.components[x - 1][y] == c || y > 0 && this.components[x][y - 1] == c) continue;
                for (mx = x + 1; mx < this.xsizes.length && this.components[mx][y] == c; ++mx) {
                }
                for (my = y + 1; my < this.ysizes.length && this.components[x][my] == c; ++my) {
                }
                int w = this.xpos[mx] - this.xpos[x] - 2 * this.focuswidth;
                int h = this.ypos[my] - this.ypos[y] - 2 * this.focusheight;
                if (mx < this.xsizes.length) {
                    w -= this.bwidth;
                }
                if (my < this.ysizes.length) {
                    h -= this.bheight;
                }
                c.setBounds(this.xpos[x] + this.focuswidth, this.ypos[y] + this.focusheight, w, h);
                c.validate();
            }
        }
    }

    private boolean onDragBorder(int x, int y) {
        int row;
        int col;
        this.cursrow = 0;
        this.curscol = 0;
        for (col = 1; col < this.xsizes.length; ++col) {
            if (x > this.xpos[col]) continue;
            if (x < this.xpos[col] - this.bwidth) break;
            this.curscol = col;
            break;
        }
        for (row = 1; row < this.ysizes.length; ++row) {
            if (y > this.ypos[row]) continue;
            if (y < this.ypos[row] - this.bheight) break;
            this.cursrow = row;
            break;
        }
        int newcursor = 0;
        if (this.curscol > 0 || this.cursrow > 0) {
            if (this.curscol > 0) {
                if (this.components[this.curscol][row - 1] != this.components[col - 1][row - 1] || row < this.ysizes.length && this.components[this.curscol][row] != this.components[col - 1][row]) {
                    newcursor = 1;
                } else {
                    this.curscol = 0;
                }
            }
            if (this.cursrow > 0) {
                if (this.components[col - 1][this.cursrow] != this.components[col - 1][row - 1] || col < this.xsizes.length && this.components[col][this.cursrow] != this.components[col][row - 1]) {
                    newcursor |= 2;
                } else {
                    this.cursrow = 0;
                }
            }
        }
        if (newcursor != this.currentCursor) {
            this.setCursor(newcursor);
        }
        return newcursor != 0;
    }

    private void setCursor(int newcursor) {
        if (newcursor > 0) {
            if (this.originalCursor == null) {
                this.originalCursor = this.getCursor();
            }
            switch (newcursor) {
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                    break;
                }
                case 4: {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        } else {
            this.setCursor(this.originalCursor);
            this.originalCursor = null;
        }
        this.currentCursor = newcursor;
    }

    private boolean dragging() {
        return this.adjustable && (this.coldrag > 0 || this.rowdrag > 0);
    }
}

