/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import java.util.Observable;

public class HeaderSummary
extends Observable
implements ConfigNodePersistent {
    int[] included = new int[]{1};
    private ConfigNode root;

    public void setIncluded(int[] newIncluded) {
        this.included = newIncluded;
        this.synchronizeTo();
        this.setChanged();
        this.notifyObservers();
    }

    public int[] getIncluded() {
        return this.included;
    }

    public String getSummary(HeaderInfo headerInfo, int index) {
        String[] strings = null;
        try {
            strings = headerInfo.getHeader(index);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            return null;
        }
        if (strings == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        int count = 0;
        if (this.included.length == 0) {
            return "";
        }
        for (int i = 0; i < this.included.length; ++i) {
            try {
                String test = strings[this.included[i]];
                if (test == null) continue;
                if (count != 0) {
                    out.append(", ");
                }
                out.append(test);
                ++count;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                // empty catch block
            }
        }
        if (count == 0) {
            return "";
        }
        return out.toString();
    }

    public String[] getSummaryArray(HeaderInfo headerInfo, int index) {
        String[] strings = null;
        try {
            strings = headerInfo.getHeader(index);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            return null;
        }
        if (strings == null) {
            return null;
        }
        if (this.included.length == 0) {
            return null;
        }
        String[] out = new String[this.included.length];
        int count = 0;
        for (int i = 0; i < this.included.length; ++i) {
            try {
                String test;
                out[count] = test = strings[this.included[i]];
                ++count;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                // empty catch block
            }
        }
        return out;
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.synchronizeFrom();
    }

    private void synchronizeFrom() {
        if (this.root == null) {
            return;
        }
        if (this.root.hasAttribute("included")) {
            String incString = this.root.getAttribute("included", "1");
            if (incString.equals("")) {
                this.setIncluded(new int[0]);
            } else {
                int numComma = 0;
                for (int i = 0; i < incString.length(); ++i) {
                    if (incString.charAt(i) != ',') continue;
                    ++numComma;
                }
                int[] array = new int[numComma + 1];
                numComma = 0;
                int last = 0;
                for (int i = 0; i < incString.length(); ++i) {
                    if (incString.charAt(i) != ',') continue;
                    Integer x = new Integer(incString.substring(last, i));
                    array[numComma++] = x;
                    last = i + 1;
                }
                try {
                    array[numComma] = new Integer(incString.substring(last));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.setIncluded(array);
            }
        }
    }

    private void synchronizeTo() {
        if (this.root == null) {
            return;
        }
        int[] vec = this.getIncluded();
        StringBuffer temp = new StringBuffer();
        if (vec.length > 0) {
            temp.append(vec[0]);
        }
        for (int i = 1; i < vec.length; ++i) {
            temp.append(",");
            temp.append(vec[i]);
        }
        this.root.setAttribute("included", temp.toString(), "1");
    }
}

