/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.MemoryImageSource;

public abstract class ModelViewBuffered
extends ModelView {
    protected int[] offscreenPixels = null;
    protected Image offscreenBuffer = null;
    protected Graphics offscreenGraphics = null;
    protected boolean rotateOffscreen = false;

    protected ModelViewBuffered() {
    }

    public Image ensureCapacity(Image i, Dimension req) {
        if (i == null) {
            return this.createImage(req.width, req.height);
        }
        int w = i.getWidth(null);
        int h = i.getHeight(null);
        if (w < req.width || h < req.height) {
            if (w < req.width) {
                w = req.width;
            }
            if (h < req.height) {
                h = req.height;
            }
            Image n = this.createImage(w, h);
            n.getGraphics().drawImage(i, 0, 0, null);
            return n;
        }
        return i;
    }

    protected void ensureCapacity(Dimension req) {
        if (this.offscreenBuffer == null) {
            this.createNewBuffer(req.width, req.height);
        }
        int w = this.offscreenBuffer.getWidth(null);
        int h = this.offscreenBuffer.getHeight(null);
        if (w < req.width || h < req.height) {
            if (w < req.width) {
                w = req.width;
            }
            if (h < req.height) {
                h = req.height;
            }
            this.createNewBuffer(w, h);
        }
    }

    private synchronized void createNewBuffer(int w, int h) {
        this.offscreenPixels = new int[w * h];
        MemoryImageSource source = new MemoryImageSource(w, h, this.offscreenPixels, 0, w);
        source.setAnimated(true);
        Image n = this.createImage(source);
        if (this.offscreenBuffer != null) {
            n.getGraphics().drawImage(this.offscreenBuffer, 0, 0, null);
        }
        this.offscreenBuffer = n;
        this.offscreenGraphics = this.offscreenBuffer.getGraphics();
    }

    public synchronized void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Dimension newsize = this.getSize();
        if (newsize == null) {
            return;
        }
        Dimension reqSize = newsize;
        if (this.offscreenBuffer == null || reqSize.width != this.offscreenSize.width || reqSize.height != this.offscreenSize.height) {
            this.offscreenSize = reqSize;
            this.offscreenBuffer = this.ensureCapacity(this.offscreenBuffer, this.offscreenSize);
            this.offscreenGraphics = this.offscreenBuffer.getGraphics();
            try {
                ((Graphics2D)this.offscreenGraphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            catch (NoClassDefFoundError err) {
                // empty catch block
            }
            this.offscreenChanged = true;
        } else {
            this.offscreenChanged = false;
        }
        g.setColor(Color.white);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (this.isEnabled()) {
            if (this.offscreenSize.width > 0 && this.offscreenSize.height > 0) {
                this.updateBuffer(this.offscreenGraphics);
                this.offscreenValid = true;
            }
        } else {
            Graphics tg = this.offscreenBuffer.getGraphics();
            tg.setColor(Color.white);
            tg.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
        }
        if (g != this.offscreenGraphics) {
            g.drawImage(this.offscreenBuffer, 0, 0, this);
        }
        this.paintComposite(g);
    }
}

