/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class ReorderedTreeSelection
extends Observable
implements TreeSelectionI,
Observer {
    private TreeSelectionI parent;
    private int[] reorderedIndex;
    private Vector observers = new Vector();

    public ReorderedTreeSelection(TreeSelectionI p, int[] ri) {
        this.parent = p;
        this.reorderedIndex = ri;
        p.addObserver(this);
    }

    public void resize(int nIndex) {
        this.parent.resize(nIndex);
    }

    public void deselectAllIndexes() {
        this.parent.deselectAllIndexes();
    }

    public void selectAllIndexes() {
        this.parent.selectAllIndexes();
    }

    public void setIndex(int i, boolean b) {
        int index;
        if (i >= this.reorderedIndex.length) {
            i = this.reorderedIndex.length - 1;
        }
        if (i < 0) {
            i = 0;
        }
        if ((index = this.reorderedIndex[i]) != -1) {
            this.parent.setIndex(index, b);
        }
    }

    public boolean isIndexSelected(int i) {
        int index = this.reorderedIndex[i];
        if (index != -1) {
            return this.parent.isIndexSelected(index);
        }
        return false;
    }

    public int getMinIndex() {
        int start = this.parent.getMinIndex();
        if (start == -1) {
            return -1;
        }
        for (int i = 0; i < this.reorderedIndex.length; ++i) {
            if (this.reorderedIndex[i] != start) continue;
            return i;
        }
        return -1;
    }

    public int[] getSelectedIndexes() {
        return this.parent.getSelectedIndexes();
    }

    public int getMaxIndex() {
        int stop = this.parent.getMaxIndex();
        if (stop == -1) {
            return -1;
        }
        for (int i = this.reorderedIndex.length - 1; i >= 0; --i) {
            if (this.reorderedIndex[i] != stop) continue;
            return i;
        }
        return -1;
    }

    public int getNumIndexes() {
        return this.reorderedIndex.length;
    }

    public void selectIndexRange(int min, int max) {
        while (this.reorderedIndex[min] == -1 && min < this.reorderedIndex.length) {
            ++min;
        }
        while (this.reorderedIndex[max] == -1 && max > 0) {
            --max;
        }
        if (max >= 0 && min <= this.reorderedIndex.length) {
            this.parent.selectIndexRange(this.reorderedIndex[min], this.reorderedIndex[max]);
        }
    }

    public int getNSelectedIndexes() {
        return this.parent.getNSelectedIndexes();
    }

    public void setSelectedNode(String n) {
        this.parent.setSelectedNode(n);
    }

    public String getSelectedNode() {
        return this.parent.getSelectedNode();
    }

    public void notifyObservers() {
        this.parent.notifyObservers();
    }

    public void update(Observable arg0, Object arg1) {
        Enumeration e = this.observers.elements();
        while (e.hasMoreElements()) {
            ((Observer)e.nextElement()).update(this, arg1);
        }
    }

    public void addObserver(Observer view) {
        this.observers.addElement(view);
    }

    public void deleteObserver(Observer view) {
        this.observers.remove(view);
    }
}

