/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSet;
import java.awt.Color;

public class CharColorSet
implements ConfigNodePersistent {
    public static final int maxChar = 128;
    private String default_missingColor = "#FFFFFF";
    private String default_emptyColor = "#FFFFFF";
    private String default_name = null;
    private String name;
    private Color missing;
    private Color empty;
    private Color[] charColors = new Color[128];
    private ConfigNode root = null;

    public CharColorSet() {
        this.setAADefaults();
    }

    public CharColorSet(String name, String missing, String empty) {
        this();
        this.setName(name);
        this.setMissing(missing);
        this.setEmpty(empty);
    }

    private void setAADefaults() {
        char i;
        this.missing = CharColorSet.decodeColor(this.default_missingColor);
        this.empty = CharColorSet.decodeColor(this.default_emptyColor);
        for (i = '\u0000'; i < '\u0080'; i = (char)((char)(i + 1))) {
            this.charColors[i] = null;
        }
        this.charColors[68] = CharColorSet.decodeColor("#E60A0A");
        this.charColors[69] = this.charColors[68];
        this.charColors[67] = CharColorSet.decodeColor("#E6E600");
        this.charColors[77] = this.charColors[67];
        this.charColors[75] = CharColorSet.decodeColor("#145AFF");
        this.charColors[82] = this.charColors[75];
        this.charColors[83] = CharColorSet.decodeColor("#FA9600");
        this.charColors[84] = this.charColors[83];
        this.charColors[70] = CharColorSet.decodeColor("#3232AA");
        this.charColors[89] = this.charColors[70];
        this.charColors[78] = CharColorSet.decodeColor("#00DCDC");
        this.charColors[81] = this.charColors[78];
        this.charColors[71] = CharColorSet.decodeColor("#323232");
        this.charColors[76] = CharColorSet.decodeColor("#0F820F");
        this.charColors[86] = this.charColors[76];
        this.charColors[73] = this.charColors[76];
        this.charColors[65] = CharColorSet.decodeColor("#000000");
        this.charColors[87] = CharColorSet.decodeColor("#B45AB4");
        this.charColors[72] = CharColorSet.decodeColor("#8282D2");
        this.charColors[80] = CharColorSet.decodeColor("#DC9682");
        for (i = '\u0000'; i < '\u0080'; i = (char)((char)(i + 1))) {
            if (this.charColors[i] == null) continue;
            String uc = "" + i;
            String lc = uc.toLowerCase();
            this.charColors[lc.charAt((int)0)] = this.charColors[i];
        }
    }

    public void copyStateFrom(CharColorSet other) {
        this.setMissing(other.getMissing());
        this.setEmpty(other.getEmpty());
        this.setName(other.getName());
    }

    public void bindConfig(ConfigNode root) {
        this.root = root;
        this.missing = CharColorSet.decodeColor(root.getAttribute("missing", this.default_missingColor));
        this.empty = CharColorSet.decodeColor(root.getAttribute("empty", this.default_emptyColor));
        this.name = root.getAttribute("name", this.default_name);
    }

    public String toString() {
        return "CharColorSet " + this.getName() + "\n" + "missing: " + this.getMissing().toString() + "\t" + "empty: " + this.getEmpty().toString() + "\t";
    }

    public Color getMissing() {
        return this.missing;
    }

    public Color getEmpty() {
        return this.empty;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor(char c) {
        Color cand = null;
        if (c < '\u0080') {
            cand = this.charColors[c];
        } else {
            System.out.println("passed in char " + c + " greater than maxChar " + 128 + " to CharColorSet.java");
        }
        if (cand == null) {
            return this.getMissing();
        }
        return cand;
    }

    public void setMissing(String newString) {
        this.missing = CharColorSet.decodeColor(newString);
        if (this.root != null) {
            this.root.setAttribute("missing", newString, this.default_missingColor);
        }
    }

    public void setEmpty(String newString) {
        this.empty = CharColorSet.decodeColor(newString);
        if (this.root != null) {
            this.root.setAttribute("empty", newString, this.default_emptyColor);
        }
    }

    public void setColor(char c, String newString) {
    }

    public void setMissing(Color newColor) {
        this.missing = newColor;
        if (this.root != null) {
            this.root.setAttribute("missing", CharColorSet.encodeColor(this.missing), this.default_missingColor);
        }
    }

    public void setEmpty(Color newColor) {
        this.empty = newColor;
        if (this.root != null) {
            this.root.setAttribute("empty", CharColorSet.encodeColor(this.empty), this.default_emptyColor);
        }
    }

    public void setColor(char c, Color newColor) {
    }

    public void setName(String name) {
        this.name = name;
        if (this.root != null) {
            this.root.setAttribute("name", name, this.default_name);
        }
    }

    public static final Color decodeColor(String colorString) {
        return ColorSet.decodeColor(colorString);
    }

    public static final String encodeColor(Color color) {
        return ColorSet.encodeColor(color);
    }
}

