/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ColorSet
implements ConfigNodePersistent {
    private String default_upColor = "#FEFF00";
    private String default_zeroColor = "#000000";
    private String default_downColor = "#1BB7E5";
    private String default_missingColor = "#909090";
    private String default_emptyColor = "#FFFFFF";
    private String default_name = null;
    private String name;
    private Color up;
    private Color zero;
    private Color down;
    private Color missing;
    private Color empty;
    private ConfigNode root = null;

    public ColorSet() {
        this.setDefaults();
    }

    public ColorSet(String name, String up, String zero, String down, String missing, String empty) {
        this.setName(name);
        this.setUp(up);
        this.setZero(zero);
        this.setDown(down);
        this.setMissing(missing);
        this.setEmpty(empty);
    }

    private void setDefaults() {
        this.up = ColorSet.decodeColor(this.default_upColor);
        this.zero = ColorSet.decodeColor(this.default_zeroColor);
        this.down = ColorSet.decodeColor(this.default_downColor);
        this.missing = ColorSet.decodeColor(this.default_missingColor);
        this.empty = ColorSet.decodeColor(this.default_emptyColor);
    }

    public void copyStateFrom(ColorSet other) {
        this.setUp(other.getUp());
        this.setZero(other.getZero());
        this.setDown(other.getDown());
        this.setMissing(other.getMissing());
        this.setEmpty(other.getEmpty());
        this.setName(other.getName());
    }

    public void bindConfig(ConfigNode root) {
        this.root = root;
        this.up = ColorSet.decodeColor(root.getAttribute("up", this.default_upColor));
        this.zero = ColorSet.decodeColor(root.getAttribute("zero", this.default_zeroColor));
        this.down = ColorSet.decodeColor(root.getAttribute("down", this.default_downColor));
        this.missing = ColorSet.decodeColor(root.getAttribute("missing", this.default_missingColor));
        this.empty = ColorSet.decodeColor(root.getAttribute("empty", this.default_emptyColor));
        this.name = root.getAttribute("name", this.default_name);
    }

    public static final void main(String[] argv) {
        ColorSet test = new ColorSet();
        try {
            test.loadEisen(argv[0]);
            test.setName(argv[0]);
            System.out.println(test.toString());
        }
        catch (Exception e) {
            System.out.println("Couldn't load file " + argv[0] + ": " + e);
        }
        if (argv.length > 1) {
            try {
                test.saveEisen(argv[1]);
            }
            catch (Exception e) {
                System.out.println("Couldn't save file " + argv[1] + ": " + e);
            }
        }
    }

    public String toString() {
        return "ColorSet " + this.getName() + "\n" + "up: " + this.getUp().toString() + "\t" + "zero: " + this.getZero().toString() + "\t" + "down: " + this.getDown().toString() + "\t" + "missing: " + this.getMissing().toString() + "\t" + "empty: " + this.getEmpty().toString() + "\t";
    }

    public void loadEisen(String file) throws IOException {
        this.loadEisen(new File(file));
    }

    public void loadEisen(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.up = this.unpackEisen(stream);
        this.zero = this.unpackEisen(stream);
        this.down = this.unpackEisen(stream);
        this.missing = this.unpackEisen(stream);
        stream.close();
    }

    public void saveEisen(String file) throws IOException {
        this.saveEisen(new File(file));
    }

    public void saveEisen(File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        this.packEisen(this.up, stream);
        this.packEisen(this.zero, stream);
        this.packEisen(this.down, stream);
        this.packEisen(this.missing, stream);
        stream.close();
    }

    private Color unpackEisen(InputStream stream) throws IOException {
        int red = stream.read();
        int green = stream.read();
        int blue = stream.read();
        int alpha = stream.read();
        return new Color(red, green, blue, alpha);
    }

    private void packEisen(Color out, OutputStream stream) throws IOException {
        stream.write(out.getRed());
        stream.write(out.getGreen());
        stream.write(out.getBlue());
        stream.write(out.getAlpha());
    }

    public Color getUp() {
        return this.up;
    }

    public Color getZero() {
        return this.zero;
    }

    public Color getDown() {
        return this.down;
    }

    public Color getMissing() {
        return this.missing;
    }

    public Color getEmpty() {
        return this.empty;
    }

    public String getName() {
        return this.name;
    }

    public void setUp(String newString) {
        this.up = ColorSet.decodeColor(newString);
        if (this.root != null) {
            this.root.setAttribute("up", newString, this.default_upColor);
        }
    }

    public void setZero(String newString) {
        this.zero = ColorSet.decodeColor(newString);
        if (this.root != null) {
            this.root.setAttribute("zero", newString, this.default_zeroColor);
        }
    }

    public void setDown(String newString) {
        this.down = ColorSet.decodeColor(newString);
        if (this.root != null) {
            this.root.setAttribute("down", newString, this.default_downColor);
        }
    }

    public void setMissing(String newString) {
        this.missing = ColorSet.decodeColor(newString);
        if (this.root != null) {
            this.root.setAttribute("missing", newString, this.default_missingColor);
        }
    }

    public void setEmpty(String newString) {
        this.empty = ColorSet.decodeColor(newString);
        if (this.root != null) {
            this.root.setAttribute("empty", newString, this.default_emptyColor);
        }
    }

    public void setUp(Color newColor) {
        this.up = newColor;
        if (this.root != null) {
            this.root.setAttribute("up", ColorSet.encodeColor(this.up), this.default_upColor);
        }
    }

    public void setZero(Color newColor) {
        this.zero = newColor;
        if (this.root != null) {
            this.root.setAttribute("zero", ColorSet.encodeColor(this.zero), this.default_zeroColor);
        }
    }

    public void setDown(Color newColor) {
        this.down = newColor;
        if (this.root != null) {
            this.root.setAttribute("down", ColorSet.encodeColor(this.down), this.default_downColor);
        }
    }

    public void setMissing(Color newColor) {
        this.missing = newColor;
        if (this.root != null) {
            this.root.setAttribute("missing", ColorSet.encodeColor(this.missing), this.default_missingColor);
        }
    }

    public void setEmpty(Color newColor) {
        this.empty = newColor;
        if (this.root != null) {
            this.root.setAttribute("empty", ColorSet.encodeColor(this.empty), this.default_emptyColor);
        }
    }

    public void setName(String name) {
        this.name = name;
        if (this.root != null) {
            this.root.setAttribute("name", name, this.default_name);
        }
    }

    public static final Color decodeColor(String colorString) {
        return Color.decode(colorString);
    }

    public static final String encodeColor(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return "#" + ColorSet.hex(red) + ColorSet.hex(green) + ColorSet.hex(blue);
    }

    private static final String hex(int buf) {
        int hi = buf / 16;
        int low = buf % 16;
        return ColorSet.hexChar(hi) + ColorSet.hexChar(low);
    }

    private static final String hexChar(int i) {
        switch (i) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "4";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "9";
            }
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
        }
        return "F";
    }
}

