/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MainPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MessagePanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ATRView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ATRZoomView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayNameView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorExtractor;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorPresetEditor;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorPresets;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.DendroView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.GTRView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.GlobalView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.InvertedTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.KnnArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.LeftTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TextViewManager;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ZoomView;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollBar;

public class KnnDendroView
extends DendroView
implements ConfigNodePersistent,
MainPanel,
Observer {
    public KnnDendroView(DataModel tVModel, ViewFrame vFrame) {
        super(tVModel, null, vFrame, "KnnDendrogram");
    }

    public KnnDendroView(DataModel tVModel, ConfigNode root, ViewFrame vFrame) {
        super(tVModel, root, vFrame, "KnnDendrogram");
    }

    protected void setupViews() {
        DataModel knnModel = this.getDataModel();
        this.hintpanel = new MessagePanel("Usage Hints");
        this.statuspanel = new MessagePanel("View Status");
        this.colorPresets = new ColorPresets(this.root);
        this.cpresetEditor = new ColorPresetEditor(this.colorPresets);
        ColorExtractor colorExtractor = new ColorExtractor();
        colorExtractor.setDefaultColorSet(this.colorPresets.getDefaultColorSet());
        colorExtractor.bindConfig(this.root);
        colorExtractor.setMissing(-1.0E7, -2.0E7);
        KnnArrayDrawer kArrayDrawer = new KnnArrayDrawer();
        kArrayDrawer.setColorExtractor(colorExtractor);
        this.arrayDrawer = kArrayDrawer;
        ((Observable)((Object)this.getDataModel())).addObserver(this.arrayDrawer);
        this.globalview = new GlobalView();
        this.globalXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.globalYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.zoomYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXmap = new MapContainer();
        this.zoomXmap.setDefaultScale(12.0);
        this.zoomXmap.setScrollbar(this.zoomXscrollbar);
        this.zoomYmap = new MapContainer();
        this.zoomYmap.setDefaultScale(12.0);
        this.zoomYmap.setScrollbar(this.zoomYscrollbar);
        this.globalXmap = new MapContainer();
        this.globalXmap.setDefaultScale(2.0);
        this.globalXmap.setScrollbar(this.globalXscrollbar);
        this.globalYmap = new MapContainer();
        this.globalYmap.setDefaultScale(2.0);
        this.globalYmap.setScrollbar(this.globalYscrollbar);
        this.globalview.setXMap(this.globalXmap);
        this.globalview.setYMap(this.globalYmap);
        this.globalview.setZoomYMap(this.getZoomYmap());
        this.globalview.setZoomXMap(this.getZoomXmap());
        this.arraynameview = new ArrayNameView(this.getDataModel().getArrayHeaderInfo());
        this.leftTreeDrawer = new LeftTreeDrawer();
        this.gtrview = new GTRView();
        this.gtrview.setMap(this.globalYmap);
        this.gtrview.setLeftTreeDrawer(this.leftTreeDrawer);
        this.invertedTreeDrawer = new InvertedTreeDrawer();
        this.atrview = new ATRView();
        this.atrview.setMap(this.globalXmap);
        this.atrview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.atrzview = new ATRZoomView();
        this.atrzview.setZoomMap(this.getZoomXmap());
        this.atrzview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.zoomview = new ZoomView();
        this.zoomview.setYMap(this.getZoomYmap());
        this.zoomview.setXMap(this.getZoomXmap());
        this.zoomview.setArrayDrawer(this.arrayDrawer);
        this.globalview.setArrayDrawer(this.arrayDrawer);
        this.arraynameview.setMapping(this.getZoomXmap());
        this.textview = new TextViewManager(this.getDataModel().getGeneHeaderInfo());
        this.textview.setMap(this.getZoomYmap());
        this.doDoubleLayout();
        this.settingsFrame = null;
        colorExtractor.bindConfig(this.getFirst("ColorExtractor"));
        kArrayDrawer.setDataMatrix(knnModel.getDataMatrix());
        kArrayDrawer.bindConfig(this.getFirst("ArrayDrawer"));
        this.bindTrees();
        this.globalXmap.bindConfig(this.getFirst("GlobalXMap"));
        this.globalYmap.bindConfig(this.getFirst("GlobalYMap"));
        this.getZoomXmap().bindConfig(this.getFirst("ZoomXMap"));
        this.getZoomYmap().bindConfig(this.getFirst("ZoomYMap"));
        this.textview.bindConfig(this.getFirst("TextViewParent"));
        this.arraynameview.bindConfig(this.getFirst("ArrayNameView"));
        DataMatrix dataMatrix = this.getDataModel().getDataMatrix();
        this.globalXmap.setIndexRange(0, dataMatrix.getNumCol() - 1);
        this.globalYmap.setIndexRange(0, dataMatrix.getNumRow() - 1);
        this.getZoomXmap().setIndexRange(-1, -1);
        this.getZoomYmap().setIndexRange(-1, -1);
        this.globalXmap.notifyObservers();
        this.globalYmap.notifyObservers();
        this.getZoomXmap().notifyObservers();
        this.getZoomYmap().notifyObservers();
    }
}

