/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.model;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import java.io.FileWriter;
import java.io.IOException;

public class DataMatrixWriter {
    DataMatrix matrix;
    HeaderInfo geneHeader;
    HeaderInfo arrayHeader;

    public DataMatrixWriter(DataMatrix matrix, HeaderInfo geneHeader, HeaderInfo arrayHeader) {
        this.matrix = matrix;
        this.geneHeader = geneHeader;
        this.arrayHeader = arrayHeader;
    }

    public void write(String cdt) throws IOException {
        FileWriter out = new FileWriter(cdt);
        int nGenes = this.matrix.getNumRow();
        int nExpr = this.matrix.getNumCol();
        this.writeGeneHeader(out);
        String[] arrayNames = this.arrayHeader.getNames();
        for (int header = 0; header < arrayNames.length; ++header) {
            this.writeArrayHeader(out, arrayNames[header], this.geneHeader.getNames().length);
        }
        for (int row = 0; row < nGenes; ++row) {
            this.writeDataRow(out, row);
        }
        out.flush();
        out.close();
    }

    private void writeGeneHeader(FileWriter out) throws IOException {
        String[] geneNames = this.geneHeader.getNames();
        for (int i = 0; i < geneNames.length; ++i) {
            out.write(geneNames[i] + "\t");
        }
        this.writeArrayHeader(out, "AID", -1);
    }

    private void writeArrayHeader(FileWriter out, String header, int spacers) throws IOException {
        int i;
        if (spacers >= 0) {
            out.write(header);
            for (i = 0; i < spacers; ++i) {
                out.write("\t");
            }
        }
        for (i = 0; i < this.arrayHeader.getNumHeaders() - 1; ++i) {
            out.write(this.arrayHeader.getHeader(i, header) + "\t");
        }
        out.write(this.arrayHeader.getHeader(this.arrayHeader.getNumHeaders() - 1, header) + "\n");
    }

    private void writeDataRow(FileWriter out, int row) throws IOException {
        String[] geneNames = this.geneHeader.getNames();
        for (int i = 0; i < geneNames.length; ++i) {
            out.write(this.geneHeader.getHeader(row, geneNames[i]) + "\t");
        }
        for (int col = 0; col < this.matrix.getNumCol() - 1; ++col) {
            out.write(this.matrix.getValue(col, row) + "\t");
        }
        out.write(this.matrix.getValue(this.matrix.getNumCol() - 1, row) + "\n");
    }
}

