/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.model;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.TVModel;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewModel
extends TVModel {
    boolean isSymmetrical = false;
    boolean zeroMissing = false;
    Double diagonalValue = null;
    List<String> clusterParams = null;
    CyNetwork network;
    CyNetworkView networkView;
    TaskMonitor monitor;
    ClusterManager clusterManager;
    private String[] clusterHeaders = new String[]{"NODEID", "LEFT", "RIGHT", "CORRELATION"};

    public TreeViewModel(TaskMonitor monitor, CyNetwork network, CyNetworkView networkView, ClusterManager clusterManager) {
        this.monitor = monitor;
        this.network = network;
        this.networkView = networkView;
        this.clusterManager = clusterManager;
        String clusterType = null;
        if (ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__clusterType")) {
            clusterType = (String)network.getRow((CyIdentifiable)network).get("__clusterType", String.class);
        }
        if (ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__clusterParams")) {
            this.clusterParams = network.getRow((CyIdentifiable)network).getList("__clusterParams", String.class);
        }
        if (this.clusterParams != null) {
            for (String param : this.clusterParams) {
                String[] pair = param.split("=");
                if (pair[0].equals("zeroMissing")) {
                    this.zeroMissing = Boolean.valueOf(pair[1]);
                    continue;
                }
                if (!pair[0].equals("diagonals")) continue;
                this.diagonalValue = Double.valueOf(pair[1]);
            }
        }
        List geneList = network.getRow((CyIdentifiable)network).getList("__nodeOrder", String.class);
        String[][] gHeaders = new String[geneList.size()][4];
        int headerNumber = 0;
        Iterator i$ = geneList.iterator();
        while (i$.hasNext()) {
            String nodeName;
            gHeaders[headerNumber][0] = nodeName = (String)i$.next();
            gHeaders[headerNumber][1] = nodeName;
            gHeaders[headerNumber][2] = nodeName;
            gHeaders[headerNumber++][3] = "1.0";
        }
        this.setGenePrefix(new String[]{"GID", "NODE", "ORF", "GWEIGHT"});
        this.setGeneHeaders(gHeaders);
        List arrayList = network.getRow((CyIdentifiable)network).getList("__arrayOrder", String.class);
        String[][] aHeaders = new String[arrayList.size()][2];
        headerNumber = 0;
        Iterator i$2 = arrayList.iterator();
        while (i$2.hasNext()) {
            String attribute;
            aHeaders[headerNumber][0] = attribute = (String)i$2.next();
            aHeaders[headerNumber++][1] = "1.0";
        }
        this.setArrayPrefix(new String[]{"AID", "EWEIGHT"});
        this.setArrayHeaders(aHeaders);
        int nGene = geneList.size();
        int nExpr = arrayList.size();
        double[] exprData = new double[nGene * nExpr];
        if (((String)geneList.get(0)).equals(arrayList.get(0))) {
            String attribute = (String)network.getRow((CyIdentifiable)network).get("__clusterEdgeWeight", String.class);
            attribute = attribute.substring(5);
            for (int row = 0; row < nGene; ++row) {
                for (int col = 0; col < nExpr; ++col) {
                    int cell = row * nExpr + col;
                    exprData[cell] = this.diagonalValue != null && row == col ? this.diagonalValue : (this.zeroMissing ? 0.0 : -1.0E7);
                }
            }
            Class attributeType = network.getDefaultEdgeTable().getColumn(attribute).getType();
            for (CyEdge edge : network.getEdgeList()) {
                CyNode source = edge.getSource();
                CyNode target = edge.getTarget();
                if (!geneList.contains(ModelUtils.getName(network, (CyIdentifiable)source)) || !geneList.contains(ModelUtils.getName(network, (CyIdentifiable)target))) continue;
                Double val = ModelUtils.getNumericValue(network, (CyIdentifiable)edge, attribute);
                int gene = geneList.indexOf(ModelUtils.getName(network, (CyIdentifiable)source));
                int expr = geneList.indexOf(ModelUtils.getName(network, (CyIdentifiable)target));
                if (val == null) continue;
                exprData[gene * nExpr + expr] = val;
                exprData[expr * nExpr + gene] = val;
            }
            this.isSymmetrical = true;
        } else {
            int gene = 0;
            for (String nodeName : geneList) {
                CyNode node = (CyNode)ModelUtils.getNetworkObjectWithName(network, nodeName, CyNode.class);
                int expr = 0;
                for (String attribute : arrayList) {
                    Double val = ModelUtils.getNumericValue(network, (CyIdentifiable)node, attribute);
                    exprData[gene * nExpr + expr] = val == null ? -1.0E7 : val;
                    ++expr;
                }
                ++gene;
            }
        }
        this.setExprData(exprData);
        this.hashGIDs();
        this.hashAIDs();
        if (ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__nodeClusters")) {
            System.out.println("ClusterNodeAttribute: __nodeClusters");
            List groupList = network.getRow((CyIdentifiable)network).getList("__nodeClusters", String.class);
            System.out.println("Size of grouplist: " + groupList.size());
            this.setGtrPrefix(this.getClusterHeaders());
            String[][] gtrHeaders = new String[groupList.size()][this.getClusterHeaders().length];
            this.parseGroupHeaders(groupList, gtrHeaders);
            this.setGtrHeaders(gtrHeaders);
            this.hashGTRs();
            this.gidFound(true);
        }
        if (ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__attrClusters")) {
            List groupList = network.getRow((CyIdentifiable)network).getList("__attrClusters", String.class);
            this.setAtrPrefix(this.getClusterHeaders());
            String[][] atrHeaders = new String[groupList.size()][this.getClusterHeaders().length];
            this.parseGroupHeaders(groupList, atrHeaders);
            this.setAtrHeaders(atrHeaders);
            this.hashATRs();
            this.aidFound(true);
        }
        this.setEweightFound(false);
        this.setGweightFound(false);
    }

    @Override
    public String getName() {
        return (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class) + " Clusters";
    }

    @Override
    public String getSource() {
        return (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class);
    }

    @Override
    public boolean isSymmetrical() {
        return this.isSymmetrical;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    protected String[] getClusterHeaders() {
        return new String[]{"NODEID", "LEFT", "RIGHT", "CORRELATION"};
    }

    private void parseGroupHeaders(List<String> groupList, String[][] headers) {
        int headerNumber = 0;
        int headerLength = headers[0].length;
        for (String group : groupList) {
            String[] tokens = group.split("[\t]");
            for (int t = 0; t < headerLength; ++t) {
                headers[headerNumber][t] = tokens[t];
            }
            ++headerNumber;
        }
    }
}

