/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterVizFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.ResultsPanelTask;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateResultsPanelTaskFactory
implements ClusterVizFactory {
    ClusterManager clusterManager;
    boolean checkAvailable;
    public static String CLUSTERNAME = "Create Results Panel from Clusters";
    public static String CLUSTERSHORTNAME = "createResultsPanel";

    public CreateResultsPanelTaskFactory(ClusterManager clusterManager, boolean checkAvailable) {
        this.clusterManager = clusterManager;
        this.checkAvailable = checkAvailable;
    }

    @Override
    public String getShortName() {
        if (this.checkAvailable) {
            return CLUSTERSHORTNAME;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.checkAvailable) {
            return CLUSTERNAME;
        }
        return null;
    }

    @Override
    public ClusterViz getVisualizer() {
        return null;
    }

    @Override
    public boolean isAvailable(CyNetwork network) {
        if (!this.checkAvailable) {
            return true;
        }
        if (network == null) {
            return false;
        }
        return ResultsPanelTask.isReady(network, this.clusterManager);
    }

    @Override
    public List<ClusterTaskFactory.ClusterType> getTypeList() {
        return Collections.singletonList(ClusterTaskFactory.ClusterType.UI);
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new ResultsPanelTask(this.clusterManager, this.checkAvailable, true)});
    }

    public boolean isReady() {
        if (this.clusterManager.getResultsPanel() != null) {
            return false;
        }
        if (!this.checkAvailable) {
            return true;
        }
        return ResultsPanelTask.isReady(this.clusterManager.getNetwork(), this.clusterManager);
    }
}

