/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.PropertyConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeViewApp;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.TreeViewModel;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.HeatMapContext;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeatMapView
extends TreeViewApp
implements Observer,
RowsSetListener,
ClusterViz,
ClusterAlgorithm {
    public static String SHORTNAME = "heatmapview";
    public static String NAME = "JTree HeatMapView (unclustered)";
    private URL codeBase = null;
    protected ViewFrame viewFrame = null;
    protected TreeSelectionI geneSelection = null;
    protected TreeSelectionI arraySelection = null;
    protected TreeViewModel dataModel = null;
    protected CyNetworkView myView = null;
    protected TaskMonitor monitor = null;
    private List<CyNode> selectedNodes = new ArrayList<CyNode>();
    private List<CyNode> selectedArrays = new ArrayList<CyNode>();
    private boolean disableListeners = false;
    private boolean ignoreSelection = false;
    protected ClusterManager manager = null;
    protected CyNetworkTableManager networkTableManager = null;
    @Tunable(description="Network to view heatmap for", context="nogui")
    public CyNetwork myNetwork = null;
    @ContainsTunables
    public HeatMapContext context = null;
    private static String appName = "clusterMaker HeatMapView";

    public HeatMapView(HeatMapContext context, ClusterManager manager) {
        this.manager = manager;
        this.context = context;
        this.networkTableManager = manager.getService(CyNetworkTableManager.class);
        if (this.myNetwork == null) {
            this.myNetwork = manager.getNetwork();
        }
        context.setNetwork(this.myNetwork);
    }

    public HeatMapView(PropertyConfig propConfig) {
        super(propConfig);
    }

    public void setVisible(boolean visibility) {
        if (this.viewFrame != null) {
            this.viewFrame.setVisible(visibility);
        }
    }

    public String getAppName() {
        return appName;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    @Override
    public ClusterResults getResults() {
        return null;
    }

    @Override
    public void run(TaskMonitor monitor) {
        monitor.setTitle("Creating heat map");
        this.myView = this.manager.getNetworkView();
        this.monitor = monitor;
        if (this.isAvailable()) {
            this.startup();
        } else {
            monitor.showMessage(TaskMonitor.Level.ERROR, "No compatible cluster results available");
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public boolean isAvailable(CyNetwork network) {
        return true;
    }

    public void cancel() {
    }

    protected void startup() {
        int index;
        Object[] nodeArray;
        CyProperty cyProperty = this.manager.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        List<String> nodeAttributeList = this.context.attributeList.getNodeAttributeList();
        String edgeAttribute = this.context.attributeList.getEdgeAttribute();
        if (nodeAttributeList == null && edgeAttribute == null) {
            this.monitor.showMessage(TaskMonitor.Level.ERROR, "Must select either one edge column or two or more node columns");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() > 0 && edgeAttribute != null) {
            this.monitor.showMessage(TaskMonitor.Level.ERROR, "Can't have both node and edge columns selected");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() < 2) {
            this.monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least two node columns for cluster weighting");
            return;
        }
        if (!this.context.selectedOnly) {
            nodeArray = new String[this.myNetwork.getNodeCount()];
            index = 0;
            for (CyNode node : this.myNetwork.getNodeList()) {
                nodeArray[index++] = ModelUtils.getName(this.myNetwork, (CyIdentifiable)node);
            }
        } else if (edgeAttribute != null && edgeAttribute.length() > 0) {
            List selectedEdges = CyTableUtil.getEdgesInState((CyNetwork)this.myNetwork, (String)"selected", (boolean)true);
            HashSet<CyNode> nodesSeen = new HashSet<CyNode>();
            for (CyEdge edge : selectedEdges) {
                nodesSeen.add(edge.getSource());
                nodesSeen.add(edge.getTarget());
            }
            int index2 = 0;
            nodeArray = new String[nodesSeen.size()];
            for (CyNode node : nodesSeen) {
                nodeArray[index2++] = ModelUtils.getName(this.myNetwork, (CyIdentifiable)node);
            }
        } else {
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)this.myNetwork, (String)"selected", (boolean)true);
            nodeArray = new String[selectedNodes.size()];
            int index3 = 0;
            for (CyNode node : selectedNodes) {
                nodeArray[index3++] = ModelUtils.getName(this.myNetwork, (CyIdentifiable)node);
            }
        }
        Arrays.sort(nodeArray);
        ModelUtils.createAndSetLocal(this.myNetwork, (CyIdentifiable)this.myNetwork, "__nodeOrder", Arrays.asList(nodeArray), List.class, String.class);
        if (edgeAttribute != null && edgeAttribute.length() > 0) {
            ModelUtils.createAndSetLocal(this.myNetwork, (CyIdentifiable)this.myNetwork, "__arrayOrder", Arrays.asList(nodeArray), List.class, String.class);
            ModelUtils.createAndSetLocal(this.myNetwork, (CyIdentifiable)this.myNetwork, "__clusterEdgeWeight", "edge." + edgeAttribute, String.class, null);
        } else {
            index = 0;
            Collections.sort(nodeAttributeList);
            ModelUtils.createAndSetLocal(this.myNetwork, (CyIdentifiable)this.myNetwork, "__arrayOrder", nodeAttributeList, List.class, String.class);
        }
        this.dataModel = new TreeViewModel(this.monitor, this.myNetwork, this.myView, this.manager);
        this.setConfigDefaults(new PropertyConfig((CyProperty<Properties>)cyProperty, HeatMapView.globalConfigName(), "ProgramConfig"));
        PropertyConfig documentConfig = new PropertyConfig((CyProperty<Properties>)cyProperty, this.getShortName(), "DocumentConfig");
        this.dataModel.setDocumentConfig(documentConfig);
        TreeViewFrame frame = new TreeViewFrame(this, appName);
        frame.setDataModel(this.dataModel);
        frame.setLoaded(true);
        frame.addWindowListener(this);
        frame.setVisible(true);
        this.geneSelection = frame.getGeneSelection();
        this.geneSelection.addObserver(this);
        this.arraySelection = frame.getArraySelection();
        this.arraySelection.addObserver(this);
        this.manager.registerService(this, RowsSetListener.class, new Properties());
    }

    public void handleEvent(RowsSetEvent e) {
        if (!e.containsColumn("selected")) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        CyTable table = (CyTable)e.getSource();
        CyNetwork net = this.networkTableManager.getNetworkForTable(table);
        Class type = this.networkTableManager.getTableType(table);
        if (type.equals(CyNode.class)) {
            if (this.dataModel.isSymmetrical()) {
                return;
            }
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)net, (String)"selected", (boolean)true);
            this.setNodeSelection(selectedNodes, true);
        } else if (type.equals(CyEdge.class) && this.dataModel.isSymmetrical()) {
            List selectedEdges = CyTableUtil.getEdgesInState((CyNetwork)net, (String)"selected", (boolean)true);
            this.setEdgeSelection(selectedEdges, true);
        }
    }

    @Override
    public void closeAllWindows() {
        super.closeAllWindows();
        this.manager.unregisterService(this, RowsSetListener.class);
    }

    @Override
    public void update(Observable o, Object arg) {
        CyNetworkView currentView = this.manager.getNetworkView();
        CyNetwork currentNetwork = this.manager.getNetwork();
        if (o == this.arraySelection && arg instanceof Boolean) {
            this.disableListeners = (Boolean)arg;
        }
        if (this.disableListeners) {
            return;
        }
        if (o == this.geneSelection) {
            this.selectedNodes.clear();
            int[] selections = this.geneSelection.getSelectedIndexes();
            HeaderInfo geneInfo = this.dataModel.getGeneHeaderInfo();
            String[] names = geneInfo.getNames();
            for (int i = 0; i < selections.length; ++i) {
                String nodeName = geneInfo.getHeader(selections[i])[0];
                CyNode node = (CyNode)ModelUtils.getNetworkObjectWithName(currentNetwork, nodeName, CyNode.class);
                if (node != null && !currentNetwork.containsNode(node)) {
                    String[] tokens = nodeName.split(" ");
                    node = (CyNode)ModelUtils.getNetworkObjectWithName(currentNetwork, tokens[0], CyNode.class);
                }
                if (node == null) continue;
                this.selectedNodes.add(node);
            }
            if (!this.dataModel.isSymmetrical() || this.selectedArrays.size() == 0) {
                List nodesToClear = CyTableUtil.getNodesInState((CyNetwork)currentNetwork, (String)"selected", (boolean)true);
                this.ignoreSelection = true;
                for (CyNode node : nodesToClear) {
                    this.myNetwork.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.FALSE);
                    if (!currentNetwork.containsNode(node)) continue;
                    currentNetwork.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.FALSE);
                }
                for (CyNode node : this.selectedNodes) {
                    if (currentNetwork.containsNode(node)) {
                        currentNetwork.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.TRUE);
                    }
                    this.myNetwork.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.TRUE);
                }
                this.manager.getService(CyEventHelper.class).flushPayloadEvents();
                this.ignoreSelection = false;
                if (currentView != null) {
                    currentView.updateView();
                }
            }
            return;
        }
        if (o == this.arraySelection) {
            if (!this.dataModel.isSymmetrical()) {
                return;
            }
            this.selectedArrays.clear();
            int[] selections = this.arraySelection.getSelectedIndexes();
            if (selections.length == this.dataModel.nExpr()) {
                return;
            }
            HeaderInfo arrayInfo = this.dataModel.getArrayHeaderInfo();
            String[] names = arrayInfo.getNames();
            for (int i = 0; i < selections.length; ++i) {
                String nodeName = arrayInfo.getHeader(selections[i])[0];
                CyNode node = (CyNode)ModelUtils.getNetworkObjectWithName(currentNetwork, nodeName, CyNode.class);
                if (node != null && !currentNetwork.containsNode(node)) {
                    String[] tokens = nodeName.split(" ");
                    node = (CyNode)ModelUtils.getNetworkObjectWithName(currentNetwork, tokens[0], CyNode.class);
                }
                if (node == null) continue;
                this.selectedArrays.add(node);
            }
        }
        HashMap edgesToSelect = new HashMap();
        this.ignoreSelection = true;
        List edgesToClear = CyTableUtil.getEdgesInState((CyNetwork)currentNetwork, (String)"selected", (boolean)true);
        for (CyEdge edge : edgesToClear) {
            this.myNetwork.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.FALSE);
            if (!currentNetwork.containsEdge(edge)) continue;
            currentNetwork.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.FALSE);
        }
        for (CyNode node1 : this.selectedNodes) {
            for (CyNode node2 : this.selectedArrays) {
                List edges = currentNetwork.getConnectingEdgeList(node1, node2, CyEdge.Type.ANY);
                if (edges == null) continue;
                for (CyEdge edge : edges) {
                    this.myNetwork.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.TRUE);
                    if (!currentNetwork.containsEdge(edge)) continue;
                    currentNetwork.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.TRUE);
                }
            }
        }
        this.manager.getService(CyEventHelper.class).flushPayloadEvents();
        this.ignoreSelection = false;
        if (currentView != null) {
            currentView.updateView();
        }
        this.selectedNodes.clear();
        this.selectedArrays.clear();
    }

    private void setEdgeSelection(List<CyEdge> edgeArray, boolean select) {
        HeaderInfo geneInfo = this.dataModel.getGeneHeaderInfo();
        HeaderInfo arrayInfo = this.dataModel.getArrayHeaderInfo();
        this.geneSelection.deleteObserver(this);
        this.arraySelection.deleteObserver(this);
        this.geneSelection.setSelectedNode(null);
        this.geneSelection.deselectAllIndexes();
        this.arraySelection.setSelectedNode(null);
        this.arraySelection.deselectAllIndexes();
        for (CyEdge cyEdge : edgeArray) {
            if (!this.myNetwork.containsEdge(cyEdge)) continue;
            CyNode source = cyEdge.getSource();
            CyNode target = cyEdge.getTarget();
            int geneIndex = geneInfo.getHeaderIndex(ModelUtils.getName(this.myNetwork, (CyIdentifiable)source));
            int arrayIndex = arrayInfo.getHeaderIndex(ModelUtils.getName(this.myNetwork, (CyIdentifiable)target));
            this.geneSelection.setIndex(geneIndex, select);
            this.arraySelection.setIndex(arrayIndex, select);
        }
        this.geneSelection.notifyObservers();
        this.arraySelection.notifyObservers();
        this.geneSelection.addObserver(this);
        this.arraySelection.addObserver(this);
    }

    private void setNodeSelection(List<CyNode> nodeArray, boolean select) {
        HeaderInfo geneInfo = this.dataModel.getGeneHeaderInfo();
        this.geneSelection.deleteObserver(this);
        this.geneSelection.setSelectedNode(null);
        this.geneSelection.deselectAllIndexes();
        for (CyNode cyNode : nodeArray) {
            if (!this.myNetwork.containsNode(cyNode)) continue;
            int geneIndex = geneInfo.getHeaderIndex(ModelUtils.getName(this.myNetwork, (CyIdentifiable)cyNode));
            this.geneSelection.setIndex(geneIndex, select);
        }
        this.geneSelection.deleteObserver(this);
        this.geneSelection.notifyObservers();
        this.geneSelection.addObserver(this);
    }
}

