/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.ui.HistoChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class Histogram
extends JComponent
implements MouseMotionListener,
MouseListener {
    private int[] histoArray;
    private double[] graphData;
    private int histoMax = Integer.MIN_VALUE;
    private int histoMin = 0;
    private int histoMaxUp = 0;
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;
    private double low;
    private double high;
    private final int XSTART = 100;
    private final int YEND = 50;
    private final int NBINS;
    private int mouseX;
    private boolean boolShowLine = false;
    private List<HistoChangeListener> listeners = null;
    private double xInterval;
    private double xIncrement;
    private int height;
    private int width;
    private int yTicks = 10;
    private int xTicks = 10;
    private static final String FONT_FAMILY = "SansSerif";
    private Font adjFont;
    DecimalFormat form = new DecimalFormat("0.0E0");

    Histogram(double[] inputData, int nBins) {
        this.NBINS = nBins;
        this.height = 400;
        this.width = 1000;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.histoArray = new int[this.NBINS];
        this.graphData = inputData;
        this.listeners = new ArrayList<HistoChangeListener>();
        this.adjFont = new Font(FONT_FAMILY, 0, 14);
        this.createHistogram(this.graphData);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void updateData(double[] graphData) {
        this.histoArray = new int[this.NBINS];
        this.graphData = graphData;
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.MIN_VALUE;
        this.histoMax = Integer.MIN_VALUE;
        this.histoMaxUp = 0;
        this.createHistogram(graphData);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension dim = this.getSize();
        if (dim.width == 0 || dim.height == 0) {
            dim = this.getPreferredSize();
        }
        this.width = dim.width;
        this.height = dim.height;
        this.xIncrement = (double)(this.width - 200) / (double)this.NBINS;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.drawGraph(g2);
        if (this.boolShowLine) {
            this.mouseLine(this.mouseX, g);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.rePaintMouseLine(e.getX());
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.rePaintMouseLine(e.getX());
    }

    public void mouseReleased(MouseEvent e) {
        int histoMousePos = (int)((double)(e.getX() - 100) / this.xIncrement);
        if (e.getX() > 100 && (double)e.getX() < 100.0 + this.xIncrement * (double)this.histoArray.length && this.boolShowLine) {
            double binValue = this.xInterval * (double)histoMousePos;
            if (this.listeners.size() == 0) {
                return;
            }
            for (HistoChangeListener listener : this.listeners) {
                listener.histoValueChanged(Double.parseDouble(this.form.format(binValue)));
            }
        }
    }

    public void setBoolShowLine(boolean inShowLine) {
        this.boolShowLine = inShowLine;
    }

    public void setLineValue(double cutOffValue) {
        this.mouseX = (int)(cutOffValue / this.xInterval * this.xIncrement) + 100;
        int histoMousePos = (int)((double)(this.mouseX - 100) / this.xIncrement);
        double binValue = this.xInterval * (double)histoMousePos;
        if (this.boolShowLine) {
            this.rePaintMouseLine(this.mouseX);
        }
    }

    public void addHistoChangeListener(HistoChangeListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeHistoChangeListener(HistoChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void mouseLine(int mX, Graphics g) {
        int histoMousePos = (int)((double)(mX - 100) / this.xIncrement);
        if (histoMousePos >= this.histoArray.length) {
            histoMousePos = this.histoArray.length - 1;
        }
        g.setColor(Color.red);
        g.drawLine(mX, 50, mX, this.height);
        g.setColor(Color.black);
        g.setFont(this.adjFont);
        g.drawString(this.toSciNotation(this.form.format(this.xInterval * (double)histoMousePos).toString(), " (" + this.histoArray[histoMousePos] + " values)"), mX - 50, 45);
    }

    private void rePaintMouseLine(int xPos) {
        this.repaint(this.mouseX - 1, 50, 2, this.height - 50);
        this.repaint(this.mouseX - 50, 20, 150, 30);
        if (xPos > 100 && this.boolShowLine) {
            this.mouseX = xPos;
            this.repaint(this.mouseX - 1, 50, 2, this.height - 50);
            this.repaint(this.mouseX - 50, 20, 150, 30);
        }
    }

    private void createHistogram(double[] inputData) {
        this.calculateXScale();
        block0: for (double dataItr : inputData) {
            for (int nI = 0; nI < this.NBINS; ++nI) {
                if (dataItr == this.low) {
                    this.histoArray[0] = this.histoArray[0] + 1;
                    continue block0;
                }
                if (!(dataItr > this.low + this.xInterval * (double)nI) || !(dataItr <= this.low + this.xInterval * (double)(nI + 1))) continue;
                int n = nI;
                this.histoArray[n] = this.histoArray[n] + 1;
                continue block0;
            }
        }
        this.calculateYScale();
    }

    private void calculateXScale() {
        for (int i = 0; i < this.graphData.length; ++i) {
            this.minValue = Math.min(this.minValue, this.graphData[i]);
            this.maxValue = Math.max(this.maxValue, this.graphData[i]);
        }
        double range = this.maxValue - this.minValue;
        double oomRange = Math.log10(range);
        oomRange += 0.5 * oomRange / Math.abs(oomRange);
        oomRange = (int)oomRange;
        this.high = Math.rint(this.maxValue / Math.pow(10.0, oomRange) + 0.5) * Math.pow(10.0, oomRange);
        if (this.maxValue <= this.high / 2.0) {
            this.high /= 2.0;
        }
        this.low = Math.rint(this.minValue / Math.pow(10.0, oomRange) - 0.5) * Math.pow(10.0, oomRange);
        if (this.minValue >= this.low / 2.0) {
            this.low /= 2.0;
        }
        this.xInterval = (this.high - this.low) / (double)this.NBINS;
    }

    private void calculateYScale() {
        this.histoMin = 0;
        for (int nI = 0; nI < this.histoArray.length; ++nI) {
            this.histoMax = Math.max(this.histoMax, this.histoArray[nI]);
        }
        while (this.histoMax > this.histoMaxUp) {
            this.histoMaxUp += (int)Math.pow(10.0, (int)Math.log10(this.histoMax));
        }
        if (this.histoMaxUp < 10) {
            this.histoMaxUp = 10;
        }
    }

    private void drawGraph(Graphics2D g) {
        Dimension dim = this.getSize();
        if (dim.height == 0 || dim.width == 0) {
            dim = this.getPreferredSize();
        }
        int height = dim.height - 100;
        int width = dim.width;
        if (this.NBINS > 1000) {
            this.xTicks = 20;
        }
        if (this.NBINS > 5000) {
            this.xTicks = 50;
        }
        if (this.NBINS > 10000) {
            this.xTicks = 100;
        }
        this.drawAxes(g, height, width);
        this.drawLabels(g, height, width);
        this.drawData(g, height, width);
    }

    private void drawAxes(Graphics2D g, int height, int width) {
        int nI;
        int maxX = (int)(this.xIncrement * (double)this.NBINS + 100.0);
        g.setColor(Color.black);
        g.drawLine(100, 50, 100, height);
        g.drawLine(100, height, maxX, height);
        double yIncrement = (double)(height - 50) / (double)this.histoMaxUp;
        for (nI = 1; nI <= this.histoMaxUp; ++nI) {
            if ((double)nI % ((double)this.histoMaxUp / (double)this.yTicks) == 0.0) {
                g.setColor(Color.red);
                g.drawLine(95, (int)((double)height - yIncrement * (double)nI), maxX, (int)((double)height - yIncrement * (double)nI));
                continue;
            }
            if ((double)nI % ((double)this.histoMaxUp / (double)(this.yTicks * 2)) != 0.0) continue;
            g.setColor(Color.gray);
            g.drawLine(100, (int)((double)height - yIncrement * (double)nI), maxX, (int)((double)height - yIncrement * (double)nI));
        }
        g.setColor(Color.black);
        for (nI = 0; nI < this.NBINS; ++nI) {
            int x = 100 + (int)(this.xIncrement * (double)nI);
            if (nI % (this.NBINS / this.xTicks) == 0) {
                g.drawLine(x, height, x, height + 10);
                continue;
            }
            if (nI % (this.NBINS / (this.xTicks * 5)) != 0) continue;
            g.drawLine(x, height, x, height + 5);
        }
    }

    private void drawLabels(Graphics2D g, int height, int width) {
        int nI;
        g.setColor(Color.black);
        g.setFont(this.adjFont);
        FontMetrics metrics = g.getFontMetrics();
        double yIncrement = (double)(height - 50) / (double)this.histoMaxUp;
        for (nI = 1; nI <= this.histoMaxUp; ++nI) {
            String str = "" + nI;
            int offset = 90 - metrics.stringWidth(str);
            if (nI % (this.histoMaxUp / this.yTicks) != 0) continue;
            g.drawString(str, offset, height - (int)(yIncrement * (double)nI) + 5);
        }
        for (nI = 0; nI <= this.NBINS; ++nI) {
            double value = this.low + this.xInterval * (double)nI;
            String str = this.form.format(value);
            int offset = 100 + metrics.stringWidth(str) / 2 - 50;
            if (value == 0.0 || value > 1.0 && value < 10.0) {
                offset += 20;
            }
            int x = (int)(this.xIncrement * (double)nI) + offset;
            if (nI % (this.NBINS / this.xTicks) != 0) continue;
            g.drawString(this.toSciNotation(str, ""), x, height + 25);
        }
    }

    private void drawData(Graphics2D g, int height, int width) {
        int nBlueChange = 100;
        int barWidth = 0;
        double yIncrement = (double)(height - 50) / (double)this.histoMaxUp;
        double xValue = this.low;
        barWidth = this.xIncrement < 1.0 ? 1 : (int)this.xIncrement;
        for (int nI = 0; nI < this.NBINS; ++nI) {
            double barHeight = (double)this.histoArray[nI] * yIncrement;
            if (barHeight > 0.0) {
                g.setColor(new Color(0, 0, nBlueChange));
                g.fillRect(100 + (int)(this.xIncrement * (double)nI), (int)((double)height - barHeight), barWidth, (int)barHeight);
                g.setColor(Color.black);
                g.drawRect(100 + (int)(this.xIncrement * (double)nI), (int)((double)height - barHeight), barWidth, (int)barHeight);
            }
            if ((nBlueChange += 15) >= 250) {
                nBlueChange = 100;
            }
            xValue += this.xInterval;
        }
    }

    private AttributedCharacterIterator toSciNotation(String d, String suffix) {
        AttributedString str;
        String returnString = "";
        for (int i = 0; i < d.length() && d.charAt(i) != 'E'; ++i) {
            returnString = returnString + d.charAt(i);
        }
        String exponent = "";
        for (int i = d.length() - 1; i > 0; --i) {
            if (d.charAt(i) != 'E') continue;
            exponent = exponent + d.substring(i + 1, d.length());
        }
        if (exponent.length() == 0 || Integer.parseInt(exponent) == 0) {
            str = new AttributedString(returnString + suffix);
            str.addAttribute(TextAttribute.FONT, this.adjFont);
        } else {
            returnString = returnString + "x10";
            int superOffset = returnString.length();
            returnString = returnString + exponent;
            int superEnd = returnString.length();
            str = new AttributedString(returnString + suffix);
            str.addAttribute(TextAttribute.FAMILY, FONT_FAMILY);
            str.addAttribute(TextAttribute.SIZE, new Float(14.0f));
            str.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, superOffset, superEnd);
        }
        return str.getIterator();
    }
}

