/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeAttributeHandler;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeWeightConverter;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkViewContext;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.LineTypeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewNetworkView
extends AbstractTask
implements ClusterViz,
ClusterAlgorithm {
    private static String appName = "ClusterMaker New Network View";
    private boolean checkForAvailability = false;
    private boolean restoreEdges = false;
    private ClusterManager manager;
    private String clusterAttribute = null;
    private EdgeAttributeHandler edgeConverterList = null;
    public static String CLUSTERNAME = "Create New Network from Clusters";
    public static String ATTRIBUTENAME = "Create New Network from Attributes";
    public static String CLUSTERSHORTNAME = "clusterview";
    public static String ATTRSHORTNAME = "attributeview";
    @Tunable(description="Network to look for cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public NewNetworkViewContext context = null;

    public NewNetworkView(CyNetwork network, ClusterManager manager) {
        this(null, manager, true);
        this.network = network;
    }

    public NewNetworkView(CyNetwork network, ClusterManager manager, boolean available, boolean restoreEdges) {
        this(null, manager, true);
        this.network = network;
        this.restoreEdges = restoreEdges;
    }

    public NewNetworkView(NewNetworkViewContext context, ClusterManager manager, boolean available) {
        this.manager = manager;
        this.checkForAvailability = available;
        if (this.network == null) {
            this.network = manager.getNetwork();
        }
        if (!this.checkForAvailability) {
            this.context = context;
            context.setNetwork(this.network);
        } else {
            this.context = null;
        }
        this.edgeConverterList = new EdgeAttributeHandler(this.network, false);
    }

    public void setVisible(boolean visibility) {
    }

    public String getAppName() {
        return appName;
    }

    @Override
    public String getShortName() {
        if (this.checkForAvailability) {
            return CLUSTERSHORTNAME;
        }
        return ATTRSHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        if (this.checkForAvailability) {
            return CLUSTERNAME;
        }
        return ATTRIBUTENAME;
    }

    @Override
    public ClusterResults getResults() {
        return null;
    }

    @Override
    public void run(TaskMonitor monitor) {
        monitor.setTitle("Creating a new network view with cluster results");
        if (this.isAvailable()) {
            this.createClusteredNetwork(this.clusterAttribute, monitor);
        }
    }

    @Override
    public boolean isAvailable() {
        if (!this.checkForAvailability) {
            this.clusterAttribute = (String)this.context.attribute.getSelectedValue();
            return true;
        }
        boolean available = NewNetworkView.isReady(this.network, this.manager);
        this.clusterAttribute = (String)this.network.getRow((CyIdentifiable)this.network, "LOCAL_ATTRS").get("__clusterAttribute", String.class);
        return available;
    }

    public static boolean isReady(CyNetwork network, ClusterManager manager) {
        String clusterAttribute;
        if (network == null) {
            return false;
        }
        CyTable networkTable = network.getTable(CyNetwork.class, "LOCAL_ATTRS");
        if (!CyTableUtil.getColumnNames((CyTable)networkTable).contains("__clusterType")) {
            return false;
        }
        String cluster_type = (String)network.getRow((CyIdentifiable)network, "LOCAL_ATTRS").get("__clusterType", String.class);
        if (!(manager.getAlgorithm(cluster_type) == null || manager.getAlgorithm(cluster_type) != null && manager.getAlgorithm(cluster_type).getTypeList().contains((Object)ClusterTaskFactory.ClusterType.NETWORK))) {
            return false;
        }
        return CyTableUtil.getColumnNames((CyTable)networkTable).contains("__clusterAttribute") && (clusterAttribute = (String)network.getRow((CyIdentifiable)network, "LOCAL_ATTRS").get("__clusterAttribute", String.class)) != null;
    }

    public ClusterViz getVisualizer() {
        return this;
    }

    @Override
    public NewNetworkViewContext getContext() {
        return this.context;
    }

    public void cancel() {
    }

    private void createClusteredNetwork(String clusterAttribute, TaskMonitor monitor) {
        boolean isFuzzy = this.isFuzzy(clusterAttribute);
        Map<String, String> params = this.getParams();
        ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
        Map<Integer, List<CyNode>> clusterMap = this.getClusterMap(clusterAttribute, nodeList);
        EdgeWeightConverter converter = this.edgeConverterList.getConverter(this.getParam(params, "converter"));
        String dataAttribute = this.getParam(params, "dataAttribute");
        double cutOff = 0.0;
        if (this.getParam(params, "edgeCutOff") != null) {
            cutOff = Double.parseDouble(this.getParam(params, "edgeCutOff"));
        }
        HashMap<CyEdge, CyEdge> edgeMap = new HashMap<CyEdge, CyEdge>();
        ArrayList<CyEdge> edgeList = new ArrayList<CyEdge>();
        for (Integer cluster2 : clusterMap.keySet()) {
            List<CyNode> clusterNodes = clusterMap.get(cluster2);
            List<CyEdge> connectingEdges = ModelUtils.getConnectingEdges(this.network, clusterNodes);
            for (CyEdge edge : connectingEdges) {
                if (converter != null && dataAttribute != null && this.edgeWeightCheck(edge, dataAttribute, converter, cutOff)) continue;
                edgeMap.put(edge, edge);
                ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)edge, clusterAttribute, new Integer(1), Integer.class, null);
                edgeList.add(edge);
            }
        }
        VisualStyle style = ViewUtils.getCurrentVisualStyle(this.manager);
        CyNetwork newNetwork = ModelUtils.createChildNetwork(this.manager, this.network, nodeList, edgeList, "--clustered");
        ModelUtils.copyLocalColumn(this.network, newNetwork, CyNode.class, clusterAttribute);
        ModelUtils.copyLocalColumn(this.network, newNetwork, CyNetwork.class, "__clusterType");
        ModelUtils.copyLocalColumn(this.network, newNetwork, CyNetwork.class, "__clusterAttribute");
        ModelUtils.copyLocalColumn(this.network, newNetwork, CyNetwork.class, "__clusterParams");
        if (isFuzzy && ModelUtils.hasAttribute(this.network, (CyIdentifiable)this.network, "__fuzzifierSeed")) {
            ModelUtils.copyLocalColumn(this.network, newNetwork, CyNetwork.class, "__fuzzifierSeed");
            String seedAttribute = (String)this.network.getRow((CyIdentifiable)this.network, "LOCAL_ATTRS").get("__fuzzifierSeed", String.class);
            ModelUtils.copyLocalColumn(this.network, newNetwork, CyNode.class, seedAttribute);
        }
        CyNetworkView view = ViewUtils.createView(this.manager, newNetwork, false);
        ViewUtils.doLayout(this.manager, view, monitor, "force-directed");
        if (this.restoreEdges || this.context != null && this.context.restoreEdges) {
            for (CyEdge edge : this.network.getEdgeList()) {
                if (edgeMap.containsKey(edge)) continue;
                ((CySubNetwork)view.getModel()).addEdge(edge);
                ModelUtils.createAndSetLocal((CyNetwork)view.getModel(), (CyIdentifiable)edge, clusterAttribute, new Integer(0), Integer.class, null);
            }
            style = this.styleNewView(style, clusterAttribute);
        }
        ViewUtils.setVisualStyle(this.manager, view, style);
        if (isFuzzy) {
            long fuzzyClusterTableSUID = (Long)this.network.getRow((CyIdentifiable)this.network).get(clusterAttribute + "_Table.SUID", Long.class);
            newNetwork.getRow((CyIdentifiable)newNetwork).set(clusterAttribute + "_Table.SUID", (Object)fuzzyClusterTableSUID);
            CyTable fuzzyClusterTable = this.manager.getTableManager().getTable(fuzzyClusterTableSUID);
            this.createMembershipEdges(newNetwork, view, this.manager, fuzzyClusterTable);
        }
        ViewUtils.registerView(this.manager, view);
    }

    private Map<Integer, List<CyNode>> getClusterMap(String clusterAttribute, List<CyNode> nodeList) {
        boolean isFuzzy = this.network.getTable(CyNode.class, "LOCAL_ATTRS").getColumn(clusterAttribute).getType().equals(List.class);
        HashMap<Integer, List<CyNode>> clusterMap = new HashMap<Integer, List<CyNode>>();
        for (CyNode node : this.network.getNodeList()) {
            if (ModelUtils.hasAttribute(this.network, (CyIdentifiable)node, clusterAttribute)) {
                if (isFuzzy) {
                    List clusterList = this.network.getRow((CyIdentifiable)node).getList(clusterAttribute, Integer.class);
                    for (Integer cluster2 : clusterList) {
                        this.addNodeToMap(clusterMap, cluster2, node);
                    }
                } else {
                    Integer cluster3 = (Integer)this.network.getRow((CyIdentifiable)node).get(clusterAttribute, Integer.class);
                    this.addNodeToMap(clusterMap, cluster3, node);
                }
            }
            nodeList.add(node);
        }
        return clusterMap;
    }

    private VisualStyle styleNewView(VisualStyle style, String clusterAttribute) {
        VisualStyle newStyle = ViewUtils.copyStyle(this.manager, style, "--clustered");
        VisualMappingFunctionFactory vmff = this.manager.getService(VisualMappingFunctionFactory.class);
        DiscreteMapping edgeWidth = (DiscreteMapping)vmff.createVisualMappingFunction(clusterAttribute, Integer.class, BasicVisualLexicon.EDGE_WIDTH);
        edgeWidth.putMapValue((Object)new Integer(0), (Object)new Double(1.0));
        edgeWidth.putMapValue((Object)new Integer(1), (Object)new Double(5.0));
        DiscreteMapping edgeTrans = (DiscreteMapping)vmff.createVisualMappingFunction(clusterAttribute, Integer.class, BasicVisualLexicon.EDGE_TRANSPARENCY);
        edgeTrans.putMapValue((Object)new Integer(0), (Object)new Integer(50));
        edgeTrans.putMapValue((Object)new Integer(1), (Object)new Integer(255));
        newStyle.addVisualMappingFunction((VisualMappingFunction)edgeWidth);
        newStyle.addVisualMappingFunction((VisualMappingFunction)edgeTrans);
        return newStyle;
    }

    private void addNodeToMap(Map<Integer, List<CyNode>> map, Integer cluster2, CyNode node) {
        if (!map.containsKey(cluster2)) {
            map.put(cluster2, new ArrayList());
        }
        map.get(cluster2).add(node);
    }

    private boolean edgeWeightCheck(CyEdge edge, String dataAttribute, EdgeWeightConverter converter, double cutoff) {
        if (!ModelUtils.hasAttribute(this.network, (CyIdentifiable)edge, dataAttribute)) {
            return false;
        }
        Class type = this.network.getRow((CyIdentifiable)edge).getTable().getColumn(dataAttribute).getType();
        if (!type.isAssignableFrom(Number.class)) {
            return false;
        }
        double val = ((Number)this.network.getRow((CyIdentifiable)edge).get(dataAttribute, type)).doubleValue();
        return !(converter.convert(val, 0.0, Double.MAX_VALUE) > cutoff);
    }

    Map<String, String> getParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!ModelUtils.hasAttribute(this.network, (CyIdentifiable)this.network, "__clusterParams")) {
            return map;
        }
        List params = this.network.getRow((CyIdentifiable)this.network).getList("__clusterParams", String.class);
        for (String param : params) {
            String[] attr = param.split("=");
            if (attr.length != 2) continue;
            map.put(attr[0], attr[1]);
        }
        return map;
    }

    String getParam(Map<String, String> params, String key) {
        if (!params.containsKey(key)) {
            return null;
        }
        return params.get(key);
    }

    private void createMembershipEdges(CyNetwork network, CyNetworkView networkView, ClusterManager manager, CyTable fuzzyClusterTable) {
        ArrayList clusterList = new ArrayList();
        int numC = fuzzyClusterTable.getColumns().size() - 1;
        for (int i = 0; i < numC; ++i) {
            clusterList.add(new ArrayList());
        }
        List nodeList = network.getNodeList();
        for (CyNode node : nodeList) {
            CyRow nodeRow = fuzzyClusterTable.getRow((Object)node.getSUID());
            for (int i = 1; i <= numC; ++i) {
                if (nodeRow.get("Cluster_" + i, Double.class) == null) continue;
                ((List)clusterList.get(i - 1)).add(node);
            }
        }
        CyTable localTable = network.getTable(CyNode.class, "LOCAL_ATTRS");
        localTable.createColumn("isFClusterNode", Boolean.class, false, (Object)Boolean.FALSE);
        int clusterNumber = 0;
        for (List list : clusterList) {
            CyNode centroid = network.addNode();
            ++clusterNumber;
            network.getRow((CyIdentifiable)centroid).set("name", (Object)("FCluster" + clusterList.indexOf(list)));
            network.getRow((CyIdentifiable)centroid).set("isFClusterNode", (Object)Boolean.TRUE);
            double x = 1.0E-4;
            double y = 1.0E-4;
            double count = 0.0;
            ArrayList<CyEdge> membershipEdges = new ArrayList<CyEdge>();
            for (CyNode node : list) {
                View nodeView = networkView.getNodeView(node);
                x += ((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION)).doubleValue();
                y += ((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)).doubleValue();
                count += 1.0;
                CyEdge membershipEdge = network.addEdge(centroid, node, false);
                ModelUtils.createAndSetLocal(network, (CyIdentifiable)membershipEdge, "MembershipEdge", Boolean.TRUE, Boolean.class, null);
                Double membership = (Double)fuzzyClusterTable.getRow((Object)node.getSUID()).get("Cluster_" + clusterNumber, Double.class);
                ModelUtils.createAndSetLocal(network, (CyIdentifiable)membershipEdge, "Membership_%", 100.0 * membership, Double.class, null);
                membershipEdges.add(membershipEdge);
            }
            networkView.updateView();
            if (count != 0.0) {
                x /= count;
                y /= count;
            }
            View centroidView = networkView.getNodeView(centroid);
            centroidView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)x);
            centroidView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)y);
            this.membershipEdgeStyle(networkView, clusterNumber, membershipEdges, fuzzyClusterTable);
        }
        networkView.updateView();
    }

    private void membershipEdgeStyle(CyNetworkView networkView, int cNum, List<CyEdge> edgeList, CyTable fuzzyClusterTable) {
        for (CyEdge edge : edgeList) {
            View edgeView = networkView.getEdgeView(edge);
            CyNode node = edge.getTarget();
            edgeView.setLockedValue(BasicVisualLexicon.EDGE_LINE_TYPE, (Object)LineTypeVisualProperty.DASH_DOT);
            edgeView.setLockedValue(BasicVisualLexicon.EDGE_TRANSPARENCY, (Object)((int)((Double)fuzzyClusterTable.getRow((Object)node.getSUID()).get("Cluster_" + cNum, Double.class) * 255.0)));
        }
    }

    private boolean isFuzzy(String clusterAttribute) {
        CyColumn column = this.network.getTable(CyNode.class, "LOCAL_ATTRS").getColumn(clusterAttribute);
        if (column == null) {
            return false;
        }
        return column.getType().equals(List.class);
    }
}

